#include "options.inc"


c  with Southern Ocean and wind stress

      subroutine set_parameter
c----------------------------------------------------------------------
c     set variable parameter
c----------------------------------------------------------------------
      use shallow_module
      implicit none

      ny=512
c     set resolution and time stepping
      dy=20e3
      y_0 = -ny/2*dy
      Ly=ny*dy
      dt_in=1200.0 
      runlen =  360*200
      snap_int = 30! 360

      beta  = 2.*omega/radius   
      r=2e-6
      lambda=1e-9
c      lambda=3e-8
      delta=r/beta
      Delta_x = (ny/4)*dy-2*dy
      H0=400.
      gprime=0.02
      K_gm = 1000.
      N_0 = 2e-3
      end subroutine set_parameter


      subroutine setup_forcing
      use shallow_module
      implicit none
      integer :: i,j,nx,indp
      real :: y,Lx,dx,fxa
      real, allocatable :: xt(:),xu(:)


c     generate grid in zonal direction 
      dx=dy; nx=ny/4; Lx=nx*dx
      allocate( xt(nx), xu(nx) )
      do j=1,ny
       do i=1,nx
        xt(i)=(i-nx/2)*dx; xu(i)=(i-nx/2)*dx+dx/2
       enddo
      enddo

c     deepwater source: northern sinking
      q=0
      do j=1,ny
       do i=1,nx
        q(j)=q(j)+80e6/(200e3**2)*exp(
     &           -(xt(i)-(xt(2 )-00e3))**2/40e3**2
     &           -(yt(j)-(yt(ny)-40e3))**2/40e3**2 )
       enddo
       q(j)=q(j)/nx
      enddo
      deallocate(xt,xu)

c     Southern ocean
      mask_SO=0.
      j=indp(yt(1)+Delta_x, yt,ny)
      mask_SO(2:j)=1.

c     wind stress
      do j=2,ny-1
       taux(j)=-2e-4*cos((yt(j)-Delta_x/2.)/Delta_x*pi)*mask_SO(j)
       taux(j)=min(0.,taux(j))
      enddo
      end  subroutine setup_forcing


