#include "options.inc"



      subroutine diagnose
c-----------------------------------------------------------------------
c     diagnostics
c-----------------------------------------------------------------------
      use shallow_module
      implicit none
      integer :: j
      real :: totke,tbar
      real :: area,fx,cfl,umax
      character (len=32) :: stamp

      if (snapshot_time_step) then
      umax=0. ;totke = 0.;tbar=0.;area = 0.
      do j=2,ny-1
       umax=max(umax,sqrt(u(j)**2+v(j)**2))
       totke = totke+sqrt(u(j)**2+v(j)**2)*dy*H0
       tbar  = tbar +h(j)*H0*dy
      enddo
      area  = H0*dy*ny
      CFL = abs(umax*dt_in/dy)
      totke = totke/area
      tbar  = tbar/area
      call set_stamp(stamp,get_current_time())
      print'(a,i5,a,a,a,f12.8,a,e14.7,a,e14.7)',
     &    ' itt=',itt,'  ',stamp,' CFL max = ',CFL,
     &    ' mean ke = ',totke,' mean h = ',tbar
        call diag_snap
      endif
      call sub_flush(6)
      end subroutine diagnose


      subroutine init_snap_cdf
c-----------------------------------------------------------------------
c     initialize NetCDF snapshot file
c-----------------------------------------------------------------------
      use shallow_module
      implicit none
#include "netcdf.inc"
      integer :: ncid,iret
      integer :: lat_tdim,itimedim
      integer :: lat_tid,itimeid
      integer :: lat_udim,lat_uid
      integer :: biid,bbid,ubid,vbid,viid,qid,uiid
      integer :: dims(4),bid,uid,vid,tauxid,lid
      character :: name*24, unit*16
      real :: spval=-9.9e12

      ncid = nccre ('shallow.cdf', NCCLOB, iret)
      iret=nf_set_fill(ncid, NF_NOFILL, iret)
c     dimensions
      Lat_tdim  = ncddef(ncid, 'yt', ny, iret)
      Lat_udim  = ncddef(ncid, 'yu', ny, iret)
      iTimedim  = ncddef(ncid, 'Time', nf_unlimited, iret)
c     grid variables
      Lat_tid  = ncvdef (ncid,'yt',NCFLOAT,1,lat_tdim,iret)
      Lat_uid  = ncvdef (ncid,'yu',NCFLOAT,1,lat_udim,iret)
      itimeid  = ncvdef (ncid,'Time', NCFLOAT,1,itimedim,iret)
c     2 dim variables on t grid
      dims = (/lat_tdim,iTimedim,1,1/)
      biid = ncvdef (ncid,'hi', NCFLOAT,2,dims,iret)
      bbid = ncvdef (ncid,'hb', NCFLOAT,2,dims,iret)
      bid  = ncvdef (ncid,'h', NCFLOAT,2,dims,iret)
      qid  = ncvdef (ncid,'q', NCFLOAT,1,dims,iret)
      dims = (/lat_tdim,iTimedim,1,1/)
      ubid = ncvdef (ncid,'ub', NCFLOAT,2,dims,iret)
      uiid = ncvdef (ncid,'ui', NCFLOAT,2,dims,iret)
      uid  = ncvdef (ncid,'u', NCFLOAT,2,dims,iret)
      dims = (/lat_udim,iTimedim,1,1/)
      vbid = ncvdef (ncid,'vb', NCFLOAT,2,dims,iret)
      viid = ncvdef (ncid,'vi', NCFLOAT,2,dims,iret)
      vid  = ncvdef (ncid,'v', NCFLOAT,2,dims,iret)

      tauxid  = ncvdef (ncid,'taux', NCFLOAT,1,lat_tdim,iret)
      lid     = ncvdef (ncid,'L_r', NCFLOAT,1,lat_tdim,iret)
c     attributes of the grid
      name = 'Latitude on T grid     '; unit = 'km'
      call ncaptc(ncid, Lat_tid, 'long_name', NCCHAR, 24, name, iret) 
      call ncaptc(ncid, Lat_tid, 'units',     NCCHAR, 16, unit, iret) 
      name = 'Latitude on U grid     '; unit = 'km'
      call ncaptc(ncid, Lat_uid, 'long_name', NCCHAR, 24, name, iret) 
      call ncaptc(ncid, Lat_uid, 'units',     NCCHAR, 16, unit, iret) 
      name = 'Time '; unit = 'days'
      call ncaptc(ncid, itimeid, 'long_name', NCCHAR, 24, name, iret) 
      call ncaptc(ncid, itimeid, 'units',     NCCHAR, 16, unit, iret) 
      call ncaptc(ncid, iTimeid,'time_origin',NCCHAR, 20,
     &  '01-JAN-1900 00:00:00', iret)

c     attributes of variables
      name = 'Height  '; unit = 'm'
      call dvcdf(ncid,biid,name,24,unit,16,spval)
      call dvcdf(ncid,bbid,name,24,unit,16,spval)
      call dvcdf(ncid,bid,name,24,unit,16,spval)
      name = 'Zonal velocity'; unit = 'm/s'
      call dvcdf(ncid,ubid,name,24,unit,16,spval)
      call dvcdf(ncid,uiid,name,24,unit,16,spval)
      call dvcdf(ncid,uid,name,24,unit,16,spval)
      name = 'Meridional velocity'; unit = 'm/s'
      call dvcdf(ncid,vbid,name,24,unit,16,spval)
      call dvcdf(ncid,viid,name,24,unit,16,spval)
      call dvcdf(ncid,vid,name,24,unit,16,spval)
      name = 'Zonal wind stress'; unit = 'm^2/s^2'
      call dvcdf(ncid,tauxid,name,24,unit,16,spval)
      name = 'Rossby radius'; unit = 'm'
      call dvcdf(ncid,lid,name,24,unit,16,spval)

      call ncendf(ncid, iret)
      iret= nf_put_vara_double(ncid,lat_tid,1,ny,yt/1e3)
      iret= nf_put_vara_double(ncid,lat_uid,1,ny,yu/1e3)
      iret= nf_put_vara_double(ncid,qid,1,ny,q)
      iret= nf_put_vara_double(ncid,tauxid,1,ny,taux)
      iret= nf_put_vara_double(ncid,lid,1,ny,L_r)
      call ncclos (ncid, iret)
      end subroutine init_snap_cdf


      subroutine diag_snap
c-----------------------------------------------------------------------
c     write to NetCDF snapshot file
c-----------------------------------------------------------------------
      use shallow_module
      implicit none
#include "netcdf.inc"
      integer :: ncid,iret,n,corner(3), edges(3)
      real :: spval=-9.9e12
      integer :: itdimid,ilen,biid,bbid,itimeid,ubid,vbid
      integer :: viid,uiid,bid,vid,uid
      real :: fxa
      type (time_type) :: time

      iret=nf_open('shallow.cdf',NF_WRITE,ncid)
      iret=nf_set_fill(ncid, NF_NOFILL, iret)

      iret=nf_inq_varid(ncid,'h',bid)
      iret=nf_inq_varid(ncid,'u',uid)
      iret=nf_inq_varid(ncid,'v',vid)
      iret=nf_inq_varid(ncid,'hi',biid)
      iret=nf_inq_varid(ncid,'hb',bbid)
      iret=nf_inq_varid(ncid,'ub',ubid)
      iret=nf_inq_varid(ncid,'ui',uiid)
      iret=nf_inq_varid(ncid,'vb',vbid)
      iret=nf_inq_varid(ncid,'vi',viid)
      iret=nf_inq_dimid(ncid,'Time',itdimid)
      iret=nf_inq_dimlen(ncid, itdimid,ilen)
      iret=nf_inq_varid(ncid,'Time',itimeid)
      ilen=ilen+1
      time = get_current_time()-initial_time
      fxa = time%days + time%seconds/86400. 
      print*,' writing a snapshot at stamp=',current_stamp,
     &          ' (days since origin : ',fxa,')',
     &          ' (time steps in file : ',ilen,')'

      iret= nf_put_vara_double(ncid,itimeid,ilen,1,fxa)
      Corner = (/1,ilen,1/); edges  = (/ny,1,1/)
      iret= nf_put_vara_double(ncid,bid,corner,edges,h)
      iret= nf_put_vara_double(ncid,uid,corner,edges,u)
      iret= nf_put_vara_double(ncid,vid,corner,edges,v)
      iret= nf_put_vara_double(ncid,biid,corner,edges,hi(:,tau))
      iret= nf_put_vara_double(ncid,bbid,corner,edges,hb(:,tau))
      iret= nf_put_vara_double(ncid,ubid,corner,edges,ub(:,tau))
      iret= nf_put_vara_double(ncid,vbid,corner,edges,vb(:,tau))
      iret= nf_put_vara_double(ncid,viid,corner,edges,vi(:,tau))
      iret= nf_put_vara_double(ncid,uiid,corner,edges,ui(:,tau))
      call ncclos (ncid, iret)
      end subroutine diag_snap



      subroutine dvcdf(ncid,ivarid,name,iname,unit,iunit,spval)
c-----------------------------------------------------------------------
c     define some standard attributes of variable ivarid in NetCDF file ncid 
c-----------------------------------------------------------------------
      implicit none
      integer ncid,ivarid,iname,iunit,iret
      character (len=*) :: name, unit
      real :: spval
      real :: vv
#include "netcdf.inc"
      vv=spval
      call ncaptc(ncid,ivarid, 'long_name', NCCHAR,iname , name, iret) 
        if (iret.ne.0) print*,nf_strerror(iret)
      call ncaptc(ncid,ivarid, 'units',     NCCHAR,iunit, unit, iret) 
        if (iret.ne.0) print*,nf_strerror(iret)
c      call ncapt (ncid,ivarid, 'missing_value',NCFLOAT,1,vv,iret)
      call ncapt (ncid,ivarid, 'missing_value',NCDOUBLE,1,vv,iret)
        if (iret.ne.0) print*,nf_strerror(iret)
c      call ncapt (ncid,ivarid, '_FillValue', NCFLOAT, 1,vv, iret)
      call ncapt (ncid,ivarid, '_FillValue', NCDOUBLE, 1,vv, iret)
        if (iret.ne.0) print*,nf_strerror(iret)
      end subroutine dvcdf

