#include "options.inc"

      module shallow_module
c----------------------------------------------------------------------
c     main module for parameter and variables
c----------------------------------------------------------------------
      use timing_module
      use time_manager_module
      implicit none
c   fixed parameters
      real, parameter :: version = 0.2 ! version
      real, parameter :: radius   = 6370.0e3 ! earth radius in meter
      real, parameter :: pi       = 
     &        3.14159265358979323846264338327950588
      real, parameter :: omega    = pi/43082.0 ! earth rotation frequency in 1/s
c   model parameters
      integer :: ny=-1! number of grid points in meridional direction
      real :: dt_in   ! time step in seconds
      real :: dy      ! grid resolution in meridional direction in meter
      real :: y_0     ! start point for grid in meridional direction in meter
      real :: Ly      ! total meridional length of domain in meter
      real :: beta    ! parameter for beta-plane in 1/(ms) 
      real :: r       ! (interior) Rayleigh friction coefficient in 1/s
      real :: H0      ! mean layer thickness in meter
      real :: gprime  ! reduced gravity in m/s^2
      real :: lambda  ! coefficient for vertical mixing in 1/s
      real :: K_gm    ! isopycnal thickness diffusivity in m^2/s
      real :: N_0     ! mean background stratification in 1/s
      real :: gamma=0.01 ! parameter for roberts time filtering
c     time manager stuff
      real :: runlen = 1*360. ! length of simulation in days
      real :: snap_int = 1.   ! period of output in days
      character (len=32) ::   ! date of time origin
     &         restart_stamp ='m/d/y=01/01/1900, h:m:s=00:00:00' 
c   model variables
      real,allocatable :: u(:,:) ! zonal velocity  in m/s
      real,allocatable :: v(:,:) ! meridional velocity  in m/s
      real,allocatable :: h(:,:) ! layer thickness in meter
      real,allocatable :: q(:)      ! deepwater source term in m/s
      real,allocatable :: yt(:)  ! meridional axis at t-grid points in meter
      real,allocatable :: yu(:)  ! meridional axis at u-grid points in meter
      real,allocatable :: coriolis_t(:) ! coriolis parameter at t-grid points in 1/s
      real,allocatable :: mask_SO(:) ! mask for Southern Ocean part
      real,allocatable :: taux(:)    ! surface wind stress in m^2/s^2
      real,allocatable :: L_r(:)     ! Rossby radius in m
      real :: gamma1=1.0, gamma2=1.0 ! closure parameter
      real :: delta    ! western boundary layer width in meter
      real :: Delta_x  ! interior width in meter
      integer :: j_eq = 0  ! index where yt=0.0
      end module shallow_module


      subroutine  allocate_shallow_module
c----------------------------------------------------------------------
c     allocate model variables
c----------------------------------------------------------------------
      use shallow_module
      implicit none
      allocate( u(ny,0:2) ); u=0.0
      allocate( v(ny,0:2) ); v=0.0
      allocate( h(ny,0:2) ); h=0.0
      allocate( q(ny) ); q=0.0
      allocate( yt(ny) ); yt=0.0
      allocate( yu(ny)  ); yu=0.0
      allocate( coriolis_t(ny) ); coriolis_t=0.0
      allocate( mask_SO(ny) ); mask_SO=0.0
      allocate( taux(ny) ); taux=0.0
      allocate( L_r(ny) ); L_r=0.0
      end subroutine  allocate_shallow_module
