#include "options.inc"


c  with Southern Ocean with wind stress and northern sinking
#define RESOLVE 0.5
#define vRESOLVE 0.5

      subroutine  set_parameter
c----------------------------------------------------------------------
c     set parameters here
c----------------------------------------------------------------------
      use deep_module
      implicit none


      ny=128 *RESOLVE
      nz=20  *vRESOLVE
c     set resolution and time stepping
      dy=80e3 /RESOLVE
      dt_in=4800.0 /RESOLVE
      dz=50.0 /vRESOLVE
      runlen = 360*200
      snap_int =   360.! 360

c     set all physical parameter
      beta  = 2.*omega/radius   
      y_0 = -ny/2*dy
      r=2e-6 /RESOLVE
      delta=r/beta
      Delta_x = (ny/4-2)*dy
      r_b = 0e-5           ! bottom friction coeff
      surf_rest=30.*86400. ! surface restoring time scale

      A_h=3.2e4 /RESOLVE**2! u_t = A u_xx,  1/T = A /L^2 
      A_v=1e-3
      K_h=0
      K_v=1e-4
      K_gm=1000.0

      eps_sor=1e-6
      end  subroutine  set_parameter


      subroutine  setup_forcing
c----------------------------------------------------------------------
c     configure forcing here
c----------------------------------------------------------------------
      use deep_module
      implicit none
      integer :: j,k,indp
      real :: db,y2,y0

c     Southern ocean
      mask_SO=0.
      j=indp(yt(1)+Delta_x, yt,ny)
      mask_SO(2:j)=1.
      y0=yt(j)

c     wind forcing
      do j=2,ny-1
       taux(j)=2e-4*cos((yt(j)-y0)/(yt(1)-y0)*pi-pi/2.)*mask_SO(j)
       taux(j)=max(0.,taux(j))
      enddo

#ifdef notdef
c     surface forcing
      db = 30e-3;bstar=db
      do j=1,ny
       if (yt(j)<-Ly/4.0) then
        bstar(j)=db*(yt(j)+Ly/2.)/(Ly/4.0)
       endif
       y2=Ly/2.*0.75
       if (yt(j)>y2) then
        bstar(j)=db*(1-(yt(j)-y2)/(yt(ny)-y2) )
       endif
      enddo
#else
c     surface forcing
      bstar=0./1024.*9.81
      j=indp(yt(1)+3.*delta,yt,ny)
c     northern sinking region
      bstar(ny-j:ny)=-0.025
#endif


      end subroutine  setup_forcing





      subroutine setup_topography
c----------------------------------------------------------------------
c     configure topography here
c----------------------------------------------------------------------
      use deep_module
      implicit none
      end subroutine setup_topography
 



      subroutine time_dependent_forcing
c----------------------------------------------------------------------
c     place time dependent forcing here
c----------------------------------------------------------------------
      use deep_module
      implicit none
      end subroutine time_dependent_forcing
 
