#include "options.inc"

c choose one of the following setups
c#include "ACC1_setup.F"
#include "St-Arons_setup.F"

      program driver
c----------------------------------------------------------------------
c     main driver
c----------------------------------------------------------------------
      use shallow_module
      implicit none
      call setup
 20    continue
        call time_step_begin()
        call integrate
        call diagnose
        call time_step_end()
       if (.not. end_of_run ) goto 20
      end program driver


      subroutine setup
c----------------------------------------------------------------------
c     setup everything
c----------------------------------------------------------------------
      use shallow_module
      implicit none
      integer :: j,indp
      real :: fxa

      print*,''
      print*,'--------------------------------------------------'
      print*,' setting up simple model version ',version
      print*,'--------------------------------------------------'
      print*,''

      call set_parameter

      print*,' Domain is ',ny,' grid points'
      print*,' Horizontal resolution is ',dy/1e3,' km '
      print*,' Domain extent is     ',ny*dy/1e3, ' km'
      print*,' Domain starts at y = ',y_0/1e3,' km'
      print*,' Domain ends at y =   ',(y_0+ny*dy)/1e3,' km'
      print*,' r       = ',r,' 1/s'
      print*,' H0      = ',H0,' m' 
      print*,' gprime  = ',gprime,' 1/s'
      print*,' lambda  = ',lambda,' 1/s'
      print*,' beta = ',beta,' 1/ms'
      print*,' delta= ',delta/1e3,' km'
      print*,' Delta x = ',Delta_x/1e3,' km'
      print*,' Wright and Stocker version '
      call allocate_shallow_module

c     generate grid 
      do j=1,ny
        yt(j)=y_0+j*dy; yu(j)=yt(j)+dy/2
      enddo
c     Coriolis parameter and Rossby radius
      do j=1,ny
       coriolis_t(j)=beta*yt(j)
       L_r(j) = N_0*H0/(1e-6+abs(coriolis_t(j)))
      enddo
c     find equator
      j_eq=indp(0.0,yt,ny)
      if (yt(j_eq)/=0.0) then
        print*,' Error: cannot find equator '
        stop
      endif

      call setup_forcing

c     check stability criterion
      fxa=0
      do j=1,ny
       fxa=max(fxa,K_gm/L_r(j)**2)
       if (fxa>1./dt_in) then
        print*,' K_gm too large at j=',j
        stop
       endif
      enddo
      print*,' maximal K_gm/L_r^2= ',fxa,' 1/s'
      print*,' which is smaller than 1/dt=',1./dt_in,' 1/s'

      call init_time_manager(dt_in,runlen,snap_int,restart_stamp,0 )
      call disable_mixing_time_steps
      call init_snap_cdf()
      end subroutine setup


      subroutine integrate
c----------------------------------------------------------------------
c     integrate momentum and layer thickness
c----------------------------------------------------------------------
      use shallow_module
      implicit none
      integer :: j
c
c     momentum 
      do j=2,ny-2
        v(j,taup1)=v(j,taum1)+c2dt*(
     &       -gprime*(h(j+1,tau)-h(j,tau))/dy 
     &     -r*v(j,taum1) )
      enddo
c     integrate thickness budget
      do j=2,ny-1
       h(j,taup1) = h(j,taum1)+c2dt*(
     &    q(j)-lambda*h(j,taum1)
     &   -H0*(v(j,tau)-v(j-1,tau))/dy
     &       )
      enddo
c     roberts time filter
      h(:,tau) = h(:,tau) + gamma*
     &       (0.5*(h(:,taup1) + h(:,taum1)) - h(:,tau)) 
      v(:,tau) = v(:,tau) + gamma*
     &       (0.5*(v(:,taup1) + v(:,taum1)) - v(:,tau)) 
      end subroutine integrate


