#include "options.inc"

c     classical Stommel Arons setup with deepwater sources
c     in the north, south or at the equator
#define northern_sinking
c#define southern_sinking
c#define equatorial_sinking

      subroutine set_parameter
c----------------------------------------------------------------------
c     set variable parameter
c----------------------------------------------------------------------
      use shallow_module
      implicit none

      ny=512
c     set resolution and time stepping
      dy=20e3
      y_0 = -ny/2*dy
      Ly=ny*dy
      dt_in=1200.0*2
      runlen =  360*200
      snap_int = 360

      beta  = 2.*omega/radius   
      r=2e-6
      lambda=1e-9
c      lambda=3e-8
c      lambda=6e-7
      delta=r/beta
      Delta_x = (ny/4)*dy-2*dy-delta
      H0=400.
      gprime=0.02
      K_gm = 0000.
      N_0 = (gprime/H0 )**0.5

      gamma2=1.0 
      gamma1=1.0

      end subroutine set_parameter


      subroutine setup_forcing
      use shallow_module
      implicit none
      integer :: i,j,nx,indp
      real :: y,Lx,dx,fxa
      real, allocatable :: xt(:),xu(:)

c     generate grid in zonal direction 
      dx=dy; nx=ny/4; Lx=nx*dx
      allocate( xt(nx), xu(nx) )
      do j=1,ny
       do i=1,nx
        xt(i)=(i-nx/2)*dx; xu(i)=(i-nx/2)*dx+dx/2
       enddo
      enddo

c     deepwater source
      q=0
      do j=1,ny
       do i=1,nx
#ifdef northern_sinking
        q(j)=q(j)+65e6/(200e3**2)*exp(
     &           -(xt(i)-(xt(2 )-00e3))**2/40e3**2
     &           -(yt(j)-(yt(ny)-40e3))**2/40e3**2 )
#endif
#ifdef southern_sinking
        q(j)=q(j)+60e6/(200e3**2)*exp(
     &           -(xt(i)-(xt(2 )-00e3))**2/40e3**2
     &           -(yt(j)-(yt(1)+40e3))**2/40e3**2 )
#endif
#ifdef equatorial_sinking
c        q(j)=q(j)+60e6/(200e3**2)*exp(
        q(j)=q(j)+65e6/(200e3**2)*exp(
     &           -(xt(i)-(xt(2 )-00e3))**2/40e3**2
     &           -(yt(j)-(yt(ny/2)+0e3))**2/40e3**2 )
#endif
       enddo
       q(j)=q(j)/nx
      enddo
      deallocate(xt,xu)

c     Southern ocean
      mask_SO=0.

c     wind stress
      do j=2,ny-1
       taux(j)=0
      enddo
      end  subroutine setup_forcing


