#include "options.inc"

      module deep_module
c----------------------------------------------------------------------
c     main module for parameter and variables
c----------------------------------------------------------------------
      use timing_module
      use time_manager_module
      implicit none
c   fixed parameters
      real, parameter :: version = 0.2        ! version number
      real, parameter :: radius   = 6370.0e3  ! earth radius
      real, parameter :: pi       = 
     &        3.14159265358979323846264338327950588
      real, parameter :: omega    = pi/43082.0 ! earth rotation freq. in 1/s
      real, parameter :: epsln = 1.0e-20       ! small number (too small for single prec.)
c   model parameters
      integer :: ny=-1 ! number of grid points in meridional direction
      integer :: nz=-1 ! number of grid points in vertical direction
      real :: dt_in    ! time step in seconds
      real :: dy       ! grid resolution in meridional direction in meter
      real :: y_0      ! start point for grid in meridional direction in meter
      real :: Ly       ! total meridional length of domain in meter
      real :: dz       ! grid resolution in vertical direction in meter
      real :: Lz       ! total vertical extend of domain in meter
      real :: beta     ! parameter for beta-plane in 1/(ms) 
      real :: r        ! (interior) Rayleigh friction coefficient in 1/s
      real :: r_b      ! Bottom friction coefficient in 1/s
      real :: A_h,A_v  ! lateral and vertical harmonic vicosity in m^2/s
      real :: A_hx=0.0 ! zonal harmonic viscosity in m^2/s
      real :: K_h,K_v  ! lateral and vertical harmonic diffusivity in m^2/s
      real :: K_gm     ! isopycnal thickness diffusivity in m^2/s
      real :: N_min     = 1e-5       ! minimal threshold for stability freq. N
      real :: fNsqr_max = 0.01       ! limit f^2/N^2 by this value
      real :: surf_rest         ! surface restoring time scale for buoyancy in s
      real :: surf_rest_salt=0.0! surface restoring coeff. for salinity in m/s
      real :: gamma=0.01 ! parameter for roberts time filtering
c     time manager stuff
      real :: runlen = 1*360. ! length of simulation in days
      real :: snap_int = 1.   ! period of output in days
      character (len=32) ::   ! date of time origin
     &         restart_stamp ='m/d/y=01/01/1900, h:m:s=00:00:00' 
c   model variables
      real, allocatable :: u(:,:,:) ! zonal velocity in m/s
      real, allocatable :: v(:,:,:) ! meridional velocity in m/s
      real, allocatable :: b(:,:,:) ! buoyancy in m/s^2
      real, allocatable :: sal(:,:,:) ! salinity n g/kg
      real, allocatable :: w(:,:)   ! vertical velocity in m/s
      real, allocatable :: p(:,:)   ! complete pressure in m^2/s^2
      real, allocatable :: ph(:,:)  ! pressure from hydrostatic relation in m^2/s^2
      real, allocatable :: ps(:)    ! surface pressure in m^2/s^2

      real, allocatable :: yt(:)  ! meridional axis at t-grid points in meter
      real, allocatable :: yu(:)  ! meridional axis at u-grid points in meter
      real, allocatable :: coriolis_t(:) ! coriolis parameter at t-grid points in 1/s
      real, allocatable :: zt(:) ! vertical axis at t-grid points in meter
      real, allocatable :: zw(:) ! vertical axis at u-grid points in meter
      real, allocatable :: fv(:,:) ! meridional momentum tendency in interior in m/s^2
      real, allocatable :: ht(:) ! water depth at t-grid points in meter
      real, allocatable :: hv(:) ! water depth at v-grid points in meter
      real, allocatable :: bstar(:) ! target surface buoyancy in m/s^2
      real, allocatable :: sstar(:) ! target surface salinity in 1e-3 g/Kg
      real, allocatable :: salt_flux(:) ! surface salt flux in 1e-3 g/Kg m/s
      real, allocatable :: Kv(:,:)! vertical diffusivity due to convection in m^2/s
      real, allocatable :: A_trm(:,:)! vertical viscosity due to meso-scale eddies in m^2/s
      real, allocatable :: taux(:) ! surface wind stress in m^2/s^2

      real, allocatable :: maskT(:,:) ! land/sea mask at T-grid points
      real, allocatable :: maskV(:,:) ! land/sea mask at V-grid points
      real, allocatable :: maskW(:,:) ! land/sea mask at W-grid points
      real, allocatable :: mask_SO(:) ! mask for Southern Ocean
      real, allocatable :: cf(:,:)! coefficients for conjugate gradient solver
      real :: eps_sor = 1e-6 ! stop criteria for conjugate gradient solver
      integer :: sor_itts ! number of iterations of conjugate gradient solver
      integer :: maxitt=1000 ! maximal allowed number of iterations of solver
      real :: gamma1=1.0! closure parameter
      integer :: j_eq = 0  ! index where yt=0.0

      real :: talpha=1.,sbeta =0.
      real :: dslope=0.0008, slopec=0.005 ! slope clipping parameter for isopycnal diffusion
      real :: K_iso = 1000.0              ! isopycnal diffusivity in m^2/s

      logical :: enable_isopycnal_mixing = .true.

      end module deep_module




      subroutine allocate_deep_module
      use deep_module 
      implicit none

      allocate( u(ny,nz,0:2) ); u=0.0
      allocate( v(ny,nz,0:2) ); v=0.0
      allocate( b(ny,nz,0:2) ); b=0.0
#ifdef enable_temperature_salinity
      allocate( sal(ny,nz,0:2) ); sal=0.0
#endif
      allocate( w(ny,nz) ); w=0.0
      allocate( p(ny,nz) ); p=0.0
      allocate( ph(ny,nz) ); ph=0.0
      allocate( ps(ny) ); ps=0.0

      allocate( yt(ny)  ); yt=0.0
      allocate( yu(ny) ); yu=0.0
      allocate( coriolis_t(ny) ); coriolis_t=0.0
      allocate( zt(nz) ); zt=0.0
      allocate( zw(nz) ); zw=0.0
      allocate( fv(ny,nz) ); fv=0.0
      allocate( ht(ny) ); ht=0.0
      allocate( hv(ny) ); hv=0.0
      allocate( bstar(ny) ); bstar=0.0
#ifdef enable_temperature_salinity
      allocate( sstar(ny) );  sstar=0.0
      allocate( salt_flux(ny) ); salt_flux=0.0
#endif
      allocate( Kv(ny,nz) ); Kv=0.0
      allocate( A_trm(ny,nz) ); A_trm=0.0
      allocate( taux(ny) ); taux=0.0

      allocate( maskT(ny,nz) ); maskT=0.0
      allocate( maskV(ny,nz) ); maskV=0.0
      allocate( maskW(ny,nz) ); maskW=0.0
      allocate( mask_SO(ny) ); mask_SO=0.0
      allocate( cf(ny,-1:1) ); cf=0.0
      end subroutine allocate_deep_module
  
