#include "options.inc"


c  with two-hemisphere ocean with northern or southern sinking

#define RESOLVE 0.25
#define vRESOLVE 0.5

      subroutine  set_parameter
c----------------------------------------------------------------------
c     set parameters here
c----------------------------------------------------------------------
      use deep_module
      implicit none



      ny=128 *RESOLVE
      nz=30 *vRESOLVE
c     set resolution and time stepping
      dy=80e3  /RESOLVE
      dt_in=2400.0  /RESOLVE  
      dz=50.0  /vRESOLVE
      runlen = 365*1000
      snap_int =   365! 360

c     set all physical parameter
      beta    = 2*omega/radius
      y_0 = -ny/2*dy
      r=2e-6
      delta=(2e-6)/beta
      Delta_x = (ny/4-2)*dy
      r_b = 0e-5           ! bottom friction coeff
      surf_rest=30.*86400. ! surface restoring time scale

      enable_isopycnal_mixing = .true.

      A_h=5.0e4 /RESOLVE**2 ! u_t = A u_xx,  1/T = A /L^2 
      A_hx=0*A_h
      A_v=1e-4
      K_h=0
      K_v=1e-4
      K_gm=0000.0

      eps_sor=1e-8
      talpha=0.2/100.! /1024.0*9.81 
      sbeta=-0.8/100.!/1024.0*9.81
      K_iso=1000.0
      surf_rest_salt=0*dz/(30.*86400.) ! surface restoring time scale
#ifndef enable_temperature_salinity
       print*,' enable temperature/salinity '
       stop
#endif
      end  subroutine  set_parameter


      subroutine  setup_forcing
c----------------------------------------------------------------------
c     configure forcing here
c----------------------------------------------------------------------
      use deep_module
      implicit none
      integer :: j,k,indp
      real :: db,y2,y0,fxa,y1

c     Southern ocean
      mask_SO=0.

c     surface forcing
      salt_flux=0.0
      fxa=0.5/86400.
      do j=2,ny-1
       salt_flux(j)=-fxa*exp(-(yt(j)-yt(ny-1))**2/(Ly/8.)**2 )
     &              -fxa*exp(-(yt(j)-yt(2)   )**2/(Ly/8.)**2 )
      enddo
      fxa=0.; do j=2,ny-1
       fxa=fxa+salt_flux(j)
      enddo; fxa=fxa/(ny-2.)
      salt_flux=salt_flux-fxa

      do j=1,ny
       bstar(j)=15-15*exp(-(yt(j)-yt(ny-1))**2/(Ly/8.)**2 )
     &            -15*exp(-(yt(j)-yt(2)   )**2/(Ly/8.)**2 )
      enddo

      end subroutine  setup_forcing





      subroutine setup_topography
c----------------------------------------------------------------------
c     configure topography here
c----------------------------------------------------------------------
      use deep_module
      implicit none
      end subroutine setup_topography
 



      subroutine time_dependent_forcing
c----------------------------------------------------------------------
c     place time dependent forcing here
c----------------------------------------------------------------------
      use deep_module
      implicit none
      end subroutine time_dependent_forcing
 
