#include "options.inc"


      subroutine diagnose
c-----------------------------------------------------------------------
c     diagnostics
c-----------------------------------------------------------------------
      use deep_module
      implicit none
      integer :: k,j
      real :: fx,cfl,umax
      character (len=32) :: stamp

      umax=0. 
      do j=2,ny-1
       do k=2,nz-1
        umax=max(umax,sqrt(u(j,k,tau)**2+v(j,k,tau)**2))
       enddo
      enddo
      CFL = abs(umax*dt_in/dy)
      if (snapshot_time_step.or.CFL>2.0) then
       call set_stamp(stamp,get_current_time())
       print'(a,i9,a,a,a,f12.8,a,i5)',
     &    ' itt=',itt,'  ',stamp,' CFL max = ',CFL,
     &    ' sor itts = ',sor_itts
        call diag_snap
        if (CFL>2.0) call halt_stop('CFL violation')
      endif
      call sub_flush(6)


      end subroutine diagnose


      subroutine init_snap_cdf
c-----------------------------------------------------------------------
c     initialize NetCDF snapshot file
c-----------------------------------------------------------------------
      use deep_module
      implicit none
#include "netcdf.inc"
      integer :: ncid,iret
      integer :: lat_tdim,itimedim
      integer :: lat_tid,itimeid
      integer :: lat_udim,zudim,ztdim
      integer :: lat_uid,zuid,ztid,sbid,siid,sfid,stid,sssid
      integer :: biid,bbid,ubid,vbid,piid,pbid,btid,utid
      integer :: dims(4),kiid,kbid,viid,vtid,wtid,uiid
      integer :: bsid,tauid,soid,abid,aiid,topoid
      character :: name*24, unit*16
      real :: spval=-9.9e12

      ncid = nccre ('deep.cdf', NCCLOB, iret)
      iret=nf_set_fill(ncid, NF_NOFILL, iret)
c     dimensions
      Lat_tdim  = ncddef(ncid, 'yt', ny, iret)
      Lat_udim  = ncddef(ncid, 'yu', ny, iret)
      zudim  = ncddef(ncid, 'zu', nz, iret)
      ztdim  = ncddef(ncid, 'zt', nz, iret)
      iTimedim  = ncddef(ncid, 'Time', nf_unlimited, iret)
c     grid variables
      Lat_tid  = ncvdef (ncid,'yt',NCFLOAT,1,lat_tdim,iret)
      Lat_uid  = ncvdef (ncid,'yu',NCFLOAT,1,lat_udim,iret)
      zuid  = ncvdef (ncid,'zu',NCFLOAT,1,zudim,iret)
      ztid  = ncvdef (ncid,'zt',NCFLOAT,1,ztdim,iret)
      itimeid  = ncvdef (ncid,'Time', NCFLOAT,1,itimedim,iret)
c     2 dim variables on t grid
      dims = (/lat_tdim,ztdim,iTimedim,1/)
      btid = ncvdef (ncid,'b', NCFLOAT,3,dims,iret)
#ifdef enable_temperature_salinity
      stid = ncvdef (ncid,'s', NCFLOAT,3,dims,iret)
#endif
      pbid = ncvdef (ncid,'p', NCFLOAT,3,dims,iret)
      dims = (/lat_tdim,ztdim,iTimedim,1/)
c      utid  = ncvdef (ncid,'u', NCFLOAT,3,dims,iret)
      dims = (/lat_udim,ztdim,iTimedim,1/)
      vtid = ncvdef (ncid,'v', NCFLOAT,3,dims,iret)
      dims = (/lat_tdim,zudim,iTimedim,1/)
      Kbid  = ncvdef (ncid,'Kv', NCFLOAT,3,dims,iret)
      Abid  = ncvdef (ncid,'Av', NCFLOAT,3,dims,iret)
      wtid  = ncvdef (ncid,'w', NCFLOAT,3,dims,iret)

      dims = (/lat_tdim,iTimedim,1,1/)
      bsid  = ncvdef (ncid,'b_star', NCFLOAT,2,dims,iret)
      tauid = ncvdef (ncid,'tau_x', NCFLOAT,2,dims,iret)
#ifdef enable_temperature_salinity
      sssid = ncvdef (ncid,'s_star', NCFLOAT,2,dims,iret)
      sfid  = ncvdef (ncid,'s_flux', NCFLOAT,2,dims,iret)
#endif
      soid = ncvdef (ncid,'SO', NCFLOAT,1,lat_tdim,iret)
      dims = (/lat_tdim,ztdim,1,1/)
      topoid = ncvdef (ncid,'Topo', NCFLOAT,2,dims,iret)

c     attributes of the grid
      name = 'Latitude on T grid     '; unit = 'km'
      call ncaptc(ncid, Lat_tid, 'long_name', NCCHAR, 24, name, iret) 
      call ncaptc(ncid, Lat_tid, 'units',     NCCHAR, 16, unit, iret) 
      name = 'Latitude on U grid     '; unit = 'km'
      call ncaptc(ncid, Lat_uid, 'long_name', NCCHAR, 24, name, iret) 
      call ncaptc(ncid, Lat_uid, 'units',     NCCHAR, 16, unit, iret) 
      name = 'Height on U grid     '; unit = 'm'
      call ncaptc(ncid, zuid, 'long_name', NCCHAR, 24, name, iret) 
      call ncaptc(ncid, zuid, 'units',     NCCHAR, 16, unit, iret) 
      name = 'Height on T grid     '; unit = 'm'
      call ncaptc(ncid, ztid, 'long_name', NCCHAR, 24, name, iret) 
      call ncaptc(ncid, ztid, 'units',     NCCHAR, 16, unit, iret) 
      name = 'Time '; unit = 'days'
      call ncaptc(ncid, itimeid, 'long_name', NCCHAR, 24, name, iret) 
      call ncaptc(ncid, itimeid, 'units',     NCCHAR, 16, unit, iret) 
      call ncaptc(ncid, iTimeid,'time_origin',NCCHAR, 20,
     &  '01-JAN-1900 00:00:00', iret)

c     attributes of variables
#ifdef enable_temperature_salinity
      name = 'Salinity'; unit = 'g/Kg'
      call dvcdf(ncid,stid,name,24,unit,16,spval)
      name = 'Temperature'; unit = 'K'
#else
      name = 'Buoyancy'; unit = 'm/s^2'
#endif
      call dvcdf(ncid,btid,name,24,unit,16,spval)
      name = 'Pressure'; unit = 'm^2/s^2'
      call dvcdf(ncid,pbid,name,24,unit,16,spval)
c      name = 'Zonal velocity'; unit = 'm/s'
c      call dvcdf(ncid,utid,name,24,unit,16,spval)
      name = 'Meridional velocity'; unit = 'm/s'
      call dvcdf(ncid,vtid,name,24,unit,16,spval)
      name = 'Vertical diffusity'; unit = 'm^2/s'
      call dvcdf(ncid,Kbid,name,24,unit,16,spval)
      name = 'Vertical viscosity'; unit = 'm^2/s'
      call dvcdf(ncid,Abid,name,24,unit,16,spval)
      name = 'Vertical velocity'; unit = 'm/s'
      call dvcdf(ncid,wtid,name,24,unit,16,spval)

      name = 'Restoring buoyancy'; unit = 'm/s^2'
      call dvcdf(ncid,bsid,name,24,unit,16,spval)
#ifdef enable_temperature_salinity
      name = 'Surface salt flux'; unit = 'g/Kg m/s'
      call dvcdf(ncid,sfid,name,24,unit,16,spval)
#endif
      name = 'Zonal wind stress'; unit = 'm^2/s^2'
      call dvcdf(ncid,tauid,name,24,unit,16,spval)
      name = 'Southern Ocean mask'; unit = ' '
      call dvcdf(ncid,soid,name,24,unit,16,spval)
      name = 'Topography mask'; unit = ' '
      call dvcdf(ncid,topoid,name,24,unit,16,spval)

      call ncendf(ncid, iret)
      iret= nf_put_vara_double(ncid,lat_tid,1,ny,yt/1e3)
      iret= nf_put_vara_double(ncid,lat_uid,1,ny,yu/1e3)
      iret= nf_put_vara_double(ncid,zuid,1,nz,zw)
      iret= nf_put_vara_double(ncid,ztid,1,nz,zt)
      iret= nf_put_vara_double(ncid,soid,1,ny,mask_SO)
      iret= nf_put_vara_double(ncid,topoid,(/1,1/),(/ny,nz/),maskT)
      call ncclos (ncid, iret)
      end subroutine init_snap_cdf


      subroutine diag_snap
c-----------------------------------------------------------------------
c     write to NetCDF snapshot file
c-----------------------------------------------------------------------
      use deep_module
      implicit none
#include "netcdf.inc"
      integer :: ncid,iret,n,corner(3), edges(3)
      real :: spval=-9.9e12,a(ny,nz)
      integer :: itdimid,ilen,biid,bbid,itimeid,ubid,vbid,btid,abid,sbid
      integer :: piid,pbid,kiid,kbid,viid,vtid,wtid,uiid,utid,aiid,siid
      integer :: stid,sssid,sfid,tauid,bsid
      real :: fxa
      type (time_type) :: time


      iret=nf_open('deep.cdf',NF_WRITE,ncid)
      iret=nf_set_fill(ncid, NF_NOFILL, iret)

      iret=nf_inq_varid(ncid,'b' ,btid)
c      iret=nf_inq_varid(ncid,'u' ,utid)
      iret=nf_inq_varid(ncid,'v' ,vtid)
      iret=nf_inq_varid(ncid,'w' ,wtid)
      iret=nf_inq_varid(ncid,'p',pbid)
      iret=nf_inq_varid(ncid,'Kv',Kbid)
      iret=nf_inq_varid(ncid,'Av',Abid)
#ifdef enable_temperature_salinity
      iret=nf_inq_varid(ncid,'s' ,stid)
#endif
      iret=nf_inq_varid(ncid,'b_star',bsid)
      iret=nf_inq_varid(ncid,'tau_x',tauid)
#ifdef enable_temperature_salinity
      iret=nf_inq_varid(ncid,'s_star',sssid)
      iret=nf_inq_varid(ncid,'s_flux',sfid)
#endif

      iret=nf_inq_dimid(ncid,'Time',itdimid)
      iret=nf_inq_dimlen(ncid, itdimid,ilen)
      iret=nf_inq_varid(ncid,'Time',itimeid)
      ilen=ilen+1
      time = get_current_time()-initial_time
      fxa = time%days + time%seconds/86400. 
      print*,' writing a snapshot at stamp=',current_stamp,
     &          ' (days since origin : ',fxa,')',
     &          ' (time steps in file : ',ilen,')'

      iret= nf_put_vara_double(ncid,itimeid,ilen,1,fxa)
      Corner = (/1,1,ilen/); edges  = (/ny,nz,1/)
      iret= nf_put_vara_double(ncid,pbid,corner,edges,p(:,:))
      iret= nf_put_vara_double(ncid,btid,corner,edges,b(:,:,tau))
c      iret= nf_put_vara_double(ncid,utid,corner,edges,u(:,:,tau))
      iret= nf_put_vara_double(ncid,vtid,corner,edges,v(:,:,tau))
      iret= nf_put_vara_double(ncid,wtid,corner,edges,w(:,:))
      iret= nf_put_vara_double(ncid,Kbid,corner,edges,Kv(:,:))
      iret= nf_put_vara_double(ncid,Abid,corner,edges,A_trm(:,:))
#ifdef enable_temperature_salinity
      iret= nf_put_vara_double(ncid,stid,corner,edges,sal(:,:,tau))
#endif
      Corner = (/1,ilen,1/); edges  = (/ny,1,1/)
      iret= nf_put_vara_double(ncid,bsid,corner,edges,bstar)
      iret= nf_put_vara_double(ncid,tauid,corner,edges,taux)
#ifdef enable_temperature_salinity
      iret= nf_put_vara_double(ncid,sssid,corner,edges,sstar)
      iret= nf_put_vara_double(ncid,sfid,corner,edges,salt_flux)
#endif
      call ncclos (ncid, iret)
      end subroutine diag_snap



      subroutine dvcdf(ncid,ivarid,name,iname,unit,iunit,spval)
c-----------------------------------------------------------------------
c     define some standard attributes of variable ivarid in NetCDF file ncid 
c-----------------------------------------------------------------------
      implicit none
      integer ncid,ivarid,iname,iunit,iret
      character (len=*) :: name, unit
      real :: spval
      real :: vv
#include "netcdf.inc"
      vv=spval
      call ncaptc(ncid,ivarid, 'long_name', NCCHAR,iname , name, iret) 
        if (iret.ne.0) print*,nf_strerror(iret)
      call ncaptc(ncid,ivarid, 'units',     NCCHAR,iunit, unit, iret) 
        if (iret.ne.0) print*,nf_strerror(iret)
c      call ncapt (ncid,ivarid, 'missing_value',NCFLOAT,1,vv,iret)
      call ncapt (ncid,ivarid, 'missing_value',NCDOUBLE,1,vv,iret)
        if (iret.ne.0) print*,nf_strerror(iret)
c      call ncapt (ncid,ivarid, '_FillValue', NCFLOAT, 1,vv, iret)
      call ncapt (ncid,ivarid, '_FillValue', NCDOUBLE, 1,vv, iret)
        if (iret.ne.0) print*,nf_strerror(iret)
      end subroutine dvcdf

