#include "options.inc"



      subroutine buoyancy
      use deep_module
c----------------------------------------------------------------------
c     integrate buoyancy in time
c----------------------------------------------------------------------
      implicit none
      integer :: j,k,n
      real :: adv_ft(ny,nz), adv_fn(ny,nz),adv_fe(ny,nz)
      real :: diff_ft(ny,nz), diff_fn(ny,nz),fxa

c      call tic('vertical_vel')
c----------------------------------------------------------------------
c     vertical velocities from continuity
c----------------------------------------------------------------------
      w(:,1) = 0.0; 
      do k=2,nz
       do j=2,ny-1
        w(j,k) = w(j,k-1)-maskW(j,k)*dz*
     &           (v(j,k,tau)-v(j-1,k,tau))/dy
       enddo
      enddo
      w=w*maskW;
c      call toc('vertical_vel')

c----------------------------------------------------------------------
c     buoyancy 
c----------------------------------------------------------------------
c      call tic('advection')
      call adv_flux(adv_fn,adv_ft,b,v(:,:,tau),w)
c      call toc('advection')
      call diffusion(diff_ft,diff_fn,b)
c     boundary condition at surface
      diff_ft(:,nz-1)=-dz/surf_rest*(b(:,nz-1,taum1)-bstar)
     &               *maskW(:,nz-2)
c     integrate western boundary buoyancy budget
      do k=2,nz-1
       do j=2,ny-1
        b(j,k,taup1) = b(j,k,taum1)+maskT(j,k)*c2dt*(
     &      -(adv_fn(j,k)-adv_fn(j-1,k))/dy
     &      -(adv_ft(j,k)-adv_ft(j,k-1))/dz
     &      +(diff_ft(j,k)-diff_ft(j,k-1))/dz
     &      +(diff_fn(j,k)-diff_fn(j-1,k))/dy )
       enddo
      enddo
#ifdef enable_temperature_salinity
c----------------------------------------------------------------------
c     salinity in western boundary layer
c----------------------------------------------------------------------
c      call tic('advection')
      call adv_flux(adv_fn,adv_ft,sal,v(:,:,tau),w)
c      call toc('advection')
      call diffusion(diff_ft,diff_fn,sal)
c     boundary condition at surface
      diff_ft(:,nz-1)=maskW(:,nz-2)*(salt_flux(:)
     &          -surf_rest_salt*(sal(:,nz-1,taum1)-sstar))
c     integrate western boundary buoyancy budget
      do k=2,nz-1
       do j=2,ny-1
        sal(j,k,taup1) = sal(j,k,taum1)+maskT(j,k)*c2dt*(
     &      -(adv_fn(j,k)-adv_fn(j-1,k))/dy
     &      -(adv_ft(j,k)-adv_ft(j,k-1))/dz
     &      +(diff_ft(j,k)-diff_ft(j,k-1))/dz
     &      +(diff_fn(j,k)-diff_fn(j-1,k))/dy )
       enddo
      enddo
      if (enable_isopycnal_mixing) then
       call isopycnal_diffusion(sal,b(:,:,taum1),sal(:,:,taum1))
       call isopycnal_diffusion(b  ,b(:,:,taum1),sal(:,:,taum1))
      endif
#endif

c     check for static instability 
c      call tic('convection')
      do k=1,nz-1
       do j=2,ny-1
        Kv(j,k)=0.
#ifdef enable_temperature_salinity
        if (talpha*b(j,k+1,taum1)+sbeta*sal(j,k+1,taum1)
     &    < talpha*b(j,k  ,taum1)+sbeta*sal(j,k  ,taum1)) 
#else
        if (b(j,k+1,taum1) < b(j,k,taum1)) 
#endif
     &       Kv(j,k)=1000*maskW(j,k)
       enddo
      enddo
      call implicit_tracer_mix(b,Kv)
#ifdef enable_temperature_salinity
      call implicit_tracer_mix(sal,Kv)
#endif
c      call toc('convection')

      end subroutine buoyancy



      subroutine implicit_tracer_mix(var,K_vert)
c----------------------------------------------------------------------
c     fully implicit vertical mixing scheme for convection
c----------------------------------------------------------------------
      use deep_module
      implicit none
      real :: var(ny,nz,0:2)
      real :: K_vert(ny,nz)
      integer :: k
      real :: a(ny,nz),b2(ny,nz),c(ny,nz),bet(ny)
      real :: pu(ny,nz),gam(ny,nz),fxa,rr(ny,nz)

      fxa = c2dt/dz**2
c      do j=2,ny-1
       b2(:,1) = 1+fxa*K_vert(:,1)
       c(:,1)  =  -fxa*K_vert(:,1)
       do k=2,nz-1
        a(:,k)  =  -fxa *   K_vert(:,k-1)
        b2(:,k) = 1+fxa * ( K_vert(:,k)+K_vert(:,k-1) )
        c(:,k)  =  -fxa *   K_vert(:,k)
       enddo
       a(:,nz)  =  -fxa * K_vert(:,nz-1)
       b2(:,nz) = 1+fxa * K_vert(:,nz-1) 

       pu=0.0;gam=0.0
       rr=var(:,:,taup1)
c       rr(:,nz-1)=rr(:,nz-1)
c     &           +aidif_tracer*surf_flux(:,j)*c2dt/dz
       bet=b2(:,1)
       where (bet/=0.0) pu(:,1)=rr(:,1)/bet
       do k=2,nz
        where (bet/=0.0) gam(:,k)=c(:,k-1)/bet
        bet=b2(:,k)-a(:,k)*gam(:,k)
        where (bet/=0.0) pu(:,k)=(rr(:,k)-a(:,k)*pu(:,k-1))/bet
       enddo
       do k=nz-1,1,-1
        pu(:,k)=pu(:,k)-gam(:,k+1)*pu(:,k+1)
       enddo
       var(:,:,taup1)=pu
c      enddo
      end subroutine implicit_tracer_mix






      subroutine isopycnal_diffusion(tr,sig1,sig2)
c=======================================================================
c     Isopycnal diffusion
c     sig1 is either buoyancy or temperature
c     in the latter case sig2 is salinity
c     both at taum1
c=======================================================================
      use deep_module
      implicit none
      real :: tr(ny,nz,0:2),sig1(ny,nz),sig2(ny,nz)
      integer :: j,k
      real :: diff_fn(ny,nz),diff_ft(ny,nz)
      real :: Tz(ny,nz),bz(ny,nz),sl,fxa
      real :: Ty(ny,nz),by(ny,nz),K_iso2(ny,nz)

      diff_fn(:,:)=0; diff_ft(:,:)=0; K_iso2=0.0

c-----------------------------------------------------------------------
c     derivatives of buoyancy
c-----------------------------------------------------------------------
      bz(:,:)=0; by(:,:)=0
      do k=1,nz-1
       do j=2,ny-1
#ifdef enable_temperature_salinity
        by(j,k)= talpha*(sig1(j+1,k)-sig1(j,k))/dy*maskV(j,k) 
     &         + sbeta *(sig2(j+1,k)-sig2(j,k))/dy*maskV(j,k) 

        bz(j,k)= talpha*(sig1(j,k+1)-sig1(j,k))/dz*maskW(j,k) 
     &         + sbeta *(sig2(j,k+1)-sig2(j,k))/dz*maskW(j,k) 
#else
        by(j,k)= (sig1(j+1,k)-sig1(j,k))/dy*maskV(j,k) 
        bz(j,k)= (sig1(j,k+1)-sig1(j,k))/dz*maskW(j,k) 
#endif
       enddo
      enddo
c-----------------------------------------------------------------------
c     derivatives of tracer
c-----------------------------------------------------------------------
      Tz(:,:)=0; Ty(:,:)=0
      do k=1,nz-1
       do j=2,ny-1
        Ty(j,k)= (tr(j+1,k,taum1)-tr(j,k,taum1))/dy*maskV(j,k) 
        Tz(j,k)= (tr(j,k+1,taum1)-tr(j,k,taum1))/dz*maskW(j,k) 
       enddo
      enddo
c-----------------------------------------------------------------------
c     diff_fn =  K (T_y - b_y/b_z T_z)
c-----------------------------------------------------------------------
      do k=2,nz-1
       do j=2,ny-1
         fxa=(bz(j,k)+bz(j,k-1)+bz(j+1,k)+bz(j+1,k-1))
     &    /(maskW(j,k  )+maskW(j+1,k)
     &     +maskW(j,k-1)+maskW(j+1,k-1)+epsln)
         sl=by(j,k)*sign(1.,fxa)/(abs(fxa)+epsln)
         sl=sl*0.5*(1.+tanh((-abs(sl)+slopec)/dslope))   
         fxa=(Tz(j,k)+Tz(j,k-1)+Tz(j+1,k)+Tz(j+1,k-1))
     &    /(maskW(j,k  )+maskW(j+1,k)
     &     +maskW(j,k-1)+maskW(j+1,k-1)+epsln)
         diff_fn(j,k)=(Ty(j,k)-sl*fxa)*maskV(j,k)*K_iso
       enddo
      enddo
c-----------------------------------------------------------------------
c     diff_fb =  - K(b_y/b_z T_y) + T_z K(by/bz)**2
c      second term is done implicitly
c-----------------------------------------------------------------------
      do k=2,nz-1
       do j=2,ny-1
         fxa=(by(j,k)+by(j-1,k  )+by(j,k+1)+by(j-1,k+1))
     &    /(maskV(j,k  )+maskV(j-1,k  )
     &     +maskV(j,k+1)+maskV(j-1,k+1)+epsln)
         sl=fxa*sign(1.,bz(j,k))/(abs(bz(j,k))+epsln)
         sl=sl*0.5*(1.+tanh((-abs(sl)+slopec)/dslope))   
         fxa=(Ty(j,k)+Ty(j-1,k)+Ty(j,k+1)+Ty(j-1,k+1))
     &    /(maskV(j,k  )+maskV(j-1,k  )
     &     +maskV(j,k+1)+maskV(j-1,k+1)+epsln)
         diff_ft(j,k)=diff_ft(j,k)+(-sl*fxa)*maskW(j,k)*K_iso
         K_iso2(j,k)=K_iso2(j,k)+sl**2*maskW(j,k)*K_iso
        enddo
       enddo

c       call delimit_adv_flux_taup1(n,diff_fe,diff_fn,diff_ft)

c---------------------------------------------------------------------------------
c     add explicit part 
c---------------------------------------------------------------------------------
      do k=2,nz-1
       do j=2,ny-1
          tr(j,k,taup1)=tr(j,k,taup1)+maskT(j,k)*c2dt*( 
     &          +(diff_ft(j,k)-diff_ft(j,k-1))/dz
     &          +(diff_fn(j,k)-diff_fn(j-1,k))/dy )  
       enddo
      enddo
c---------------------------------------------------------------------------------
c     add implicit part 
c---------------------------------------------------------------------------------
      call implicit_tracer_mix(tr,K_iso2)
      end subroutine isopycnal_diffusion









