#include "options.inc"


      subroutine pressure
c----------------------------------------------------------------------
c     find surface pressure
c----------------------------------------------------------------------
      use deep_module
      use congrad_module
      implicit none
      integer :: j,k
      real :: fpy(ny),forc(ny)
      logical, save :: first = .true.

      if (first) call make_coef
c     hydrostatic pressure by vertical integration
      phi(:,nz) = 0; phb(:,nz) = 0
      do k=nz-1,1,-1
       do j=2,ny-1
#ifdef enable_temperature_salinity
        phi(j,k)=maskT(j,k)*(phi(j,k+1)
     &    -talpha*(bi(j,k+1,tau)+bi(j,k,tau))/2.0*dz
     &    -sbeta *(si(j,k+1,tau)+si(j,k,tau))/2.0*dz )
        phb(j,k)=maskT(j,k)*(phb(j,k+1)
     &    -talpha*(bb(j,k+1,tau)+bb(j,k,tau))/2.0*dz
     &    -sbeta *(sb(j,k+1,tau)+sb(j,k,tau))/2.0*dz )
#else
        phi(j,k)=maskT(j,k)*
     &    (phi(j,k+1)-(bi(j,k+1,tau)+bi(j,k,tau))/2.0*dz)
        phb(j,k)=maskT(j,k)*
     &    (phb(j,k+1)-(bb(j,k+1,tau)+bb(j,k,tau))/2.0*dz)
#endif
       enddo
      enddo
c     momentum tendencies without pressure
c      call tic('momentum')
      call momentum_boundary
      call momentum_interior
c      call toc('momentum')
c      call tic('trm_momentum')
#ifdef enable_trm_vertical_viscosity
      call trm_viscosity
#endif
c      call toc('trm_momentum')
c      call tic('congrad')
c     forcing for total surface pressure
      forc=0.0;fpy=0.
      do k=2,nz-1
       do j=1,ny-1
         fpy(j)=fpy(j)+maskV(j,k)*dz*(
     &        delta*(fvb(j,k)-(phb(j+1,k)-phb(j,k))/dy)
     &     +Delta_x*(fvi(j,k)-(phi(j+1,k)-phi(j,k))/dy) )
     &            /(delta+Delta_x)
       enddo
      enddo
      do j=2,ny-1
       forc(j)=(fpy(j)-fpy(j-1))/dy
      enddo
c     first guess for total surface pressure
      ps(2)=0.
      do j=3,ny-1
       ps(j)=ps(j-1)+dy*fpy(j)/(hv(j)+epsln)*maskV(j,nz-1)
      enddo
c     solve for total surface pressure
      call congrad(ny,cf,ps,forc,2000,sor_itts,eps_sor)
c     forcing for surface pressure difference
      forc=0.0;fpy=0.
      do k=2,nz-1
       do j=1,ny-1
         fpy(j)=fpy(j)+maskV(j,k)*dz*(
     &     +(fvi(j,k)-(phi(j+1,k)-phi(j,k))/dy) 
     &     -(fvb(j,k)-(phb(j+1,k)-phb(j,k))/dy) )
       enddo
      enddo
      do j=2,ny-1
       forc(j)=(fpy(j)-fpy(j-1))/dy
      enddo
      do k=2,nz-1
       forc=forc-maskT(:,k)*dz*(1.-mask_SO(:))*
     &   gamma2*(1./Delta_x+1./delta)*
     &   (fub(:,k)-gamma1*(phi(:,k)-phb(:,k))/delta )
      enddo
      call congrad(ny,cf2,dp,forc,2000,sor_itts2,eps_sor)
c     surface pressure in boundary layer and interior
      psb=ps-Delta_x/(delta+Delta_x)*dp
      psi=ps+  delta/(delta+Delta_x)*dp
c      call toc('congrad')
c     full pressure in boundary layer and interior
      do k=1,nz-1
       pii(:,k)=maskT(:,k)*(phi(:,k)+psi)
       pb(:,k) =maskT(:,k)*(phb(:,k)+psb)
      enddo
      pii(:,nz)=psi*maskT(:,nz-1)
      pb(:,nz) =psb*maskT(:,nz-1)
      first=.false.
      end subroutine pressure



      subroutine make_coef
      use deep_module
      implicit none
c-----------------------------------------------------------------------
c     corefficients for inversion of poisson equation
c         A * dpsi = forc
c         res = A * p
c-----------------------------------------------------------------------
      real :: maskM(ny),mp,mm
      integer :: j
        
      cf=0.
      maskM=maskT(:,nz-1)
      do j=2,ny-1
        mp=maskM(j)*maskM(j+1)/dy**2 
        mm=maskM(j)*maskM(j-1)/dy**2
        cf(j, 0)= cf(j, 0)-mp*hv(j)
        cf(j, 1)= cf(j, 1)+mp*hv(j)
        cf(j, 0)= cf(j, 0)-mm*hv(j-1)
        cf(j,-1)= cf(j,-1)+mm*hv(j-1)
      end do
      cf2=cf
      do j=2,ny-1
        cf2(j, 0)= cf2(j, 0)-gamma1*gamma2*ht(j)/delta
     &                 *(1./Delta_x+1./delta)*maskM(j)
      end do
      end subroutine make_coef
                                   







