#include "options.inc"
    
c=======================================================================
c      Different advection schemes for buoyancy and other tracers
c=======================================================================

      subroutine adv_flux(adv_fn,adv_ft,var,vv,ww)
c=======================================================================
c       advective tracer flux:  call different schemes
c=======================================================================
      use deep_module
      implicit none
      real :: adv_ft(ny,nz)
      real :: adv_fn(ny,nz), var(ny,nz,0:2)
      real :: vv(ny,nz), ww(ny,nz)

#ifdef enable_advection_quicker
      call adv_flux_quicker(adv_fn,adv_ft,var,vv,ww)
#endif
#ifdef enable_advection_2nd
      call adv_flux_2nd(adv_fn,adv_ft,var,vv,ww)
#endif
      end subroutine adv_flux


      subroutine adv_flux_east(adv_fe,varb,vari)
c=======================================================================
c     parameterised eastward advection with upwind
c=======================================================================
      use deep_module
      implicit none
      real :: adv_fe(ny,nz),varb(ny,nz,0:2),vari(ny,nz,0:2)
      integer :: j,k
      do k=2,nz-1
       do j=2,ny-1
        if (ub(j,k,tau) >= 0.) then
         adv_fe(j,k)=ub(j,k,tau)*varb(j,k,tau)
        else
         adv_fe(j,k)=ub(j,k,tau)*vari(j,k,tau)
        endif
        adv_fe(j,k)=adv_fe(j,k)*maskT(j,k)*(1.-mask_SO(j))
       enddo
      enddo
      end subroutine adv_flux_east


      subroutine diffusion(diff_ft,diff_fn,var)
c=======================================================================
c     lateral and vertical diffusive fluxes
c=======================================================================
      use deep_module
      implicit none
      real :: diff_ft(ny,nz),diff_fn(ny,nz),var(ny,nz,0:2)
      integer :: j,k
c     diffusive flux at top side
      do k=1,nz-1
       do j=2,ny-1
        diff_ft(j,k)=K_v*(var(j,k+1,taum1)-var(j,k,taum1))/dz
     &               *maskW(j,k)
       enddo
      enddo
c     diffusive flux at north side
      do k=2,nz-1
       do j=1,ny-1
        diff_fn(j,k)=K_h*(var(j+1,k,taum1)-var(j,k,taum1))/dy
     &               *maskV(j,k)
       enddo
      enddo
      end subroutine diffusion





      subroutine adv_flux_2nd(adv_fn,adv_ft,var,vv,ww)
c=======================================================================
c      2nd order advective tracer flux
c=======================================================================
      use deep_module
      implicit none
      integer :: j,k
      real :: adv_ft(ny,nz)
      real :: adv_fn(ny,nz), var(ny,nz,0:2)
      real :: vv(ny,nz), ww(ny,nz)
      real :: totvel

      do k=2,nz-1
       do j=1,ny-1
         totvel = vv(j,k)
         adv_fn(j,k)=
     &  0.5*( var(j,k,tau) + var(j+1,k,tau) )*totvel
     &    *maskV(j,k)
       enddo
      enddo
      do k=1,nz-1
       do j=2,ny-1
         totvel = ww(j,k)
         adv_ft(j,k)=
     &  0.5*( var(j,k,tau) + var(j,k+1,tau) )*totvel
     &    *maskW(j,k)
       enddo
      enddo
      end subroutine adv_flux_2nd



      subroutine adv_flux_quicker(adv_fn,adv_ft,var,vv,ww)
c=======================================================================
c      3th order advective tracer flux
c=======================================================================
      use deep_module
      implicit none
      integer :: j,k,jp2,kp2,jm1,km1
      real :: adv_ft(ny,nz), adv_fn(ny,nz), var(ny,nz,0:2)
      real :: vv(ny,nz), ww(ny,nz)
      real :: totvel,upos,uneg,eastmsk,westmsk

      do k=2,nz-1
       do j=1,ny-1
         jp2=j+2; if (jp2>ny) jp2=ny
         jm1=j-1; if (jm1<1)  jm1=1

         totvel = vv(j,k)
         upos = .5*(totvel + abs(totvel))
     &                  *maskt(j,k)*maskt(j+1,k)
         uneg = .5*(totvel - abs(totvel))
     &                  *maskt(j+1,k)*maskt(j,k)
         eastmsk=maskt(j,k)*(1-maskt(jm1,k))
         westmsk=maskt(j+1,k)*(1-maskt(jp2,k))
	 adv_fn(j,k) = maskV(j,k)*(
     &        0.5*totvel*(var(j,k,tau)+var(j+1,k,tau))
     &        - 0.5*upos*(0.25*var(j+1,k,taum1)-0.5*var(j,k,taum1)
     &               +0.25*(var(jm1,k,taum1)*(1-eastmsk)
     &                          +var(j,k,taum1)*eastmsk))
     &        - 0.5*uneg*(0.25*(var(jp2,k,taum1)*(1-westmsk)+
     &          var(j+1,k,taum1)*westmsk)-0.5*var(j+1,k,taum1)
     &                         +0.25*var(j,k,taum1)) )
        enddo
      enddo

      do k=1,nz-1
       do j=2,ny-1
         kp2=min(k+2,nz)
         km1=max(1,k-1)
         totvel = ww(j,k)
         upos = .5*(totvel + abs(totvel))
     &                  *maskt(j,k)*maskt(j,k+1)
         uneg = .5*(totvel - abs(totvel))
     &                  *maskt(j,k+1)*maskt(j,k)
         eastmsk=maskt(j,k)*(1-maskt(j,km1))
         westmsk=maskt(j,k+1)*(1-maskt(j,kp2))
	 adv_ft(j,k) = ( 
     &        0.5*totvel*(var(j,k,tau)+var(j,k+1,tau))
     &        - 0.5*upos*(0.25*var(j,k+1,taum1)-0.5*var(j,k,taum1)
     &               +0.25*(var(j,km1,taum1)*(1-eastmsk)
     &                          +var(j,k,taum1)*eastmsk))
     &        - 0.5*uneg*(0.25*(var(j,kp2,taum1)*(1-westmsk)+
     &          var(j,k+1,taum1)*westmsk)-0.5*var(j,k+1,taum1)
     &                         +0.25*var(j,k,taum1)) )
        enddo
      enddo
      end subroutine adv_flux_quicker









