#include "options.inc"


c  with Southern Ocean with wind stress and northern sinking
#define RESOLVE 0.25
#define vRESOLVE 0.5

      subroutine  set_parameter
c----------------------------------------------------------------------
c     set parameters here
c----------------------------------------------------------------------
      use deep_module
      implicit none


      ny=128 *RESOLVE
      nz=30  *vRESOLVE
c     set resolution and time stepping
      dy=80e3  /RESOLVE
      dt_in=2400.0  /RESOLVE
      dz=50.0  /vRESOLVE
      runlen = 365*1000
      snap_int =   36.5! 360

c     set all physical parameter
      beta    = 2*omega/radius
      y_0 = -ny/2*dy
      r=2e-6
      delta=(2e-6)/beta
      Delta_x = (ny/4-2)*dy
      r_b = 1e-5           ! bottom friction coeff
      surf_rest=30.*86400. ! surface restoring time scale

      A_h=6.0e4 /RESOLVE**2 ! u_t = A u_xx,  1/T = A /L^2 
      A_hx=0*A_h
      A_v=1e-4
      K_h=0
      K_v=1e-4
      K_gm=1000.0

      eps_sor=1e-8
#ifdef enable_temperature_salinity
      talpha=0.2/100.! /1024.0*9.81 
      sbeta=-0.8/100.!/1024.0*9.81
      K_iso=1000.0
      surf_rest_salt=0*dz/(30.*86400.) ! surface restoring time scale
#endif
      end  subroutine  set_parameter


      subroutine  setup_forcing
c----------------------------------------------------------------------
c     configure forcing here
c----------------------------------------------------------------------
      use deep_module
      implicit none
      integer :: j,k,indp
      real :: db,y2,y0,fxa,y1

c     Southern ocean
      mask_SO=0.
      j=indp(yt(1)+Ly/3., yt,ny)
      mask_SO(2:j)=1.
      y0=yt(j)

c     wind forcing
      do j=2,ny-1
       taux(j)=4.0e-4*cos((yt(j)-y0)/(yt(1)-y0)*pi-pi/2.)*mask_SO(j)
       taux(j)=max(0.,taux(j))
      enddo

c     surface forcing
#ifdef enable_temperature_salinity

      salt_flux=0.0
#ifndef notdef
      fxa=0.2/86400.;y1=Ly/2.*0.75
      do j=2,ny-1
       salt_flux(j)=-fxa*exp(-(yt(j)-yt(ny-1))**2/(Ly/8.)**2 )
     &              -fxa*1.5*exp(-(yt(j)-yt(2)   )**2/(Ly/8.)**2 )
      enddo
      fxa=0.; do j=2,ny-1
       fxa=fxa+salt_flux(j)
      enddo; fxa=fxa/(ny-2.)
      salt_flux=salt_flux-fxa
#endif

#ifdef notdef
      y1=Ly/2
      do j=2,ny-1
       sstar(j)=-2*exp(-(yt(j)-y1)**2/(Ly/8.)**2 )
     &          -2*exp(-(yt(j)+y1)**2/(Ly/5.)**2 )
      enddo
#endif

      y2=Ly*0.25
      db = 15;bstar=15
      do j=1,ny
       if (yt(j)<y0) bstar(j)=1.0*db*(1./1.0-(yt(j)-y0)/(yt(1)-y0))
       y2=Ly*0.25
       if (yt(j)>y2) bstar(j)=db*(1-(yt(j)-y2)/(yt(ny)-y2) )
      enddo
#else
      db = 30e-3;bstar=db
      do j=1,ny
       if (yt(j)<y0) then
        bstar(j)=db-db*(yt(j)-y0)/(yt(1)-y0)
       endif
       y2=Ly*0.25
       if (yt(j)>y2) then
        bstar(j)=db*(1-(yt(j)-y2)/(yt(ny)-y2) )
       endif
      enddo
#endif

      end subroutine  setup_forcing





      subroutine setup_topography
c----------------------------------------------------------------------
c     configure topography here
c----------------------------------------------------------------------
      use deep_module
      implicit none
      end subroutine setup_topography
 


