#include "options.inc"

c choose one of the following setups
c#include "ACC1_setup.F"
#include "St-Arons_setup.F"

      program driver
c----------------------------------------------------------------------
c     main driver
c----------------------------------------------------------------------
      use shallow_module
      implicit none
      call setup
 20    continue
        call time_step_begin()
        call integrate
        call diagnose
        call time_step_end()
       if (.not. end_of_run ) goto 20
      end program driver


      subroutine setup
c----------------------------------------------------------------------
c     setup everything
c----------------------------------------------------------------------
      use shallow_module
      implicit none
      integer :: j,indp
      real :: fxa

      print*,''
      print*,'--------------------------------------------------'
      print*,' setting up simple model version ',version
      print*,'--------------------------------------------------'
      print*,''

      call set_parameter

      print*,' Domain is ',ny,' grid points'
      print*,' Horizontal resolution is ',dy/1e3,' km '
      print*,' Domain extent is     ',ny*dy/1e3, ' km'
      print*,' Domain starts at y = ',y_0/1e3,' km'
      print*,' Domain ends at y =   ',(y_0+ny*dy)/1e3,' km'
      print*,' r       = ',r,' 1/s'
      print*,' H0      = ',H0,' m' 
      print*,' gprime  = ',gprime,' 1/s'
      print*,' lambda  = ',lambda,' 1/s'
      print*,' beta = ',beta,' 1/ms'
      print*,' delta= ',delta/1e3,' km'
      print*,' Delta x = ',Delta_x/1e3,' km'
      print*,' gamma1  = ',gamma1
      print*,' gamma2  = ',gamma2
      print*,' K_gm    = ',K_gm,' m^2/s'
      print*,' N_0     = ',N_0,' 1/s'
      call allocate_shallow_module

c     generate grid 
      do j=1,ny
        yt(j)=y_0+j*dy; yu(j)=yt(j)+dy/2
      enddo
c     Coriolis parameter and Rossby radius
      do j=1,ny
       coriolis_t(j)=beta*yt(j)
       L_r(j) = N_0*H0/(1e-6+abs(coriolis_t(j)))
      enddo
c     find equator
      j_eq=indp(0.0,yt,ny)
      if (yt(j_eq)/=0.0) then
        print*,' Error: cannot find equator '
        stop
      endif

      call setup_forcing

c     check stability criterion
      fxa=0
      do j=1,ny
       fxa=max(fxa,K_gm/L_r(j)**2)
       if (fxa>1./dt_in) then
        print*,' K_gm too large at j=',j
        stop
       endif
      enddo
      print*,' maximal K_gm/L_r^2= ',fxa,' 1/s'
      print*,' which is smaller than 1/dt=',1./dt_in,' 1/s'
      call init_time_manager(dt_in,runlen,snap_int,restart_stamp,0 )
      call disable_mixing_time_steps
      call init_snap_cdf()
      end subroutine setup



      subroutine integrate
c----------------------------------------------------------------------
c     integrate momentum and layer thickness
c----------------------------------------------------------------------
      use shallow_module
      implicit none
      integer :: j,indp,jj
      real :: dh(ny),fxa
      do j=2,ny-1
       udelta(j,:)=gamma2*ub(j,:)
      enddo
c     momentum in interior
      call prognostic_interior
c     closure of delta h_b
      do j=2,ny-1
       dh(j)= gprime*gamma1*(hi(j,tau)-hb(j,tau))/delta
      enddo
c     integrate momentum in western boundary layer
      do j=2,ny-1
        ub(j,taup1) = ub(j,taum1)+c2dt*(
     &   coriolis_t(j)*(vb(j-1,tau)+vb(j,tau))/2.0
     &    - r*ub(j,taum1)+taux(j)/H0
     &    - K_gm/L_r(j)**2*ub(j,taum1)
     &    - dh(j)*(1.-mask_SO(j)) )
      enddo
      do j=2,ny-2
        vb(j,taup1) = vb(j,taum1)+c2dt*(
     &            -(coriolis_t(j  )*ub(j,  tau)
     &             +coriolis_t(j+1)*ub(j+1,tau))/2.0
     &    - r*vb(j,taum1)
     &    - K_gm/(L_r(j)/2.+L_r(j+1)/2.)**2*vb(j,taum1)
     &       - gprime*(hb(j+1,tau)-hb(j,tau))/dy )
      enddo
c     integrate western boundary thickness budget
      do j=2,ny-1
       hb(j,taup1) = hb(j,taum1)+c2dt*(
     &    q(j)*Delta_x/delta-lambda*hb(j,taum1)
     &   -H0*(vb(j,tau)-vb(j-1,tau))/dy
     &   -H0/delta*udelta(j,tau)*(1.-mask_SO(j))
     &       )
      enddo
c     integrate interior thickness budget
      do j=2,ny-1
       hi(j,taup1) = hi(j,taum1)+c2dt*(
     &  -lambda*hi(j,taum1)
     &  -H0*(vi(j,tau)-vi(j-1,tau))/dy
     &  +H0/Delta_x*udelta(j,tau)*(1.-mask_SO(j))
     &       )
      enddo

c     roberts time filter
      ub(:,tau) = ub(:,tau) + gamma*
     &       (0.5*(ub(:,taup1) + ub(:,taum1)) - ub(:,tau)) 
      vb(:,tau) = vb(:,tau) + gamma*
     &       (0.5*(vb(:,taup1) + vb(:,taum1)) - vb(:,tau)) 
      hb(:,tau) = hb(:,tau) + gamma*
     &       (0.5*(hb(:,taup1) + hb(:,taum1)) - hb(:,tau)) 
      ui(:,tau) = ui(:,tau) + gamma*
     &       (0.5*(ui(:,taup1) + ui(:,taum1)) - ui(:,tau)) 
      vi(:,tau) = vi(:,tau) + gamma*
     &       (0.5*(vi(:,taup1) + vi(:,taum1)) - vi(:,tau)) 
      hi(:,tau) = hi(:,tau) + gamma*
     &       (0.5*(hi(:,taup1) + hi(:,taum1)) - hi(:,tau)) 

c     reconstruct full fields
      h=(hi(:,tau)*Delta_x+hb(:,tau)*delta)/(delta+Delta_x)
      v=(vi(:,tau)*Delta_x+vb(:,tau)*delta)/(delta+Delta_x)
      u=(ui(:,tau)*Delta_x+ub(:,tau)*delta)/(delta+Delta_x)

      end subroutine integrate



      subroutine prognostic_interior
c----------------------------------------------------------------------
c     integrate momentum in interior
c----------------------------------------------------------------------
      use shallow_module
      implicit none
      integer :: j,jj,indp
      real :: dh(ny),fxa,dhh(ny)
c     closure for zonal pressure difference
      dh(j_eq)=-r*(ui(j_eq-1,taum1)+ui(j_eq+1,taum1) )/2.0

      do j=j_eq+1,ny-1
        dh(j)=dh(j-1)+dy*(coriolis_t(j)*udelta(j,tau)
     &                   +coriolis_t(j-1)*udelta(j-1,tau))/2.0/Delta_x
      enddo
      do j=j_eq-1,2,-1
        dh(j)=dh(j+1)-dy*(coriolis_t(j)*udelta(j,tau)
     &                   +coriolis_t(j+1)*udelta(j+1,tau))/2.0/Delta_x
      enddo
c     zonal momentum
      do j=2,ny-1
        ui(j,taup1) = ui(j,taum1)+c2dt*(
     &   coriolis_t(j)*(vi(j-1,tau)+vi(j,tau))/2.0
     &   - K_gm/L_r(j)**2*ui(j,taum1)
     &   + taux(j)/H0 
     &   - r*ui(j,taum1) 
     &   -dh(j)*(1.-mask_SO(j)))
      enddo
c     meridional momentum
      do j=2,ny-2
        vi(j,taup1) = vi(j,taum1)+c2dt*(
     &            -(coriolis_t(j  )*ui(j,  tau)
     &             +coriolis_t(j+1)*ui(j+1,tau))/2.0
     &   - K_gm/(L_r(j)/2.+L_r(j+1)/2.)**2*vi(j,taum1)
     &   - r*vi(j,taum1)
     &   - gprime*(hi(j+1,tau)-hi(j,tau))/dy )
      enddo
      end subroutine prognostic_interior



