#include "options.inc"


      subroutine pressure
c----------------------------------------------------------------------
c     find surface pressure
c----------------------------------------------------------------------
      use deep_module
      use congrad_module
      implicit none
      integer :: j,k
      real :: fpy(ny),forc(ny)
      logical, save :: first = .true.

      if (first) call make_coef
c     hydrostatic pressure by vertical integration
      ph(:,nz) = 0;
      do k=nz-1,1,-1
       do j=2,ny-1
#ifdef enable_temperature_salinity
        ph(j,k)=maskT(j,k)*(ph(j,k+1)
     &    -talpha*(b(j,k+1,tau)+b(j,k,tau))/2.0*dz
     &    -sbeta *(sal(j,k+1,tau)+sal(j,k,tau))/2.0*dz )
#else
        ph(j,k)=maskT(j,k)*
     &    (ph(j,k+1)-(b(j,k+1,tau)+b(j,k,tau))/2.0*dz)
#endif
       enddo
      enddo


c     momentum tendencies without pressure
c      call tic('momentum')
      call momentum
c      call toc('momentum')
c      call tic('trm_momentum')
#ifdef enable_trm_vertical_viscosity
      call trm_viscosity
#endif
c      call toc('trm_momentum')

c      call tic('congrad')
c     forcing for total surface pressure
      forc=0.0;fpy=0.
      do k=2,nz-1
       do j=1,ny-1
         fpy(j)=fpy(j)+maskV(j,k)*dz*(
     &        fv(j,k)-(ph(j+1,k)-ph(j,k))/dy)
       enddo
      enddo
      do j=2,ny-1
       forc(j)=(fpy(j)-fpy(j-1))/dy
      enddo
c     first guess for total surface pressure
      ps(2)=0.
      do j=3,ny-1
       ps(j)=ps(j-1)+dy*fpy(j)/(hv(j)+epsln)*maskV(j,nz-1)
      enddo
c     solve for total surface pressure
      call congrad(ny,cf,ps,forc,2000,sor_itts,eps_sor)
c      call toc('congrad')

c     full pressure in boundary layer and interior
      do k=1,nz-1
       p(:,k) =maskT(:,k)*(ph(:,k)+ps)
      enddo
      p(:,nz) =ps*maskT(:,nz-1)
      first=.false.
      end subroutine pressure



      subroutine make_coef
      use deep_module
      implicit none
c-----------------------------------------------------------------------
c     corefficients for inversion of poisson equation
c         A * dpsi = forc
c         res = A * p
c-----------------------------------------------------------------------
      real :: maskM(ny),mp,mm
      integer :: j
        
      cf=0.
      maskM=maskT(:,nz-1)
      do j=2,ny-1
        mp=maskM(j)*maskM(j+1)/dy**2 
        mm=maskM(j)*maskM(j-1)/dy**2
        cf(j, 0)= cf(j, 0)-mp*hv(j)
        cf(j, 1)= cf(j, 1)+mp*hv(j)
        cf(j, 0)= cf(j, 0)-mm*hv(j-1)
        cf(j,-1)= cf(j,-1)+mm*hv(j-1)
      end do
      end subroutine make_coef
                                   







