#include "options.inc"


      subroutine momentum
c----------------------------------------------------------------------
c     momentum tendency without pressure
c----------------------------------------------------------------------
      use deep_module
      implicit none
      integer :: j,k
      real :: diff_ft(ny,nz)

c     meridional momentum tendency without pressure
c     diffusive flux at top side
      do k=1,nz-1
       do j=2,ny-1
        diff_ft(j,k)=A_v*(v(j,k+1,taum1)-v(j,k,taum1))/dz
     &               *maskV(j,k)*maskV(j,k+1)
       enddo
      enddo
      do k=2,nz-1
       do j=2,ny-1
        fv(j,k) = maskV(j,k)*(
     &       - r*v(j,k,taum1)
     & +A_h*(v(j+1,k,taum1)-2*v(j,k,taum1)+v(j-1,k,taum1))/dy**2
     &      +(diff_ft(j,k)-diff_ft(j,k-1))/dz
     &               )
       enddo
      enddo
      k=2; fv(:,k) = fv(:,k)+maskT(:,k)*(-r_b*v(:,k,taum1) )

      end subroutine momentum




      subroutine trm_viscosity
c=======================================================================
c
c=======================================================================
      use deep_module
      implicit none
      integer :: j,k
      real :: fxa,fxb
      real :: Nsqrw(ny,nz)
      real :: fNsqrw(ny,nz)
      real :: A_uu(ny,nz)
c-----------------------------------------------------------------------
c     stability freq.
c-----------------------------------------------------------------------
      do k=1,nz-1
       do j=2,ny-1
#ifdef enable_temperature_salinity
        Nsqrw(j,k)=talpha*(b(j,k+1,taum1)-b(j,k,taum1))/dz
     &              +sbeta *(sal(j,k+1,taum1)-sal(j,k,taum1))/dz
#else
        Nsqrw(j,k)=(b(j,k+1,taum1)-b(j,k,taum1))/dz
#endif
        Nsqrw(j,k)=max(Nsqrw(j,k),N_min**2)
       enddo
      enddo
c-----------------------------------------------------------------------
c     Calculate f**2/N**2 on W grid and bound 
c-----------------------------------------------------------------------
      do k=1,nz-1
       do j=2,ny-1
        fNsqrw(j,k)= coriolis_t(j)**2/Nsqrw(j,k)
        fNsqrw(j,k)=min(fNsqrw(j,k),fNsqr_max)
       enddo
      enddo
c-----------------------------------------------------------------------
c    vertical viscosity
c-----------------------------------------------------------------------
      do k=1,nz-1
       do j=2,ny-1
         fxa=K_gm*(maskT(j,k)+maskW(j,k))
         fxb=maskT(j,k)+maskW(j,k)+epsln
         A_trm(j,k)=fxa/fxb*fNsqrw(j,k)!*(1.-mask_SO(j))
       enddo
      enddo
c-----------------------------------------------------------------------
c      prepare coefficients for implicit part of vertical friction
c-----------------------------------------------------------------------
      A_uu(:,:)=0
      do k=1,nz-1
       do j=2,ny-1
        fxa=A_trm(j,k)*maskW(j,k)+A_trm(j+1,k)*maskW(j+1,k)
        fxb=maskW(j,k)+maskW(j+1,k)+epsln
        A_uu(j,k) =fxa/fxb*maskV(j,k+1)*maskV(j,k)
       enddo
      enddo
      call trm_implicit_umix(A_uu,v,maskV,fv)
      end subroutine trm_viscosity




      subroutine trm_implicit_umix(A_uu,uu,maskM,fuu)
c=======================================================================
c     implicit vertical friction
c=======================================================================
      use deep_module
      implicit none
      real :: A_uu(ny,nz) 
      real :: uu(ny,nz,0:2) ,maskM(ny,nz),fuu(ny,nz)
      integer :: j,k
      real :: a(nz),bq(nz),c(nz),bet
      real :: pu(nz),gam(nz),fxa,rq(nz)
c---------------------------------------------------------------------------------
c      first fake integrate du/dt = F_u, then solve for rest
c---------------------------------------------------------------------------------
      uu(:,:,taup1)= uu(:,:,taum1)+c2dt*fuu(:,:)*maskM
      do j=2,ny-1
       fxa = c2dt/dz**2
       bq(1) = 1+fxa * A_uu(j,1)
       c(1)  =  -fxa * A_uu(j,1)
       do k=2,nz-1
         a(k)  =  -fxa * A_uu(j,k-1)
         bq(k) = 1+fxa * (A_uu(j,k)+A_uu(j,k-1) )
         c(k)  =  -fxa * A_uu(j,k)
       enddo
       a(nz)  =  -fxa * A_uu(j,nz-1)
       bq(nz) = 1+fxa * A_uu(j,nz-1) 
       pu=0.0;gam=0.0
       rq=uu(j,:,taup1)*maskM(j,:)
       bet=bq(1)
       if (bet/=0.0) pu(1)=rq(1)/bet
       do k=2,nz
        if (bet/=0.0) gam(k)=c(k-1)/bet
        bet=bq(k)-a(k)*gam(k)
        if (bet/=0.0) pu(k)=(rq(k)-a(k)*pu(k-1))/bet
       enddo
       do k=nz-1,1,-1
        pu(k)=pu(k)-gam(k+1)*pu(k+1)
       enddo
       uu(j,:,taup1)=pu
      enddo
      fuu(:,:)=(uu(:,:,taup1)-uu(:,:,taum1))/c2dt*maskM
      end subroutine trm_implicit_umix


