#include "options.inc"


c classical Stommel-Arons setup with northern, southern and equatorial sinking

#define RESOLVE 0.5
#define vRESOLVE 0.5

      subroutine  set_parameter
c----------------------------------------------------------------------
c     set parameters here
c----------------------------------------------------------------------
      use deep_module
      implicit none

      ny=128 *RESOLVE
      nz=20  *vRESOLVE
c     set resolution and time stepping
      dy=80e3 /RESOLVE
      dt_in=3600.0/RESOLVE
      dz=50.0 /vRESOLVE
      runlen = 365*200
      snap_int = 365./4.0! 360

c     set all physical parameter
      beta  = 2.*omega/radius   
      y_0 = -ny/2*dy
      r=2e-6
      r_b = 0e-5           ! bottom friction coeff
      surf_rest=30.*86400. ! surface restoring time scale

      gamma1=1.0

      A_h=3.2e4 /RESOLVE**2! u_t = A u_xx,  1/T = A /L^2 
      A_hx=0*A_h
      A_v=1e-3
      K_h=0
      K_v=1e-4
      K_gm=0000.0
      end  subroutine  set_parameter


      subroutine  setup_forcing
c----------------------------------------------------------------------
c     configure forcing here
c----------------------------------------------------------------------
      use deep_module
      implicit none
      integer :: j,k,indp
      real :: db,y2,y0

c     Southern ocean
      mask_SO=0.

c     wind forcing
      do j=2,ny-1
c       gyre win stress
c       taux(j)=-1e-4*cos(2*pi*yt(j)/Ly)
      enddo

c     surface forcing
      bstar=0./1024.*9.81
      j=indp(yt(1)+3.*r/beta,yt,ny)
c     northern sinking region
c      bstar(ny-j:ny)=-0.025

      do j=1,ny
       bstar(j)=-0.025*exp(-(yt(j)-(Ly/2-0.5*dy))**2/(3*r/beta)**2)
      enddo

c      bstar(ny-1)=-0.025
c     equatoiral sinking region
c      j=indp(yt(1)+3.*r/beta,yt,ny)
c      bstar(j_eq-j/2:j_eq+j/2)=-2./1024.*9.81
      end subroutine  setup_forcing



      subroutine setup_topography
c----------------------------------------------------------------------
c     configure topography here
c----------------------------------------------------------------------
      use deep_module
      implicit none
      integer :: j,k
      real :: fxa
      do j=1,ny
       do k=1,nz
c         fxa=400*exp( -(yt(j)-3000e3)**2/1000e3**2 )
c         if (zt(k) <= fxa) maskT(j,k)=0.0
       enddo
      enddo
      end subroutine setup_topography
 


      subroutine time_dependent_forcing
      end subroutine time_dependent_forcing
