#include "options.inc"


      subroutine momentum_boundary
c----------------------------------------------------------------------
c     momentum tendency in boundary layer without pressure
c----------------------------------------------------------------------
      use deep_module
      implicit none
      integer :: j,k
      real :: diff_ft(ny,nz)
c     zonal momentum tendency in boundary layer without pressure
c     diffusive flux at top side
      do k=1,nz-1
       do j=2,ny-1
        diff_ft(j,k)=A_v*(ub(j,k+1,taum1)-ub(j,k,taum1))/dz
     &               *maskW(j,k)
       enddo
      enddo
      diff_ft(:,nz-1)=taux*maskT(:,nz-1)

      do k=2,nz-1
       do j=2,ny-1
        fub(j,k) = maskT(j,k)*( 
     &   coriolis_t(j)*(vb(j-1,k,tau)+vb(j,k,tau))/2.0
     &       - r*ub(j,k,taum1)
     & +A_h*(ub(j+1,k,taum1)-2*ub(j,k,taum1)+ub(j-1,k,taum1))/dy**2
     & +A_hx*(ui(j,k,taum1)-2*ub(j,k,taum1))/delta**2
     &      +(diff_ft(j,k)-diff_ft(j,k-1))/dz
     &               )
       enddo
      enddo
c
c        bar( A_h u_xx) = A_h ( (u_x)_delta - (u_x)_W )/delta
c
c
      k=2; fub(:,k) = fub(:,k)+maskT(:,k)*(-r_b*ub(:,k,taum1) )
c     meridional momentum tendency in boundary layer without pressure
c     diffusive flux at top side
      do k=1,nz-1
       do j=2,ny-1
        diff_ft(j,k)=A_v*(vb(j,k+1,taum1)-vb(j,k,taum1))/dz
     &               *maskV(j,k)*maskV(j,k+1)
       enddo
      enddo
      do k=2,nz-1
       do j=2,ny-1
        fvb(j,k) = maskV(j,k)*(
     &         -(coriolis_t(j  )*ub(j,k  ,tau)
     &          +coriolis_t(j+1)*ub(j+1,k,tau))/2.0
     &       - r*vb(j,k,taum1)
     & +A_h*(vb(j+1,k,taum1)-2*vb(j,k,taum1)+vb(j-1,k,taum1))/dy**2
     & +A_hx*(vi(j,k,taum1)-vb(j,k,taum1))/delta**2
     &      +(diff_ft(j,k)-diff_ft(j,k-1))/dz
     &               )
       enddo
      enddo
      k=2; fvb(:,k) = fvb(:,k)+maskT(:,k)*(-r_b*vb(:,k,taum1) )
      end subroutine momentum_boundary



      subroutine momentum_interior
c----------------------------------------------------------------------
c     momentum tendency in interior without pressure
c----------------------------------------------------------------------
      use deep_module
      implicit none
      integer :: j,k
      real :: diff_ft(ny,nz)
c     zonal momentum tendency in interior without pressure
c     diffusive flux at top side
      do k=1,nz-1
       do j=2,ny-1
        diff_ft(j,k)=A_v*(ui(j,k+1,taum1)-ui(j,k,taum1))/dz
     &               *maskW(j,k)
       enddo
      enddo
      diff_ft(:,nz-1)=taux*maskT(:,nz-1)

      do k=2,nz-1
       do j=2,ny-1
        fui(j,k) = maskT(j,k)*(
     &   coriolis_t(j)*(vi(j-1,k,tau)+vi(j,k,tau))/2.0
     &       - r*ui(j,k,taum1)
     & +A_h*(ui(j+1,k,taum1)-2*ui(j,k,taum1)+ui(j-1,k,taum1))/dy**2
     & -A_hx*(ui(j,k,taum1)-ub(j,k,taum1))/delta/delta_x
     &      +(diff_ft(j,k)-diff_ft(j,k-1))/dz
     &               )
       enddo
      enddo
      k=2; fui(:,k) = fui(:,k)+maskT(:,k)*(-r_b*ui(:,k,taum1) )
c     meridional momentum tendency in interior without pressure
c     diffusive flux at top side
      do k=1,nz-1
       do j=2,ny-1
        diff_ft(j,k)=A_v*(vi(j,k+1,taum1)-vi(j,k,taum1))/dz
     &               *maskV(j,k)*maskV(j,k+1)
       enddo
      enddo
      do k=2,nz-1
       do j=2,ny-1
        fvi(j,k) = maskV(j,k)*(
     &         -(coriolis_t(j  )*ui(j,k  ,tau)
     &          +coriolis_t(j+1)*ui(j+1,k,tau))/2.0
     &       - r*vi(j,k,taum1)
     & +A_h*(vi(j+1,k,taum1)-2*vi(j,k,taum1)+vi(j-1,k,taum1))/dy**2
     & -A_hx*(vi(j,k,taum1)-vb(j,k,taum1))/delta/delta_x
     &      +(diff_ft(j,k)-diff_ft(j,k-1))/dz
     &               )
       enddo
      enddo
      k=2; fvi(:,k) = fvi(:,k)+maskT(:,k)*(-r_b*vi(:,k,taum1) )
      end subroutine momentum_interior





      subroutine trm_viscosity
c=======================================================================
c
c=======================================================================
      use deep_module
      implicit none
      integer :: j,k
      real :: fxa,fxb
      real :: Nsqrw_b(ny,nz),Nsqrw_i(ny,nz)
      real :: fNsqrw_b(ny,nz),fNsqrw_i(ny,nz)
      real :: A_uu(ny,nz)
c-----------------------------------------------------------------------
c     stability freq.
c-----------------------------------------------------------------------
      do k=1,nz-1
       do j=2,ny-1
#ifdef enable_temperature_salinity
        Nsqrw_b(j,k)=talpha*(bb(j,k+1,taum1)-bb(j,k,taum1))/dz
     &              +sbeta *(sb(j,k+1,taum1)-sb(j,k,taum1))/dz
        Nsqrw_i(j,k)=talpha*(bi(j,k+1,taum1)-bi(j,k,taum1))/dz
     &              +sbeta *(si(j,k+1,taum1)-si(j,k,taum1))/dz
#else
        Nsqrw_b(j,k)=(bb(j,k+1,taum1)-bb(j,k,taum1))/dz
        Nsqrw_i(j,k)=(bi(j,k+1,taum1)-bi(j,k,taum1))/dz
#endif
        Nsqrw_b(j,k)=max(Nsqrw_b(j,k),N_min**2)
        Nsqrw_i(j,k)=max(Nsqrw_i(j,k),N_min**2)
       enddo
      enddo
c-----------------------------------------------------------------------
c     Calculate f**2/N**2 on W grid and bound 
c-----------------------------------------------------------------------
      do k=1,nz-1
       do j=2,ny-1
        fNsqrw_b(j,k)= coriolis_t(j)**2/Nsqrw_b(j,k)
        fNsqrw_b(j,k)=min(fNsqrw_b(j,k),fNsqr_max)
        fNsqrw_i(j,k)= coriolis_t(j)**2/Nsqrw_i(j,k)
        fNsqrw_i(j,k)=min(fNsqrw_i(j,k),fNsqr_max)
       enddo
      enddo
c-----------------------------------------------------------------------
c    vertical viscosity
c-----------------------------------------------------------------------
      do k=1,nz-1
       do j=2,ny-1
         fxa=K_gm*(maskT(j,k)+maskW(j,k))
         fxb=maskT(j,k)+maskW(j,k)+epsln
         A_trm_b(j,k)=fxa/fxb*fNsqrw_b(j,k)!*(1.-mask_SO(j))
         A_trm_i(j,k)=fxa/fxb*fNsqrw_i(j,k)!*(1.-mask_SO(j))
       enddo
      enddo
c-----------------------------------------------------------------------
c      prepare coefficients for implicit part of vertical friction
c-----------------------------------------------------------------------
      A_uu(:,:)=0
      do k=1,nz-1
       do j=2,ny-1
         A_uu(j,k) =A_trm_b(j,k)*maskT(j,k+1)*maskT(j,k)
       enddo
      enddo
      call trm_implicit_umix(A_uu,ub,maskT,fub)
      A_uu(:,:)=0
      do k=1,nz-1
       do j=2,ny-1
         A_uu(j,k) =A_trm_i(j,k)*maskT(j,k+1)*maskT(j,k)
       enddo
      enddo
      call trm_implicit_umix(A_uu,ui,maskT,fui)
c-----------------------------------------------------------------------
c      prepare coefficients for implicit part of vertical friction
c-----------------------------------------------------------------------
      A_uu(:,:)=0
      do k=1,nz-1
       do j=2,ny-1
        fxa=A_trm_b(j,k)*maskW(j,k)+A_trm_b(j+1,k)*maskW(j+1,k)
        fxb=maskW(j,k)+maskW(j+1,k)+epsln
        A_uu(j,k) =fxa/fxb*maskV(j,k+1)*maskV(j,k)
       enddo
      enddo
      call trm_implicit_umix(A_uu,vb,maskV,fvb)
      A_uu(:,:)=0
      do k=1,nz-1
       do j=2,ny-1
        fxa=A_trm_i(j,k)*maskW(j,k)+A_trm_i(j+1,k)*maskW(j+1,k)
        fxb=maskW(j,k)+maskW(j+1,k)+epsln
        A_uu(j,k) =fxa/fxb*maskV(j,k+1)*maskV(j,k)
       enddo
      enddo
      call trm_implicit_umix(A_uu,vi,maskV,fvi)
      end subroutine trm_viscosity




      subroutine trm_implicit_umix(A_uu,uu,maskM,fuu)
c=======================================================================
c     implicit vertical friction
c=======================================================================
      use deep_module
      implicit none
      real :: A_uu(ny,nz) 
      real :: uu(ny,nz,0:2) ,maskM(ny,nz),fuu(ny,nz)
      integer :: j,k
      real :: a(nz),bq(nz),c(nz),bet
      real :: pu(nz),gam(nz),fxa,rq(nz)
c---------------------------------------------------------------------------------
c      first fake integrate du/dt = F_u, then solve for rest
c---------------------------------------------------------------------------------
      uu(:,:,taup1)= uu(:,:,taum1)+c2dt*fuu(:,:)*maskM
      do j=2,ny-1
       fxa = c2dt/dz**2
       bq(1) = 1+fxa * A_uu(j,1)
       c(1)  =  -fxa * A_uu(j,1)
       do k=2,nz-1
         a(k)  =  -fxa * A_uu(j,k-1)
         bq(k) = 1+fxa * (A_uu(j,k)+A_uu(j,k-1) )
         c(k)  =  -fxa * A_uu(j,k)
       enddo
       a(nz)  =  -fxa * A_uu(j,nz-1)
       bq(nz) = 1+fxa * A_uu(j,nz-1) 
       pu=0.0;gam=0.0
       rq=uu(j,:,taup1)*maskM(j,:)
       bet=bq(1)
       if (bet/=0.0) pu(1)=rq(1)/bet
       do k=2,nz
        if (bet/=0.0) gam(k)=c(k-1)/bet
        bet=bq(k)-a(k)*gam(k)
        if (bet/=0.0) pu(k)=(rq(k)-a(k)*pu(k-1))/bet
       enddo
       do k=nz-1,1,-1
        pu(k)=pu(k)-gam(k+1)*pu(k+1)
       enddo
       uu(j,:,taup1)=pu
      enddo
      fuu(:,:)=(uu(:,:,taup1)-uu(:,:,taum1))/c2dt*maskM
      end subroutine trm_implicit_umix


