#include "options.inc"

c choose one of the following setups
c#include "THC1_setup.F"
c#include "THC_hysterese1_setup.F"
c#include "THC_hysterese2_setup.F"
c#include "ACC1_setup.F"
c#include "SO1_setup.F"
#include "St-Arons_setup.F"


      program driver
c----------------------------------------------------------------------
c     main driver
c----------------------------------------------------------------------
      use deep_module
      implicit none
      call tic('setup'); call setup; call toc('setup')
 20    continue
        call time_step_begin()
        call tic('main loop')
        call time_dependent_forcing
        call tic('pressure'); call pressure; call toc('pressure')
        call tic('buoyancy'); call buoyancy; call toc('buoyancy')
        call tic('integrate'); call integrate; call toc('integrate')
        call tic('diagnose'); call diagnose; call toc('diagnose')
        call toc('main loop')
        call time_step_end()
       if (.not. end_of_run ) goto 20
      print*,' all done '
      call show_timing
      end program driver


      subroutine show_timing
      use deep_module
      implicit none
      real :: fxa,fxb
      character (len=128) :: s
      print*,''
      print*,'Timing summary:'
      print*,' setup time summary       = ',
     &   timing_secs('setup'),' s'
      print*,' costs for measuring      = ',
     &   timing_secs('tictoc'),' s'
      print*,' main loop time summary    = ',
     &   timing_secs('main loop') ,' s'

      fxa= timing_secs('main loop') 
      print*,' '
      print*,' in main loop: '
      print*,' '
      s='pressure';fxb=timing_secs(s)
      print*,' ',s(1:len_trim(s)),' time summary     = ',
     &   ' s',fxb, ' = ',fxb/fxa*100,'% of main loop'
      s='buoyancy';fxb=timing_secs(s)
      print*,' ',s(1:len_trim(s)),' time summary     = ',
     &   ' s',fxb, ' = ',fxb/fxa*100,'% of main loop'
      s='integrate';fxb=timing_secs(s)
      print*,' ',s(1:len_trim(s)),' time summary     = ',
     &   ' s',fxb, ' = ',fxb/fxa*100,'% of main loop'
      s='diagnose';fxb=timing_secs(s)
      print*,' ',s(1:len_trim(s)),' time summary     = ',
     &   ' s',fxb, ' = ',fxb/fxa*100,'% of main loop'

#ifdef notdef
      print*,' '
      print*,' in pressure: '
      print*,' '
      s='momentum';fxb=timing_secs(s)
      print*,' ',s(1:len_trim(s)),' time summary     = ',
     &   ' s',fxb, ' = ',fxb/fxa*100,'% of main loop'
      s='trm_momentum';fxb=timing_secs(s)
      print*,' ',s(1:len_trim(s)),' time summary     = ',
     &   ' s',fxb, ' = ',fxb/fxa*100,'% of main loop'
      s='congrad';fxb=timing_secs(s)
      print*,' ',s(1:len_trim(s)),' time summary     = ',
     &   ' s',fxb, ' = ',fxb/fxa*100,'% of main loop'

      print*,' '
      print*,' in buoyancy: '
      print*,' '
      s='vertical_vel';fxb=timing_secs(s)
      print*,' ',s(1:len_trim(s)),' time summary     = ',
     &   ' s',fxb, ' = ',fxb/fxa*100,'% of main loop'
      s='advection';fxb=timing_secs(s)
      print*,' ',s(1:len_trim(s)),' time summary     = ',
     &   ' s',fxb, ' = ',fxb/fxa*100,'% of main loop'
      s='diffusion';fxb=timing_secs(s)
      print*,' ',s(1:len_trim(s)),' time summary     = ',
     &   ' s',fxb, ' = ',fxb/fxa*100,'% of main loop'
      s='convection';fxb=timing_secs(s)
      print*,' ',s(1:len_trim(s)),' time summary     = ',
     &   ' s',fxb, ' = ',fxb/fxa*100,'% of main loop'
      s='buoyancy_int';fxb=timing_secs(s)
      print*,' ',s(1:len_trim(s)),' time summary     = ',
     &   ' s',fxb, ' = ',fxb/fxa*100,'% of main loop'
#endif

      end subroutine show_timing



      subroutine setup
c----------------------------------------------------------------------
c     setup everything
c----------------------------------------------------------------------
      use deep_module
      implicit none
      integer :: j,k,indp
      real :: fxa

      print*,''
      print*,'--------------------------------------------------'
      print*,'       setting up 2D model version ',version
      print*,'--------------------------------------------------'
      print*,''

      call set_parameter

      print*,' Domain is ',ny,' x ',nz,' grid points'
      print*,' Horizontal resolution is ',dy/1e3,' km '
      print*,' Vertical resolution is ',dz,' m '
      print*,' Domain extent is ',ny*dy/1e3, 'km x ',nz*dz,' m'
      print*,' Domain starts at y = ',y_0/1e3,' km'
      print*,' Domain ends at y   = ',(y_0+ny*dy)/1e3,' km'
      print*,' r       = ',r,' 1/s'
      print*,' r_b     = ',r_b,' 1/s'
      print*,' beta    = ',beta,' 1/ms' 
      print*,' K_h     = ',K_h,' m^2/s'
      print*,' K_v     = ',K_v,' m^2/s'
      print*,' A_h     = ',A_h,' m^2/s'
      print*,' A_v     = ',A_v,' m^2/s'
      print*,' delta   = ',delta/1e3,' km'
      print*,' Delta x = ',Delta_x/1e3,' km'
      print*,' gamma1  = ',gamma1
      print*,' gamma2  = ',gamma2
      print*,' surf.rest  = ',surf_rest
#ifdef enable_advection_quicker
      print*,' using quicker advection scheme'
#endif
#ifdef enable_advection_2nd
      print*,' using 2nd order advection scheme'
#endif 
#ifdef enable_trm_vertical_viscosity
      print*,' using TRM vertical velocity with'
      print*,' K_gm    = ',K_gm,' m^2/s'
      print*,' N_min   = ', N_min,' 1/s'
      print*,' fNsqr_max = ',fNsqr_max 
      print*,' eps_sor   = ',eps_sor
#endif
#ifdef enable_temperature_salinity
      print*,' using temperature and salinity with'
      print*,' db/dT = ',talpha,' m/s^2 /K '
      print*,' db/dS = ',sbeta ,' m/s^2 /(1e-3 g/Kg) '
      print*,' isoypcnal diffusivity K_iso=',K_iso,' m^2/s'
#endif

      call allocate_deep_module

c     generate grid
      Ly=ny*dy; Lz=nz*dz
      do j=1,ny
        yt(j)=y_0+j*dy; yu(j)=yt(j)+dy/2
      enddo
      do k=1,nz
       zt(k)=k*dz ; zw(k)=k*dz+dz/2.
      enddo

c     land masks
      maskT=1;
      maskT(:,1)=0; maskT(:,nz)=0
      maskT(1,:)=0; maskT(ny,:)=0

      call setup_topography

      maskV=maskT; maskV(ny,:)=0;
      do j=1,ny-1
       maskV(j,:)=min(maskT(j,:),maskT(j+1,:))
      enddo 
      maskW=maskT; maskW(:,nz)=0.
      do k=1,nz-1
       maskW(:,k)=min(maskT(:,k),maskT(:,k+1))
      enddo

c     topography
      hv=0.0;ht=0.0
      do k=1,nz
       do j=1,ny
        hv(j)=hv(j)+dz*maskV(j,k)
        ht(j)=ht(j)+dz*maskT(j,k)
       enddo
      enddo

c     coriolis parameter
      do j=1,ny
       coriolis_t(j)=beta*yt(j)
      enddo
c     find equator
      j_eq=indp(0.0,yt,ny)
      if (yt(j_eq)/=0.0) then
        print*,' Error: cannot find equator '
        print*,' yt(eq)=',yt(j_eq)/1000,' km'
        print*,' yt(1)=',yt(1)/1000,' km'
        stop
      endif

c     configure model and forcing
      call setup_forcing

c     some checks

#ifndef enable_trm_vertical_viscosity
      do j=1,ny
        if (mask_SO(j) /= 0.0) then
         print*,' Southern Ocean needs eddy parameterisation '
         print*,' enable CPP switch enable_trm_vertical_viscosity'
         stop
        endif
       enddo
#endif

      fxa=(A_h/beta)**(1./3.)
      print*,' boundary layer width (A_h/beta)^1/3=', fxa/1e3,' km'
      fxa=(r/beta)
      print*,' boundary layer width (r/beta)      =', fxa/1e3,' km'

      if (dy> max((A_h/beta)**(1./3.),r/beta) ) then
        print*,' both smaller than dy=',dy/1e3,' km'
        stop
      endif


c     initialize time manager and diagnostics
      call init_time_manager(dt_in,runlen,snap_int,restart_stamp,0 )
      call disable_mixing_time_steps
      call init_snap_cdf()
      end subroutine setup



      subroutine integrate
c----------------------------------------------------------------------
c     integrate momentum with pressure gradient
c----------------------------------------------------------------------
      use deep_module
      implicit none
      integer :: j,k
      real :: fxa,dh(ny,nz)
c
c     integrate zonal momentum in western boundary layer
      do k=2,nz-1
       do j=2,ny-1
        ub(j,k,taup1) = ub(j,k,taum1)+maskT(j,k)*c2dt*(
     &   fub(j,k)-gamma1*(pii(j,k)-pb(j,k))/delta*(1.-mask_SO(j)) )
       enddo
      enddo
c     integrate meridional momentum in western boundary layer
      do k=2,nz-1
       do j=2,ny-1
        vb(j,k,taup1) = vb(j,k,taum1)+maskV(j,k)*c2dt*(
     &      fvb(j,k)-(pb(j+1,k)-pb(j,k))/dy )
       enddo
      enddo

c     zonal pressure difference in interior
      do k=2,nz-1
       dh(j_eq,k)=0.
       do j=j_eq+1,ny-1
        dh(j,k)=dh(j-1,k)+dy*coriolis_t(j)
     &         *gamma2*ub(j,k,tau)/Delta_x*maskT(j,k)
       enddo
c       dh(j_eq-1,k)=0.
c       do j=j_eq-2,2,-1
       do j=j_eq-1,2,-1
        dh(j,k)=dh(j+1,k)-dy*coriolis_t(j)
     &         *gamma2*ub(j,k,tau)/Delta_x*maskT(j,k)
       enddo
      enddo
      do k=2,nz-1
        fxa=fui(j_eq,k)-
     &   coriolis_t(j_eq)*(vi(j_eq-1,k,tau)+vi(j_eq,k,tau))/2.0
       do j=2,ny-1
        dh(j,k)=dh(j,k)+fxa
       enddo
      enddo

c     integrate zonal momentum in interior
      do k=2,nz-1
       do j=2,ny-1
        ui(j,k,taup1) = ui(j,k,taum1)+maskT(j,k)*c2dt*(
     &   fui(j,k)-dh(j,k)*(1.-mask_SO(j)) )
       enddo
      enddo
c     integrate meridional momentum in interior
      do k=2,nz-1
       do j=2,ny-1
        vi(j,k,taup1) = vi(j,k,taum1)+maskV(j,k)*c2dt*(
     &      fvi(j,k)-(pii(j+1,k)-pii(j,k))/dy )
       enddo
      enddo

c----------------------------------------------------------------------
c     roberts time filter
      ub(:,:,tau) = ub(:,:,tau) + gamma*
     &       (0.5*(ub(:,:,taup1)+ub(:,:,taum1))-ub(:,:,tau)) 
      vb(:,:,tau) = vb(:,:,tau) + gamma*
     &       (0.5*(vb(:,:,taup1)+vb(:,:,taum1))-vb(:,:,tau)) 
      bb(:,:,tau) = bb(:,:,tau) + gamma*
     &       (0.5*(bb(:,:,taup1)+bb(:,:,taum1))-bb(:,:,tau)) 
      ui(:,:,tau) = ui(:,:,tau) + gamma*
     &       (0.5*(ui(:,:,taup1)+ui(:,:,taum1))-ui(:,:,tau)) 
      vi(:,:,tau) = vi(:,:,tau) + gamma*
     &       (0.5*(vi(:,:,taup1)+vi(:,:,taum1))-vi(:,:,tau)) 
      bi(:,:,tau) = bi(:,:,tau) + gamma*
     &       (0.5*(bi(:,:,taup1)+bi(:,:,taum1))-bi(:,:,tau)) 


#ifdef enable_temperature_salinity
      si(:,:,tau) = si(:,:,tau) + gamma*
     &       (0.5*(si(:,:,taup1)+si(:,:,taum1))-si(:,:,tau)) 
      sb(:,:,tau) = sb(:,:,tau) + gamma*
     &       (0.5*(sb(:,:,taup1)+sb(:,:,taum1))-sb(:,:,tau)) 
#endif
      end subroutine integrate










