#include "options.inc"

c
c--------------------------------------------------------
c  local cpp directives for topography generation
c--------------------------------------------------------
c
c use either etopo5 or etopo2 topography
c
#define use_ETOPO5_topography
c#define use_ETOPO2_topography
c
c--------------------------------------------------------
c  local cpp directives for initial conditions
c--------------------------------------------------------
c
c  NOTE: enable only one of the following four switches
c
c  read IC conditions from global Levitus 94 climatology
c  Note that SSS restoring data and data for eventual sponge layers
c  come as well from this dataset for this choice
#define read_ic_from_LEV94
c
c  read IC conditions from a combined Levitus 94 and 
c  Levitus 98 dataset, resulting in higher spatial
c  resolution (1/4 deg). This dataset covers the Atlantic
c  domain only.
c#define read_ic_from_LEV98
c
c  read initial conditions from the annual mean
c  WOCE SAC climatology.
c#define read_ic_from_SAC
c
c  read initial conditions from model climatology 
c  itself. (can be useful for semi-progn. method).
c#define read_ic_from_E5

c
c  some switches for preparing initial conditions
c  for passive tracers.
c
c  setup CFC
c#define  prep_for_CFC 
c  setup nitrat based ecosystem model +CO2 +O2 + DOC
c#define  prep_for_NPZD
c  setup in addition CFC11/12 another CO2 and antr. CO2
c#define  prep_for_ACO2
c  setup simple passive tracers 
c#define  prep_for_LEDWELL
c
c#define prep_for_OBC_tracer
c
c--------------------------------------------------------
c  local cpp directives for surface boundary setup 
c--------------------------------------------------------
c
c read wind stress either from ECMWF analysis (same forcing
c as used in the DYNAMO project), from NCEP/NCAR monthly wind stress
c anomalies plus the ECMWF climatology, from daily NCEP/NCAR data
c or from NAO-related wind stress (useful for the Atlantic only,
c see Eden+Jung, J. Clim. 2001), or other wind stress products.
c
c  NOTE: enable only one of the following 11 switches
c
#define read_tau_ecmwf
c#define read_tau_omip
c#define read_tau_dasilva
c#define read_tau_ecco
c#define read_tau_ncep_monthly
c#define read_tau_ncep_clim
c#define read_tau_ncep
c#define read_tau_ncep_daily
c#define read_tau_ncep_daily_large_file
c#define read_tau_T511_daily_large_file
c#define read_tau_nao_proxy
c#define read_tau_nao_ideal
c
c
c same for friction velocity
c
c  NOTE: enable only one of the following 4 switches
c
c#define read_ustar_ecmwf
c#define read_ustar_omip
c#define read_ustar_ncep_monthly
#define read_ustar_T511
c
c same for the heat fluxes
c
c  NOTE: enable only one of the following 7 switches
c
#define read_density_flx_ecmwf
c#define read_density_flx_ncep_monthly
c#define read_density_flx_omip
c#define read_density_flx_nao_proxy
c#define read_density_flx_nao_ideal
c#define read_density_flx_pml_ncep
c#define read_density_flx_T511
c
c
c  this is for the piston velocity (only for switch read_density_flx_ecmwf
c   and prep_for_NPZD)
c#define read_piston_velocity_U10
#define read_piston_velocity_WSPD
c
c
c  enable this in combination with the above two
c  and switch on diagnosed freshwater flux boundary condition
c  for salinity.
c#define read_salt_fl_from_E5
c this is for HS4_2
c#define limAmazoneSSS
c
c--------------------------------------------------------
c  local cpp directives for OBC setup 
c--------------------------------------------------------
c
c  NOTE: enable only one of the following switches
c  in this section. They are setting up 
c  specific configurations.
c
c  course resolution North Atlantic model
c#define read_psi_for_K1
c  4/3 deg resolution North Atlantic model
c  (similar to the one in Eden+Jung, 2001)
c#define read_psi_for_E1
c  1/3 deg resolution North Atlantic model
c#define read_psi_for_D3
c  1/3 deg resolution tropical Atlantic model
c#define read_psi_for_Q1
c  same as D1 but open northern boundary
c#define read_psi_for_D4
c  same as E1 but open northern boundary
c#define read_psi_for_E7
c  1/12 deg resolution North Atlantic model
c#define read_psi_for_HS2
c  same as HS2 but open northern boundary and med sea
c#define read_psi_for_HS3
c  1/12 deg resolution subpolar North Atlantic model
c#define read_psi_for_HS4
c  1/12 deg resolution subpolar North Atlantic model
c  with different north boundary condition
c#define read_psi_for_LS1
c  ACC model
c#define read_psi_for_A1

c--------------------------------------------------------
c  local cpp directives for sponge layer setup 
c--------------------------------------------------------

c  same as above but for the sponge layers
c  NOTE: enable only one of the following switches
c  in this section. They are setting up 
c  specific configurations.
c
c#define prep_sponge_for_K1
c#define prep_sponge_for_E1
c#define prep_sponge_for_D3
c#define prep_sponge_for_D4
c#define prep_sponge_for_E7
c#define prep_sponge_for_E0
c#define prep_sponge_for_HS2
c#define prep_sponge_for_HS3
c#define prep_sponge_for_PAC
c#define prep_sponge_for_I1

c
c--------------------------------------------------------
c  now include other template files
c--------------------------------------------------------
c
#include "prep_template_topo.F"
#include "prep_template_ic.F"
#include "prep_template_tau.F"
#include "prep_template_sflx.F"
#include "prep_template_obcpsi.F"
#include "prep_template_sponge.F"
