#include "options.inc"
c
c-----------------------------------------------------------------------
c      Templates for hardwired grid, topography, surface boundary
c      and initial concitions.
c-----------------------------------------------------------------------
c

      module eddy_coarse1_module
c      real :: Bv0 = 0.004, g=9.81 
      real :: Bv0 = 0.002, g=9.81 
      real :: fac = 2.0
      real :: tscl = 1./(86400.0*1.0)
      end module eddy_coarse1_module


      subroutine grid_template()
c-----------------------------------------------------------------------
c     set up a grid here
c-----------------------------------------------------------------------
      use spflame_module
      use eddy_coarse1_module
      implicit none
      real :: dx=0.,dy=0.,dz=0.,x0=0.,y0=0.,sumt,sumu
      integer i,k
c     FLAME grid
      integer,parameter :: km_in = 45
      real ddz(km_in)
      data ddz/ 
     &  1000.0,   1044.051, 1102.236, 1169.269, 1246.635, 1336.169,
     &  1440.147, 1561.417, 1703.569, 1871.169, 2070.068, 2307.849,
     &  2594.425, 2992.892, 3518.793, 4100.175, 4863.114, 5680.496,
     &  6513.772, 7038.668, 7397.827, 7758.212, 8130.866, 8726.499,
     &  9576.454,10908.060,12732.562,15187.976,18426.63,
     &  22000.,  24182.902,24817.098, 13*250.00e2 /

c     equidistant vertical grid
c      integer,parameter :: km_in = 20
c      real ddz(km_in)
c      data ddz/ 20*100.e2 /

c     small eddy resolving region
      x0=280.; y0=30.; dx = 1./3.; dy = dx*cos(y0/180.*pi)

      if (my_pe==0) then
        print*,''
        print*,'setting up a simple grid '
        print*,' dx= ',dx,' dy= ',dy
        print*,''
      endif
      dxtdeg =  dx  ; dytdeg =  dy  ; dxudeg =  dx  ; dyudeg =  dy  
      xt(1)=x0; xu(1)=x0+dxtdeg(1)/2.
      do i=2,imt
        xt(i)=xt(i-1)+dxtdeg(i); xu(i)=xu(i-1)+dxudeg(i)
      enddo
      yt(1)=y0; yu(1)=y0+dytdeg(1)/2.
      do i=2,jmt
        yt(i)=yt(i-1)+dytdeg(i); yu(i)=yu(i-1)+dyudeg(i)
      enddo
      if (km /= km_in ) then
        print*,' km must be ',km_in
        stop
      endif
      dzt=ddz; dzw(1) = dzt(1); sumt = dzt(1)
      sumu = 0.5*dzt(1) + dzw(1)
      do i=2,km
       sumt = sumt + dzt(i)
       dzw(i) = 2*(sumt-sumu)
       sumu = sumu + dzw(i)
      enddo
      zt(1) = 0.5*dzt(1); zw(1) = dzt(1)
      do i=2,km
        zw(i) = zw(i-1) + dzt(i); zt(i) = zt(i-1) + dzw(i-1)
      enddo
      dzw(0)  = zt(1); dzw(km) = zw(km) - zt(km)
      end subroutine grid_template



      subroutine kmt_template
c-----------------------------------------------------------------------
c     set up a simple topography
c-----------------------------------------------------------------------
      use spflame_module
      implicit none
      kmt_big=km
      end subroutine kmt_template



      subroutine htp_template
c-----------------------------------------------------------------------
c     set up a simple topography for partial cells
c-----------------------------------------------------------------------
      use spflame_module
      implicit none
      htp=zw(km)
      end subroutine htp_template



      subroutine init_cond_template
c-----------------------------------------------------------------------
c     setup simple initial conditions
c     for temperature, salinity and velocity
c     Note that streamfunction is diagnosed from full velocities.
c-----------------------------------------------------------------------
      use spflame_module
      use freesurf_module
      use eddy_coarse1_module
      implicit none
      integer :: i,j,k,n
      real :: x,y,z,h0,h_w,T0

      do j=js_pe,je_pe
       do k=1,km
        do i=is_pe,ie_pe
            t(i,k,j,1:nt,:) = 0.   ! salinity equals 35 PSU
            x=float(i)/float(imt)
            y=float(j)/float(jmt)
            T0=20+y*fac
            t(i,k,j,1,:) = T0+1/(g*alpha_lin)*zt(k)/100.*Bv0**2
            t(i,k,j,1,:) = t(i,k,j,1,:)*tmask(i,k,j)
            t(i,k,j,2,:) = 0/(g*0.1e-3)*zt(k)/100.*Bv0**2/10.0 /1000.
            t(i,k,j,2,:) = t(i,k,j,2,:)*tmask(i,k,j)
        enddo 
       enddo
      enddo

      do n=1,nt
       call set_cyclic_4th_order(t(:,:,:,n,0),km,2)
       call set_cyclic_4th_order(t(:,:,:,n,1),km,2)
      enddo
      end subroutine init_cond_template


      subroutine sbc_template
c-----------------------------------------------------------------------
c     setup simple surface boundary conditions
c-----------------------------------------------------------------------
      use spflame_module
      implicit none
c     no wind stress      
      smf=0.
c       no heat or salt fluxes
      stf_clim=0.
      stf_rest=0.
c       no wind stirring
      if (enable_ktmix.or.enable_tkemix) ustar=0.     ! no wind stirring
      end subroutine sbc_template


      subroutine blue_template
c-----------------------------------------------------------------------
c     setup simple temp / salinity arrays for BLUE
c-----------------------------------------------------------------------
      use spflame_module
      use blue_module
      implicit none
      end subroutine blue_template



      subroutine sponge_template(n)
c-----------------------------------------------------------------------
c     setup simple sponge layers. 
c-----------------------------------------------------------------------
      use spflame_module
      use eddy_coarse1_module
      implicit none
      integer, intent(in) :: n ! number of the tracer
      integer :: i,j,k
      real :: x,y,z,h0,h_w,T0
      integer :: spg_width = 3

      if (n==1) then

       if (my_blk_j==1) then
        do j=2,(spg_width+1)
         do k=1,km
          do i=is_pe,ie_pe
           x=float(i)/float(imt)
           y=float(j)/float(jmt)
           T0=20+y*fac+1./(g*alpha_lin)*zt(k)/100.*Bv0**2
           source(i,k,j)=source(i,k,j)+
     &         tscl/(j-1.)*(T0-t(i,k,j,n,taum1))*tmask(i,k,j)
          enddo
         enddo
        enddo
       endif

       if (my_blk_j==n_pes_j) then
        do j=jmt-1,jmt-spg_width,-1
         do k=1,km
          do i=is_pe,ie_pe
           x=float(i)/float(imt)
           y=float(j)/float(jmt)
           T0=20+y*fac+1./(g*alpha_lin)*zt(k)/100.*Bv0**2
           source(i,k,j)=source(i,k,j)+
     &          tscl/(-1*(j-jmt))*
     &        (T0-t(i,k,j,n,taum1))*tmask(i,k,j)
          enddo
         enddo
        enddo
       endif

      elseif (n==2) then

c
c    for a passive tracer
c
       if (my_blk_j==1) then
        do j=2,(spg_width+1)
         do k=1,km
          do i=is_pe,ie_pe
c          T0=1.0
c           source(i,k,j)=source(i,k,j)+
c     &         tscl/(j-1.)*(T0-t(i,k,j,n,taum1))*tmask(i,k,j)
c     &        *exp( - (zt(k)-500.e2)**2/ (250.e2)**2 )

c           T0 = zt(k)/100e2
           T0=1.0
           source(i,k,j)=source(i,k,j)+
     &         tscl/(j-1.)*(T0-t(i,k,j,n,taum1))*tmask(i,k,j)
          enddo
         enddo
        enddo
       endif
       if (my_blk_j==n_pes_j) then
        do j=jmt-1,jmt-spg_width,-1
         do k=1,km
          do i=is_pe,ie_pe
c          T0 = -1.0
c           source(i,k,j)=source(i,k,j)+
c     &          tscl/(-1*(j-jmt))*
c     &        (T0-t(i,k,j,n,taum1))*tmask(i,k,j)
c     &        *exp( - (zt(k)-1500.e2)**2/ (250.e2)**2 )

c           T0 = zt(k)/100e2
           T0=-1.0
           source(i,k,j)=source(i,k,j)+ tscl/(-1*(j-jmt))*
     &         (T0-t(i,k,j,n,taum1))*tmask(i,k,j)
          enddo
         enddo
        enddo
       endif

      elseif (n==3) then

c
c    for a passive tracer
c
       if (my_blk_j==1) then
        do j=2,(spg_width+1)
         do k=1,km
          do i=is_pe,ie_pe
           T0 = zt(k)/100e2
           source(i,k,j)=source(i,k,j)+
     &         tscl/(j-1.)*(T0-t(i,k,j,n,taum1))*tmask(i,k,j)
          enddo
         enddo
        enddo
       endif
       if (my_blk_j==n_pes_j) then
        do j=jmt-1,jmt-spg_width,-1
         do k=1,km
          do i=is_pe,ie_pe
           T0 = zt(k)/100e2
           source(i,k,j)=source(i,k,j)+ tscl/(-1*(j-jmt))*
     &         (T0-t(i,k,j,n,taum1))*tmask(i,k,j)
          enddo
         enddo
        enddo
       endif

      endif
      end subroutine sponge_template
