#include "options.inc"
c
c-----------------------------------------------------------------------
c     Setup for midlatide basin with a mid atlantic ridge
c-----------------------------------------------------------------------
c

      subroutine grid_template()
c-----------------------------------------------------------------------
c     set up a grid here
c-----------------------------------------------------------------------
      use spflame_module
      implicit none
      real :: dx=0.,dy=0.,dz=0.,x0=0.,y0=0.,sumt,sumu
      integer i,k
      real ddz(km)

c      midlatidude basin
      x0=280.; y0=30.; dx = 100./imt; dy = dx*cos(y0/180.*pi)

      ddz(1:4)=500e2  ! 0-2500
      ddz(1+4)=400e2 ! 2500-4000
      ddz(2+4)=300e2 ! 2500-4000
      ddz(3+4)=250e2 ! 2500-4000
      ddz(4+4)=200e2 ! 2500-4000
      ddz(5+4)=150e2 ! 2500-4000
      ddz(6+4)=100e2 ! 2500-4000
      ddz(7+4)=75e2 ! 2500-4000
      ddz(8+4)=50e2 ! 2500-4000
      ddz(9+4)=35e2 ! 2500-4000
      ddz(14:km)=20e2


      if (my_pe==0) then
        print*,''
        print*,'setting up a simple grid '
        print*,' dx= ',dx,' dy= ',dy
        print*,''
      endif
      dxtdeg =  dx  ; dytdeg =  dy  ; dxudeg =  dx  ; dyudeg =  dy  
      xt(1)=x0; xu(1)=x0+dxtdeg(1)/2.
      do i=2,imt
        xt(i)=xt(i-1)+dxtdeg(i); xu(i)=xu(i-1)+dxudeg(i)
      enddo
      yt(1)=y0; yu(1)=y0+dytdeg(1)/2.
      do i=2,jmt
        yt(i)=yt(i-1)+dytdeg(i); yu(i)=yu(i-1)+dyudeg(i)
      enddo



      dzt=ddz; 
      dzw(1) = dzt(1); sumt = dzt(1)
      sumu = 0.5*dzt(1) + dzw(1)
      do i=2,km
       sumt = sumt + dzt(i)
       dzw(i) = 2*(sumt-sumu)
       sumu = sumu + dzw(i)
      enddo

      zt(1) = 0.5*dzt(1); zw(1) = dzt(1)
      do i=2,km
        zw(i) = zw(i-1) + dzt(i); zt(i) = zt(i-1) + dzw(i-1)
      enddo
      dzw(0)  = zt(1); dzw(km) = zw(km) - zt(km)


c      zw(1) = dzt(1)
c      do i=2,km
c        zw(i) = zw(i-1) + dzt(i); 
c      enddo

c      zt(1) = 0.5*dzt(1); 
c      dzw(0)=zt(1)
c      do i=2,km
c        zt(i) = (zw(i)+zt(i-1))*0.5
c      enddo
c      do i=1,km-1
c        dzw(i) = zt(i+1)-zt(i)
c      enddo


c      dzw(km) = zw(km) - zt(km)

      if (my_pe==0) then
       do k=1,km
        print'(4f12.3)',dzt(k)/100,dzw(k)/100,zt(k)/100,zw(k)/100
       enddo
      endif
      end subroutine grid_template





      subroutine kmt_template
c-----------------------------------------------------------------------
c     set up a simple topography
c-----------------------------------------------------------------------
      use spflame_module
      implicit none
      integer :: i,j,indp
      real :: hy,hcm
c     a ridge 
      do i=1,imt
       do j=1,jmt
          hy = (j-1.)/(jmt-1.)
          hcm=( 4000-500.* exp(- (xt(i)-xt(imt/2+1))**2/10.**2 ) )*100.
          kmt_big(i,j) = indp (hcm, zw, km)
       enddo
      enddo
      end subroutine kmt_template




      subroutine htp_template
c-----------------------------------------------------------------------
c     set up a simple topography for partial cells
c-----------------------------------------------------------------------
      use spflame_module
      implicit none
      integer :: i,j,indp
      real :: hy,hcm
      htp=0.
      do i=1,imt
        do j=1,jmt
           if (kmt_big(i,j)>0)  htp(i,j)=zw(kmt_big(i,j))
        enddo
      enddo
      end subroutine htp_template




      subroutine init_cond_template
c-----------------------------------------------------------------------
c     setup simple initial conditions
c     for temperature, salinity and velocity
c     Note that streamfunction is diagnosed from full velocities.
c-----------------------------------------------------------------------
      use spflame_module
      use freesurf_module
      implicit none
      integer :: i,j,k,io
      real    :: baru(is_pe:ie_pe)
      real    :: Bv0,T0,g,stoe,x,y,z,h_W
      integer :: ii,jj,kk,indp
c
c-----------------------------------------------------------------------
c       a constant background stratification (const N^2)
c-----------------------------------------------------------------------
c
         Bv0 = 0.0026; T0=20.0; g=9.81; 
         do j=js_pe,je_pe
          do k=1,km
           do i=is_pe,ie_pe
            t(i,k,j,2,:) = 0.   ! salinity equals 35 PSU
            h_W = 2500.
            x=(float(i)/float(imt)-0.5)*2.
            y=(float(j)/float(jmt)-0.5)*2.
            stoe = 0.05*exp( - (yt(j)-yt(jmt/2))**2/5.**2
     &                  -  (xt(i)-xt(3*imt/4))**2/5.**2 )
            T0=20.0
#ifdef partial_cell
            T0 = T0+stoe*exp(-ztp(i,k,j)/100. /h_W )
            t(i,k,j,1,:) = T0+1/(g*alpha_lin)*ztp(i,k,j)/100.*Bv0**2
#else
            T0 = T0+stoe*exp(-zt(k)/100. /h_W )
            t(i,k,j,1,:) = T0+1/(g*alpha_lin)*zt(k)/100.*Bv0**2
#endif
            t(i,k,j,1,:) = t(i,k,j,1,:)*tmask(i,k,j)

           enddo 
          enddo
         enddo

      end subroutine init_cond_template



      subroutine sbc_template
c-----------------------------------------------------------------------
c     setup simple surface boundary conditions
c-----------------------------------------------------------------------
      use spflame_module
      implicit none
      integer :: i,j,k,is,ie,js,je
      real            :: y,x
      is=max(is_pe,2); ie=min(ie_pe,imt-1)
      js=max(2,js_pe); je=min(je_pe,jmt-1)
c   no wind stress
      smf=0.
c   no heat or salt fluxes
      stf_clim=0.
      stf_rest=0.
c   no wind stirring
      if (enable_ktmix.or.enable_tkemix) ustar=0.     ! no wind stirring
      end subroutine sbc_template


      subroutine blue_template
c-----------------------------------------------------------------------
c     setup simple temp / salinity arrays for BLUE
c-----------------------------------------------------------------------
      use spflame_module
      use blue_module
      implicit none
      end subroutine blue_template



      subroutine sponge_template(n)
c-----------------------------------------------------------------------
c     setup simple sponge layers. 
c-----------------------------------------------------------------------
      use spflame_module
      implicit none
      integer, intent(in) :: n ! number of the tracer
      end subroutine sponge_template
