#include "options.inc"
c
c-----------------------------------------------------------------------
c    equatorial basin
c-----------------------------------------------------------------------
c

      subroutine grid_template()
c-----------------------------------------------------------------------
c     set up a grid here
c-----------------------------------------------------------------------
      use spflame_module
      implicit none
      real :: dx=0.,dy=0.,dz=0.,x0=0.,y0=0.,sumt,sumu
      integer i,k
      integer,parameter :: km_in = 45
      real ddz(km_in)
      data ddz/ 
     &  1000.0,   1044.051, 1102.236, 1169.269, 1246.635, 1336.169,
     &  1440.147, 1561.417, 1703.569, 1871.169, 2070.068, 2307.849,
     &  2594.425, 2992.892, 3518.793, 4100.175, 4863.114, 5680.496,
     &  6513.772, 7038.668, 7397.827, 7758.212, 8130.866, 8726.499,
     &  9576.454,10908.060,12732.562,15187.976,18426.63,
     &  22000.,  24182.902,24817.098, 13*250.00e2 /
c
c     equatorial basin
      x0=280.; dx=2.;dy=2.; y0=-jmt/2.*dy + dy/2.
c

      if (my_pe==0) then
        print*,''
        print*,'setting up a simple grid '
        print*,' dx= ',dx,' dy= ',dy
        print*,''
      endif
      dxtdeg =  dx  ; dytdeg =  dy  ; dxudeg =  dx  ; dyudeg =  dy  
      xt(1)=x0; xu(1)=x0+dxtdeg(1)/2.
      do i=2,imt
        xt(i)=xt(i-1)+dxtdeg(i); xu(i)=xu(i-1)+dxudeg(i)
      enddo
      yt(1)=y0; yu(1)=y0+dytdeg(1)/2.
      do i=2,jmt
        yt(i)=yt(i-1)+dytdeg(i); yu(i)=yu(i-1)+dyudeg(i)
      enddo
      if (km /= km_in ) then
        print*,' km must be ',km_in
        stop
      endif
      dzt=ddz; dzw(1) = dzt(1); sumt = dzt(1)
      sumu = 0.5*dzt(1) + dzw(1)
      do i=2,km
       sumt = sumt + dzt(i)
       dzw(i) = 2*(sumt-sumu)
       sumu = sumu + dzw(i)
      enddo
      zt(1) = 0.5*dzt(1); zw(1) = dzt(1)
      do i=2,km
        zw(i) = zw(i-1) + dzt(i); zt(i) = zt(i-1) + dzw(i-1)
      enddo
      dzw(0)  = zt(1); dzw(km) = zw(km) - zt(km)
      end subroutine grid_template





      subroutine kmt_template
c-----------------------------------------------------------------------
c     set up a simple topography
c-----------------------------------------------------------------------
      use spflame_module
      implicit none
c     flat bottom
      kmt_big=km
      end subroutine kmt_template




      subroutine htp_template
c-----------------------------------------------------------------------
c     set up a simple topography for partial cells
c-----------------------------------------------------------------------
      use spflame_module
      implicit none
      integer :: i,j
      htp=0.
      do i=1,imt
        do j=1,jmt
           if (kmt_big(i,j)>0)  htp(i,j)=zw(kmt_big(i,j))
        enddo
      enddo
      end subroutine htp_template




      subroutine init_cond_template
c-----------------------------------------------------------------------
c     setup simple initial conditions
c     for temperature, salinity and velocity
c     Note that streamfunction is diagnosed from full velocities.
c-----------------------------------------------------------------------
      use spflame_module
      use freesurf_module
      implicit none
      integer :: i,j,k,io
      real    :: baru(is_pe:ie_pe)
      real    :: Bv0,T0,g,stoe,x,y,z,h_W
      integer :: ii,jj,kk,indp

c
c-----------------------------------------------------------------------
c       a constant background stratification (const N^2)
c-----------------------------------------------------------------------
c
c         Bv0 = 0.0026; T0=20.0; g=9.81; 
         Bv0 = 0.0015; T0=20.0; g=9.81; 
         do j=js_pe,je_pe
          do k=1,km
           do i=is_pe,ie_pe
            t(i,k,j,2,:) = 0.   ! salinity equals 35 PSU
            h_W = 500.
            x=(float(i)/float(imt)-0.5)*2.
            y=(float(j)/float(jmt)-0.5)*2.
            stoe = 0. 
            T0=20.0
#ifdef partial_cell
            T0 = T0+stoe*exp(-ztp(i,k,j)/100. /h_W )
            t(i,k,j,1,:) = T0+1/(g*alpha_lin)*ztp(i,k,j)/100.*Bv0**2
#else
            T0 = T0+stoe*exp(-zt(k)/100. /h_W )
            t(i,k,j,1,:) = T0+1/(g*alpha_lin)*zt(k)/100.*Bv0**2
#endif
            t(i,k,j,1,:) = t(i,k,j,1,:)*tmask(i,k,j)
           enddo 
          enddo
         enddo
      end subroutine init_cond_template



      subroutine sbc_template
c-----------------------------------------------------------------------
c     setup simple surface boundary conditions
c-----------------------------------------------------------------------
      use spflame_module
      implicit none
      integer :: i,j,k,is,ie,js,je
      real            :: y,x
      is=max(is_pe,2); ie=min(ie_pe,imt-1)
      js=max(2,js_pe); je=min(je_pe,jmt-1)
c   zonal wind stress in western part of domain, El Nino setup
	is=1;   is=max(is,is_pe)
	ie = nint(imt/6.) ; ie = min(ie,ie_pe)
 	if (is<=ie) smf(is:ie,js:je,1)=-0.5*umask(is:ie,1,js:je)
        is=max(is_pe,2); ie=min(ie_pe,imt-1)
c  no heat or salt fluxes
      stf_clim=0.
      stf_rest=0.
c   no wind stirring
      if (enable_ktmix.or.enable_tkemix) ustar=0.     ! no wind stirring
      end subroutine sbc_template



      subroutine blue_template
c-----------------------------------------------------------------------
c     setup simple temp / salinity arrays for BLUE
c-----------------------------------------------------------------------
      use spflame_module
      use blue_module
      implicit none
      end subroutine blue_template



      subroutine sponge_template(n)
c-----------------------------------------------------------------------
c     setup simple sponge layers. 
c-----------------------------------------------------------------------
      use spflame_module
      implicit none
      integer, intent(in) :: n ! number of the tracer
      end subroutine sponge_template
