#include "options.inc"


      program nc_cat
c=======================================================================
c  concatenate netcdf variable in several files along last dimension
c=======================================================================
      implicit none
      real,parameter :: version = 0.1
      integer,allocatable :: ncin(:),varin(:)
      integer :: ncout,varout,nr_infiles
      integer :: nr_com,n,ierr
      character (len=80) :: fname,varname,dimname
      character (len=2000) :: outstr,str2
#include "netcdf.inc"
      integer :: iret,ndims,dimlen,len,m,istart
      integer, parameter :: ndmax=100
      integer, dimension(ndmax)  :: dimid,start,count
      real :: fx
      real , allocatable :: buf(:)
      integer :: buflen

      print'(" This is nc_cat.x :: version ",f5.3)',version
c  read command line input
      call get_commandline_argnr(nr_com)
      if (nr_com<4) goto 100
      nr_infiles = nr_com-2
      allocate( ncin(nr_infiles), varin(nr_infiles) )
      call get_commandline_arg(nr_com,varname,ierr)
c    write some information to stdout
      outstr=' concatenating variable '//varname(1:len_trim(varname))
      outstr = outstr(1:len_trim(outstr))//' in files :'
      do n=1,nr_infiles
       call get_commandline_arg(n,fname,ierr)
       outstr=outstr(1:len_trim(outstr))//fname(1:len_trim(fname))//','
      enddo
      call get_commandline_arg(nr_com-1,fname,ierr)
      outstr=outstr(1:len_trim(outstr)-1)//' and writing to file '//
     &   fname(1:len_trim(fname))
      print*,outstr(1:len_trim(outstr))

c   open input files and search for variable
      do n=1,nr_infiles
       call get_commandline_arg(n,fname,ierr)
       iret=nf_open(fname,NF_NOWRITE,ncin(n))
       if (iret /=0 ) goto 110
       iret=nf_inq_varid(ncin(n),varname,varin(n))
       if (iret /=0 ) goto 120
      enddo
c   create output file
      call get_commandline_arg(nr_com-1,fname,ierr)
      ncout = nccre (fname, NCNOCLOB, iret)
      if (iret /=0 ) goto 110
      iret=nf_set_fill(ncout, NF_NOFILL, iret)
c   determine overall length of last dimension
      len=0
      do n=1,nr_infiles
       iret=nf_inq_varndims(ncin(n),varin(n),ndims)
       if (ndims>ndmax) then
        print*,' ERROR: number of dims exceed ',ndmax
        stop
       endif
       iret=nf_inq_vardimid(ncin(n),varin(n),dimid)
       iret=nf_inq_dimlen(ncin(n),dimid(ndims),dimlen)
       len=len+dimlen
      enddo
c      print*,' determine overall length of ',len
c   copy dimensions and variables needed
      call get_commandline_arg(1,fname,ierr)
      print*,'defining output file like ',fname(1:len_trim(fname))
      call copy_variable(ncin(1),ncout,varname,.true.,len)
      call copy_file_attributes(ncin(1),ncout)
c   add another entry to attribute history
      iret = NF_GET_ATT_TEXT (NCin(1), nf_global, 'history',str2)
      iret = NF_inq_ATTlen (NCin(1), nf_global, 'history',n)
      if (iret/=0) n=0
      outstr=str2(1:n)//'\n nc_cat.x : '//outstr(1:len_trim(outstr))
      iret = NF_PUT_ATT_TEXT (NCout, nf_global, 
     &       'history',len_trim(outstr) , outstr)
      iret = nf_enddef(ncout)
      print*,' ok'

      iret=nf_inq_varid(ncout,varname,varout)
      iret=nf_inq_varndims(ncin(1),varin(1),ndims)
      iret=nf_inq_vardimid(ncin(1),varin(1),dimid)
      iret=NF_INQ_DIMlen (NCin, DIMId(ndims), istart)
      istart=istart+1
c   now append variables
      do n=2,nr_infiles
       call get_commandline_arg(n,fname,ierr)
       print*,'copying file ',fname(1:len_trim(fname))
       iret=nf_inq_vardimid(ncin(n),varin(n),dimid)
       buflen=1; start=1
       do m=1,ndims
        iret=NF_INQ_DIMlen (NCin(n), DIMId(m), count(m))
        buflen=buflen*count(m)
       enddo
       iret=NF_INQ_DIMname(NCin(n), DIMId(ndims),dimname)
       iret=nf_inq_varid(ncin(n),dimname,dimid(1))
       if (iret==0) then
        allocate(buf(count(ndims)))
        iret= nf_get_vara_real(ncin(n),dimid(1),1,count(ndims),buf)
        iret=nf_inq_varid(ncout,dimname,dimid(1))
        iret= nf_put_vara_real(ncout,dimid(1),istart,count(ndims),buf)
        deallocate(buf)
       endif
       allocate(buf(buflen))
       iret= nf_get_vara_real(ncin(n),varin(n),start,count,buf)
       start(ndims)=istart
       iret= nf_put_vara_real(ncout,varout,start,count,buf)
       istart=istart+count(ndims)
       deallocate(buf)
      enddo

c   close all files
      call ncclos (ncout, iret); if (iret /=0 ) goto 130
      do n=1,nr_infiles
       call ncclos (ncin(n), iret); if (iret /=0 ) goto 130
      enddo
      print*,'all done, bye'
      stop

 100  print*,' program needs command line parameter'
      print*,' input netcdf file names, output netcdf file name,'
      print*,' and variable name to be concatenated'
      stop
 110  print*,' problem opening NetCDF file ',fname(1:len_trim(fname))
      print*,' netcdf lib says: ',nf_strerror(iret)
      stop
 120  print*,' problem finding variable ',varname(1:len_trim(varname)),
     &   ' in file ',fname(1:len_trim(fname))
      print*,' netcdf lib says: ',nf_strerror(iret)
      stop
 130  print*,' problem closing NetCDF file '
      print*,' netcdf lib says: ',nf_strerror(iret)
      stop
      end program nc_cat





c   dummy routines

      subroutine barrier
      end

      subroutine halt_stop(s)
      character*(*) s
      print*,s
      stop
      end



