#include <fcntl.h>
#include <stdio.h>


#if defined C90_host || defined T3E_host || defined  SR8000_host
void  REDIRECT_STDOUT(int *id) 
#endif

#if defined IRIX_host || defined ALPHA_host || defined SX5_host ||defined SUN_host || defined LINUX_host 
void redirect_stdout_(int *id)
#endif

#if defined LINUX_real8_host 
void redirect_stdout_(int *id)
#endif

#if defined AIX_host 
void redirect_stdout(int *id)
#endif

#ifdef LINUX_host_vast90
void redirect_stdout__(int *id) 
#endif

{
   int fd, fdout;
   char name[1024];

   sprintf(name,"out.%3.3d",*id);

   fprintf(stdout,"redirecting stdout to  %s\n",name);

   fd = open(name, O_WRONLY | O_CREAT | O_TRUNC, 0644);
   if(fd<0)
   {
      perror("REDIRECT_STDOUT");
      fprintf(stderr,"Can't open %s\n",name);
      exit(1);
   }

   fdout = dup2(fd,1);
   if(fdout!=1)
   {
      perror("REDIRECT_STDOUT");
      fprintf(stderr,"dup2 failed\n");
      exit(1);
   }

   close(fd);


}
