#include "options.inc"

      program nc_test
c=======================================================================
c    test netcdf utility functions
c=======================================================================
      implicit none
      integer :: imt=10,jmt=12,km=5,itm=3
      real,parameter :: version = 0.1
#include "netcdf.inc"
      integer :: iret,ncout,dims(4),i,ncin
      integer :: lon_tdim,lat_tdim,depth_tdim,itimedim
      integer :: lon_tid,lat_tid,depth_tid,itimeid,varid
      character (len=80) :: fname = 'nc_test.cdf',name,unit
      real          , allocatable :: v2(:)
      character(len=32) :: stamp

      print'(" This is nc_test.x :: version ",f5.3)',version

       
      print*,' creating file ',fname(1:len_trim(fname))
      ncout = nccre (fname, NCNOCLOB, iret)
      if (iret /=0 ) goto 110
      iret=nf_set_fill(ncout, NF_NOFILL, iret)

      lon_tdim  = ncddef(ncout, 'Longitude_t', imt, iret)
      Lat_tdim  = ncddef(ncout, 'Latitude_t',  jmt, iret)
      depth_tdim= ncddef(ncout, 'depth_t',  km, iret)
      iTimedim  = ncddef(ncout, 'Time', nf_unlimited, iret)
c      grid variables
      dims(1)  = Lon_tdim
      Lon_tid  = ncvdef (ncout,'Longitude_t',NCFLOAT,1,dims,iret)
      dims(1)  = Lat_tdim
      Lat_tid  = ncvdef (ncout,'Latitude_t', NCFLOAT,1,dims,iret)
      dims(1)  = iTimedim
      iTimeid   = ncvdef(ncout,'Time',       NCFLOAT,1,dims,iret)
      dims(1)  = depth_tdim
      depth_tid = ncvdef (ncout,'depth_t', NCFLOAT,1,dims,iret)
c       attributes of the grid
      name = 'Longitude on T grid     '; unit = 'degrees_W       '
      call ncaptc(ncout, Lon_tid, 'long_name', NCCHAR, 24, name, iret) 
      call ncaptc(ncout, Lon_tid, 'units',     NCCHAR, 16, unit, iret) 
      name = 'Latitude on T grid      '; unit = 'degrees_N       '
      call ncaptc(ncout, Lat_tid, 'long_name', NCCHAR, 24, name, iret) 
      call ncaptc(ncout, Lat_tid, 'units',     NCCHAR, 16, unit, iret) 
      name = 'Depth of T Grid points  '; unit = 'm '
      call ncaptc(ncout, depth_tid, 'long_name',NCCHAR, 24, name, iret) 
      call ncaptc(ncout, depth_tid, 'units',    NCCHAR, 16, unit, iret) 
      name = 'Time                    '; unit = 'days            '
      call ncaptc(ncout, iTimeid, 'long_name', NCCHAR, 24, name, iret) 
      call ncaptc(ncout, iTimeid, 'units',     NCCHAR, 16, unit, iret) 
      call ncaptc(ncout, iTimeid,'time_origin',NCCHAR, 20,
     &  '31-DEC-1899 00:00:00', iret)
c       variables
      dims=(/lon_tdim,lat_tdim,depth_tdim,itimedim/)
      varid=ncvdef (ncout,'test', NCFLOAT,4,dims,iret)
      name='Explicit vertical diffusivity'; unit = 'cm**2/s'
      call ncaptc(ncout, varid, 'long_name', NCCHAR, 24, name, iret) 
      call ncaptc(ncout, varid, 'units',    NCCHAR, 16, unit, iret) 
      call ncendf(ncout, iret)

      allocate( v2(max(imt,jmt,km)) )
      do i=1,max(imt,jmt,km)
       v2(i)=i
      enddo
      iret= nf_put_vara_real (ncout,lon_tid, 1,imt,v2)
      iret= nf_put_vara_real (ncout,lat_tid, 1,jmt,v2)
      iret= nf_put_vara_real (ncout,depth_tid, 1,km,v2)

      stamp ='m/d/y= 1/ 1/1900, h:m:s= 0: 0: 0' 
      call read_stamp(stamp,v2(1))
      iret= nf_put_vara_real (ncout,itimeid, 1,1,v2)

      deallocate(v2)
      allocate( v2(imt*jmt*km) )
      v2=5.2
      iret=nf_put_vara_real(ncout,varid,(/1,1,1,1/),(/imt,jmt,km,1/),v2)

      call ncclos (ncout, iret)




      print*,' reading file ',fname(1:len_trim(fname))
      iret=nf_open(fname,NF_NOWRITE,ncin)

      name='test'

      fname='nc_test2.cdf'
      print*,' creating file ',fname(1:len_trim(fname))
      ncout = nccre (fname, NCNOCLOB, iret)
      call copy_variable(ncin,ncout,name,.false.,0)
      iret = nf_enddef(ncout)

      call add_to_variable(ncin,ncout,name)
      call mult_variable(ncout,name,2.0)

      call ncclos (ncout, iret)
      call ncclos (ncin, iret)


      print*,'all done, bye'
      stop

 110  print*,' problem opening NetCDF file ',fname(1:len_trim(fname))
      print*,' netcdf lib says: ',nf_strerror(iret)
      stop
      end program nc_test



c   dummy routines

      subroutine barrier
      end

      subroutine halt_stop(s)
      character*(*) s
      print*,s
      stop
      end



