#include "options.inc"
c
c-----------------------------------------------------------------------
c      Templates for hardwired grid, topography, surface boundary
c      and initial concitions.
c-----------------------------------------------------------------------
c

      module topo1_module
      real :: Bv0 = 0.003, g=9.81 
      real :: tscl = 1.0/(86400.0*3.0)
      real :: fac = 10.0
      end module topo1_module

      subroutine grid_template()
c-----------------------------------------------------------------------
c     set up a grid here
c-----------------------------------------------------------------------
      use spflame_module
      implicit none
      real :: dx=0.,dy=0.,dz=0.,x0=0.,y0=0.,sumt,sumu
      integer i,k
c     equidistant vertical grid
      integer,parameter :: km_in = 10
      real ddz(km_in)
      data ddz/ 10*100.e2/
c     small eddy resolving region
      x0=280.; y0=30.; dx = 1./3.; dy = dx*cos(y0/180.*pi)

      if (my_pe==0) then
        print*,''
        print*,'setting up a simple grid '
        print*,' dx= ',dx,' dy= ',dy
        print*,''
      endif
      dxtdeg =  dx  ; dytdeg =  dy  ; dxudeg =  dx  ; dyudeg =  dy  
      xt(1)=x0; xu(1)=x0+dxtdeg(1)/2.
      do i=2,imt
        xt(i)=xt(i-1)+dxtdeg(i); xu(i)=xu(i-1)+dxudeg(i)
      enddo
      yt(1)=y0; yu(1)=y0+dytdeg(1)/2.
      do i=2,jmt
        yt(i)=yt(i-1)+dytdeg(i); yu(i)=yu(i-1)+dyudeg(i)
      enddo
      if (km /= km_in ) then
        print*,' km must be ',km_in
        stop
      endif
      dzt=ddz; dzw(1) = dzt(1); sumt = dzt(1)
      sumu = 0.5*dzt(1) + dzw(1)
      do i=2,km
       sumt = sumt + dzt(i)
       dzw(i) = 2*(sumt-sumu)
       sumu = sumu + dzw(i)
      enddo
      zt(1) = 0.5*dzt(1); zw(1) = dzt(1)
      do i=2,km
        zw(i) = zw(i-1) + dzt(i); zt(i) = zt(i-1) + dzw(i-1)
      enddo
      dzw(0)  = zt(1); dzw(km) = zw(km) - zt(km)
      end subroutine grid_template



      subroutine kmt_template
c-----------------------------------------------------------------------
c     set up a simple topography
c-----------------------------------------------------------------------
      use spflame_module
      implicit none
      integer :: i,j,indp
      real :: y,z0,h
      kmt_big=km

      z0=zw(km)
      do i=1,imt
       do j=1,jmt
          y = (jmt-j-1.)/(jmt-1.)
          h=z0-z0*0.8*y
          kmt_big(i,j) = indp (h, zw, km)
       enddo
      enddo
      end subroutine kmt_template



      subroutine htp_template
c-----------------------------------------------------------------------
c     set up a simple topography for partial cells
c-----------------------------------------------------------------------
      use spflame_module
      implicit none
      integer :: i,j,indp
      real :: y,z0
      z0=zw(km)
      do i=1,imt
       do j=1,jmt
c          y = (jmt-j-1.)/(jmt-1.)
          y = (j-1.)/(jmt-1.)
          htp(i,j)=z0-z0*0.8*y
          kmt_big(i,j) = indp (htp(i,j), zw, km)
          if (zw( kmt_big(i,j) ) < htp(i,j) )
     &       kmt_big(i,j) = kmt_big(i,j)+1
       enddo
      enddo
      end subroutine htp_template



      subroutine init_cond_template
c-----------------------------------------------------------------------
c     setup simple initial conditions
c     for temperature, salinity and velocity
c     Note that streamfunction is diagnosed from full velocities.
c-----------------------------------------------------------------------
      use spflame_module
      use freesurf_module
      use topo1_module
      implicit none
      integer :: i,j,k,n
      real :: x,y,z,h0,h_w,T0
c-----------------------------------------------------------------------
c        A mesoscale front
c-----------------------------------------------------------------------
      do j=js_pe,je_pe
       do k=1,km
        do i=is_pe,ie_pe
            t(i,k,j,2,:) = 0.   ! salinity equals 35 PSU
            x=float(i)/float(imt)
            y=float(j)/float(jmt)
            h0=zt(km)/100.
            h_w = h0/2.+tanh( (y-0.5)/0.3 )*h0/5.
            T0=20 + fac*( 1.-tanh( (zt(k)/100.-h_w)/(h0/5.)  ) )
            t(i,k,j,1,:) = T0+1/(g*alpha_lin)*zt(k)/100.*Bv0**2
     &       + 0.01*sin( x*2.0  *2*pi)
            t(i,k,j,1,:) = t(i,k,j,1,:)*tmask(i,k,j)
            x=xt(i)-xt(imt/2);y=yt(j)-yt(3*jmt/4); z=zt(k)-zt(km/2)
            h0=0e-9+exp(-x**2/0.2**2-y**2/0.2**2-z**2/100.0**2)
            t(i,k,j,2,:) = h0*tmask(i,k,j)
        enddo 
       enddo
      enddo

      if (nt>2) then
         do j=js_pe,je_pe
          do k=1,km
           do i=is_pe,ie_pe
            x=xt(i)-xt(imt/2);y=yt(j)-yt(3*jmt/4); z=zt(k)-zt(km/2)
            h0=0e-9+exp(-x**2/0.2**2-y**2/0.2**2-z**2/100.0**2)
            t(i,k,j,3,:) = h0*tmask(i,k,j)
           enddo 
          enddo
         enddo
      endif
      do n=1,nt
       call set_cyclic_4th_order(t(:,:,:,n,0),km,2)
       call set_cyclic_4th_order(t(:,:,:,n,1),km,2)
      enddo
      end subroutine init_cond_template



      subroutine sbc_template
c-----------------------------------------------------------------------
c     setup simple surface boundary conditions
c-----------------------------------------------------------------------
      use spflame_module
      implicit none
      integer :: i,j
      real :: y
c     no wind stress      
      smf=0.
c       no heat or salt fluxes
      stf_clim=0.
      stf_rest=0.
      do j=js_pe,je_pe
        do i=is_pe,ie_pe
c          y = (yt(j)-yt(1))/ (yt(jmt)*1.0-yt(1))
          y=0.0
          stf_clim(i,j,1)=t(i,1,j,1,taum1)+1
          stf_rest(i,j,1)=-500./41868.
c       no wind stirring
        enddo
      enddo
      if (enable_ktmix.or.enable_tkemix) ustar=0.     ! no wind stirring
      end subroutine sbc_template



      subroutine blue_template
c-----------------------------------------------------------------------
c     setup simple temp / salinity arrays for BLUE
c-----------------------------------------------------------------------
      use spflame_module
      use blue_module
      implicit none
      end subroutine blue_template



      subroutine sponge_template(n)
c-----------------------------------------------------------------------
c     setup simple sponge layers. 
c-----------------------------------------------------------------------
      use spflame_module
      use topo1_module
      implicit none
      integer, intent(in) :: n ! number of the tracer
      integer :: i,j,k
      real :: x,y,z,h0,h_w,T0

      if (n==1) then

       if (my_blk_j==1) then

        do j=2,4
         do k=1,km
          do i=is_pe,ie_pe
           x=float(i)/float(imt)
           h0=zt(km)/100.
           y=float(j)/float(jmt)
           h_w = h0/2.+tanh( (y-0.5)/0.3 )*h0/5.
           T0=20 + fac*( 1.-tanh( (zt(k)/100.-h_w)/(h0/5.)  ) )
           T0= T0+1/(g*alpha_lin)*zt(k)/100.*Bv0**2
           source(i,k,j)=source(i,k,j)+
     &        tscl*(T0-t(i,k,j,n,taum1))*tmask(i,k,j)
          enddo
         enddo
        enddo

       endif
       if (my_blk_j==n_pes_j) then

        do j=jmt-3,jmt-1
         do k=1,km
          do i=is_pe,ie_pe
           x=float(i)/float(imt)
           h0=zt(km)/100.
           y=float(j)/float(jmt)
           h_w = h0/2.+tanh( (y-0.5)/0.3 )*h0/5.
           T0=20 + fac*( 1.-tanh( (zt(k)/100.-h_w)/(h0/5.)  ) )
           T0= T0+1/(g*alpha_lin)*zt(k)/100.*Bv0**2
           source(i,k,j)=source(i,k,j)+
     &        tscl*(T0-t(i,k,j,n,taum1))*tmask(i,k,j)
          enddo
         enddo
        enddo

       endif
      endif
      end subroutine sponge_template
