#include "options.inc"
c
c-----------------------------------------------------------------------
c      Templates for hardwired grid, topography, surface boundary
c      and initial concitions.
c-----------------------------------------------------------------------
c

      module eddy_module
      real :: Bv0 = 0.003, g=9.81 
      end module eddy_module

      subroutine grid_template()
c-----------------------------------------------------------------------
c     set up a grid here
c-----------------------------------------------------------------------
      use spflame_module
      implicit none
      real :: dx=0.,dy=0.,dz=0.,x0=0.,y0=0.,sumt,sumu
      integer i,k
c     equidistant vertical grid
      integer,parameter :: km_in = 10
      real ddz(km_in)
      data ddz/ 10*100.e2/
c     small eddy resolving region
c      x0=280.; y0=30.; dx = 1./10.; dy = dx*cos(y0/180.*pi)
      x0=280.; y0=30.; dx = 1./4.; dy = dx*cos(y0/180.*pi)

      if (my_pe==0) then
        print*,''
        print*,'setting up a simple grid '
        print*,' dx= ',dx,' dy= ',dy
        print*,''
      endif
      dxtdeg =  dx  ; dytdeg =  dy  ; dxudeg =  dx  ; dyudeg =  dy  
      xt(1)=x0; xu(1)=x0+dxtdeg(1)/2.
      do i=2,imt
        xt(i)=xt(i-1)+dxtdeg(i); xu(i)=xu(i-1)+dxudeg(i)
      enddo
      yt(1)=y0; yu(1)=y0+dytdeg(1)/2.
      do i=2,jmt
        yt(i)=yt(i-1)+dytdeg(i); yu(i)=yu(i-1)+dyudeg(i)
      enddo
      if (km /= km_in ) then
        print*,' km must be ',km_in
        stop
      endif
      dzt=ddz; dzw(1) = dzt(1); sumt = dzt(1)
      sumu = 0.5*dzt(1) + dzw(1)
      do i=2,km
       sumt = sumt + dzt(i)
       dzw(i) = 2*(sumt-sumu)
       sumu = sumu + dzw(i)
      enddo
      zt(1) = 0.5*dzt(1); zw(1) = dzt(1)
      do i=2,km
        zw(i) = zw(i-1) + dzt(i); zt(i) = zt(i-1) + dzw(i-1)
      enddo
      dzw(0)  = zt(1); dzw(km) = zw(km) - zt(km)
      end subroutine grid_template



      subroutine kmt_template
c-----------------------------------------------------------------------
c     set up a simple topography
c-----------------------------------------------------------------------
      use spflame_module
      implicit none
      kmt_big=km
      end subroutine kmt_template



      subroutine htp_template
c-----------------------------------------------------------------------
c     set up a simple topography for partial cells
c-----------------------------------------------------------------------
      use spflame_module
      implicit none
      htp=zw(km)
      end subroutine htp_template



      subroutine init_cond_template
c-----------------------------------------------------------------------
c     setup simple initial conditions
c     for temperature, salinity and velocity
c-----------------------------------------------------------------------
      use spflame_module
      use freesurf_module
      use eddy_module
      implicit none
      integer :: i,j,k,n
      real :: x,y,z,h0
      do j=js_pe,je_pe
       do k=1,km
        do i=is_pe,ie_pe
            t(i,k,j,2,:) = 0.   ! salinity equals 35 PSU
            x=float(i)/float(imt)
            y=float(j)/float(jmt)
            t(i,k,j,1,:) = 20+1/(g*alpha_lin)*zt(k)/100.*Bv0**2
     &       + 0.01*sin( x*2.0  *2*pi)
            t(i,k,j,1,:) = t(i,k,j,1,:)*tmask(i,k,j)
            x=xt(i)-xt(imt/2);y=yt(j)-yt(3*jmt/4); z=zt(k)-zt(km/2)
            h0=0e-9+exp(-x**2/0.2**2-y**2/0.2**2-z**2/100.0**2)
            t(i,k,j,2,:) = h0*tmask(i,k,j)
        enddo 
       enddo
      enddo

      if (nt>2) then
         do j=js_pe,je_pe
          do k=1,km
           do i=is_pe,ie_pe
            x=xt(i)-xt(imt/2);y=yt(j)-yt(3*jmt/4); z=zt(k)-zt(km/2)
            h0=0e-9+exp(-x**2/0.2**2-y**2/0.2**2-z**2/100.0**2)
            t(i,k,j,3,:) = h0*tmask(i,k,j)
           enddo 
          enddo
         enddo
      endif

      do n=1,nt
       call set_cyclic_4th_order(t(:,:,:,n,tau),km,2)
       call set_cyclic_4th_order(t(:,:,:,n,taum1),km,2)
      enddo

      end subroutine init_cond_template



      subroutine sbc_template
c-----------------------------------------------------------------------
c     setup simple surface boundary conditions
c-----------------------------------------------------------------------
      use spflame_module
      implicit none
      integer :: i,j,k,is,ie,js,je
      real            :: y,x
      is=max(is_pe,2); ie=min(ie_pe,imt-1)
      js=max(2,js_pe); je=min(je_pe,jmt-1)
c     no wind stress      
      smf=0.
c   restoring to a profile
      stf_clim=0.
      stf_rest=0.
      do j=js,je
         do i=is,ie
          y = ((j-1.)/(jmt-1.)-0.5)*2/1000.*2 ! this is a density -2:2, rho/alpha=  T
          stf_clim(i,j,1)=20.+y/alpha_lin
          stf_rest(i,j,1)=1./(3.*86400.)*dzt(1)  ! 10 days
        enddo
       enddo
c       no wind stirring
      if (enable_ktmix.or.enable_tkemix) ustar=0.     ! no wind stirring
      end subroutine sbc_template



      subroutine blue_template
c-----------------------------------------------------------------------
c     setup simple temp / salinity arrays for BLUE
c-----------------------------------------------------------------------
      use spflame_module
      use blue_module
      implicit none
      end subroutine blue_template



      subroutine sponge_template(n)
c-----------------------------------------------------------------------
c     setup simple sponge layers. 
c-----------------------------------------------------------------------
      use spflame_module
      use eddy_module
      implicit none
      integer, intent(in) :: n ! number of the tracer
      end subroutine sponge_template
