#include "options.inc"
c-----------------------------------------------------------------------
c      Templates for hardwired grid, topography, surface boundary
c      and initial concitions.
c-----------------------------------------------------------------------
c

c note: each of the specific configurations which are hardcoded so far
c have been stored in the following files.

c
c-----------------------------------------------------------------------
c a midlatitude basin with a large scale baroclinic disturbance
c travelling westward.
c
c#include "setup/barbi_exp1.F"
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c a midlatitude basin with a north-south ridge in middle forced
c with a cosine-shaped wind stress
c
#include "setup/barbi_exp2.F"
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c an equatorial basin forced with zonal windstress only in
c the east, to mimic an ENSO event in the ocean.
c
c#include "setup/barbi_exp3.F"
c-----------------------------------------------------------------------

c#include "setup/barbi_exp4.F"
c
c-----------------------------------------------------------------------
c  a setup for testing inertial instability at the equator
c
c#include "setup/jets1.F"
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c  eddy resolving channel with sponge layers
c
c#include "setup/eddy1.F"
c#include "setup/eddy1b.F"
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c  eddy resolving channel with sponge layers as in Killworth, 1999
c
c#include "setup/eddy_kill.F"
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c  eddy resolving channel with surface forcing
c
c#include "setup/eddy2.F"
c-----------------------------------------------------------------------
c
c#include "setup/eddy3.F"
c#include "setup/eddy4.F"

c-----------------------------------------------------------------------
c  eddy resolving channel with sponge layers and topography
c
c#include "setup/topo1.F"
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c  non-eddy-esolving channel 
c#include "setup/coarse_channel1.F"
c#include "setup/coarse_channel2.F"
c-----------------------------------------------------------------------
c-----------------------------------------------------------------------
c  non-eddy-esolving channel with sponge layers
c
c#include "setup/eddy_coarse1.F"
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c eddy-resolving midlatitude basin with wind stress
c
c#include "setup/eddy_basin1.F"
c#include "setup/eddy_basin2.F"
c#include "setup/eddy_basin3.F"
c-----------------------------------------------------------------------

c-----------------------------------------------------------------------
c eddy-resolving equatorial basin with DWBC
c
c#include "setup/eddy_dwbc_eq1.F"
c#include "setup/eddy_dwbc_eq3.F"
c-----------------------------------------------------------------------

