#include "options.inc"
c
c-----------------------------------------------------------------------
c      Templates for hardwired grid, topography, surface boundary
c      and initial concitions.
c-----------------------------------------------------------------------
c

      subroutine grid_template()
c-----------------------------------------------------------------------
c     set up a grid here
c-----------------------------------------------------------------------
      use spflame_module
      implicit none
      real :: dx=0.,dy=0.,dz=0.,x0=0.,y0=0.,sumt,sumu,z0
      integer i,k
c     small eddy resolving region
      x0=280.; y0=14.; dx = 1./3.; dy = dx

      if (my_pe==0) then
        print*,''
        print*,'setting up a simple grid '
        print*,' dx= ',dx,' dy= ',dy
        print*,''
      endif
      dxtdeg =  dx  ; dytdeg =  dy  ; dxudeg =  dx  ; dyudeg =  dy  
      xt(1)=x0; xu(1)=x0+dxtdeg(1)/2.
      do i=2,imt
        xt(i)=xt(i-1)+dxtdeg(i); xu(i)=xu(i-1)+dxudeg(i)
      enddo
      yt(1)=y0; yu(1)=y0+dytdeg(1)/2.
      do i=2,jmt
        yt(i)=yt(i-1)+dytdeg(i); yu(i)=yu(i-1)+dyudeg(i)
      enddo

      dzt(1)=10e2
      z0=dzt(1)
      do k=2,km
        dzt(k)=dzt(k-1)*(1+exp(-z0/450e2));
        z0=z0+dzt(k)
        if (my_pe==0) print*,dzt(k),z0
      enddo
 

      dzw(1) = dzt(1); sumt = dzt(1)
      sumu = 0.5*dzt(1) + dzw(1)
      do i=2,km
       sumt = sumt + dzt(i)
       dzw(i) = 2*(sumt-sumu)
       sumu = sumu + dzw(i)
      enddo
      zt(1) = 0.5*dzt(1); zw(1) = dzt(1)
      do i=2,km
        zw(i) = zw(i-1) + dzt(i); zt(i) = zt(i-1) + dzw(i-1)
      enddo
      dzw(0)  = zt(1); dzw(km) = zw(km) - zt(km)
      end subroutine grid_template



      subroutine kmt_template
c-----------------------------------------------------------------------
c     set up a simple topography
c-----------------------------------------------------------------------
      use spflame_module
      implicit none
      kmt_big=km
      end subroutine kmt_template



      subroutine htp_template
c-----------------------------------------------------------------------
c     set up a simple topography for partial cells
c-----------------------------------------------------------------------
      use spflame_module
      implicit none
      htp=zw(km)
      end subroutine htp_template



      subroutine init_cond_template
c-----------------------------------------------------------------------
c     setup simple initial conditions
c     for temperature, salinity and velocity
c     Note that streamfunction is diagnosed from full velocities.
c-----------------------------------------------------------------------
      use spflame_module
      use freesurf_module
      implicit none
      integer :: i,j,k,n
      real :: x,y,z,h0,h_w,T0
c-----------------------------------------------------------------------
c-----------------------------------------------------------------------
      do j=js_pe,je_pe
       do k=1,km
        do i=is_pe,ie_pe
            t(i,k,j,2,:) = 0.   ! salinity equals 35 PSU
            x=float(i)/float(imt)
            y=float(j)/float(jmt)
            h0=zt(km)/100.
            t(i,k,j,1,:) = 2+15*exp( - zt(k)/1000.0e2 )
            t(i,k,j,1,:) = t(i,k,j,1,:)*tmask(i,k,j)
            t(i,k,j,2,:) = 0*tmask(i,k,j)
        enddo 
       enddo
      enddo

      do n=1,nt
       call set_cyclic_4th_order(t(:,:,:,n,0),km,2)
       call set_cyclic_4th_order(t(:,:,:,n,1),km,2)
      enddo
      end subroutine init_cond_template



      subroutine sbc_template
c-----------------------------------------------------------------------
c     setup simple surface boundary conditions
c-----------------------------------------------------------------------
      use spflame_module
      implicit none
      integer :: i,j,k,is,ie,js,je
      real            :: y,x,rand
      is=max(is_pe,2); ie=min(ie_pe,imt-1)
      js=max(2,js_pe); je=min(je_pe,jmt-1)
c     cosine shaped zonal wind stress
      do j=js,je
       do i=is,ie
          y = (yu(j)-yu(1))/ (yu(jmt)*1.0-yu(1)) ! cosine shaped wind stress
          smf(i,j,1) =1*(sin(pi*y))*umask(i,1,j) ! in taux only
          smf(i,j,2) =0.
       enddo
      enddo
c       no heat or salt fluxes
      stf_clim=0.
      stf_rest=0.



c       no wind stirring
      if (enable_ktmix.or.enable_tkemix) ustar=0.     ! no wind stirring
      end subroutine sbc_template



      subroutine blue_template
c-----------------------------------------------------------------------
c     setup simple temp / salinity arrays for BLUE
c-----------------------------------------------------------------------
      use spflame_module
      use blue_module
      implicit none
      end subroutine blue_template



      subroutine sponge_template(n)
c-----------------------------------------------------------------------
c     setup simple sponge layers. 
c-----------------------------------------------------------------------
      use spflame_module
      implicit none
      integer, intent(in) :: n ! number of the tracer
      integer :: i,j,k
      real :: x,y,z,h0,h_w,T0
      real :: tscl = 1./(86400*10)
      integer :: spg_width=3

      if (n==1) then

       if (my_blk_j==1) then
        do j=2,(spg_width+1)
         do k=1,km
          do i=is_pe,ie_pe
           x=float(i)/float(imt)
           y=float(j)/float(jmt)
            t0= 2+15*exp( - zt(k)/1000.0e2 )
           source(i,k,j)=source(i,k,j)+
     &         tscl/(j-1.)*(T0-t(i,k,j,n,taum1))*tmask(i,k,j)
          enddo
         enddo
        enddo
       endif

       if (my_blk_j==n_pes_j) then
        do j=jmt-1,jmt-spg_width,-1
         do k=1,km
          do i=is_pe,ie_pe
           x=float(i)/float(imt)
           y=float(j)/float(jmt)
           t0= 2+15*exp( - zt(k)/1000.0e2 )
           source(i,k,j)=source(i,k,j)+
     &          tscl/(-1*(j-jmt))*
     &        (T0-t(i,k,j,n,taum1))*tmask(i,k,j)
          enddo
         enddo
        enddo
       endif
      endif



      end subroutine sponge_template
