#include "options.inc"


c=======================================================================
c    simple program which sums files written by diag_variances.
c    Useful to sum monthly averages to seasonal or annual averages
c=======================================================================
c
c#define real_8
c
      module kind_mod
#ifdef real_8
      integer, parameter::  r_knd  = selected_real_kind(13)
#else
      integer, parameter::  r_knd  = selected_real_kind(6)
#endif

      end module kind_mod


      program sum_var
      use kind_mod
      implicit none
      real,parameter :: version = 0.1
      integer :: nr_com,nr_infiles
      character (len=80), allocatable :: infile(:)
      character (len=80) :: outfile,ident
      integer , allocatable :: ioin(:)
      integer :: ioout,imt,jmt,km,nt,counter,icounter,blk,m,ierr,n
      real (kind=r_knd), allocatable, dimension(:)  :: xt,yt,xu,yu,zt,zw
      logical :: enable_monthly_variances = .false.
      logical :: enable_seasonal_variances = .false.
      integer, allocatable, dimension(:,:)     :: kmt
      real (kind=r_knd), allocatable, dimension(:,:)     :: buf,buf2
      character (len=2000) :: outstr,str2

      print'(" This is sum_var.x :: version ",f5.3)',version

c  read command line input
      call get_commandline_argnr(nr_com)
      if (nr_com<3) goto 100
      nr_infiles = nr_com-1
      allocate( infile(nr_infiles) ,ioin(nr_infiles) )
      call get_commandline_arg(nr_com,outfile,ierr)
c    write some information to stdout
      outstr=' averaging variances n files :'
      do n=1,nr_infiles
       call get_commandline_arg(n,infile(n),ierr)
       outstr=outstr(1:len_trim(outstr))//
     &            infile(n)(1:len_trim(infile(n)))//','
      enddo
      outstr=outstr(1:len_trim(outstr)-1)//' and writing to file '//
     &   outfile(1:len_trim(outfile))
      print*,outstr(1:len_trim(outstr))

c   open input files 
      do n=1,nr_infiles
       call getunit(ioin(n),infile(n),'usr ieee')
      enddo
      call getunit(ioout,outfile,'usr ieee')

c   read and write
      do n=1,nr_infiles
       read(ioin(n)) imt,jmt,km,nt
      enddo
      print*,' imt=',imt,' jmt=',jmt,' km=',km,' nt=',nt
      write(ioout) imt,jmt,km,nt

      allocate( xt(imt),yt(jmt),xu(imt),yu(jmt),zt(km),zw(0:km))
      allocate( kmt(imt,jmt) )

      icounter=0
      do n=1,nr_infiles
        read(ioin(n)) xt,yt,xu,yu,zt,zw(1:km)
        read(ioin(n)) counter; icounter=icounter+counter
        print*,' counter for averages in file ',
     &           infile(n)(1:len_trim(infile(n))),' =',counter
        read(ioin(n)) enable_monthly_variances
        read(ioin(n)) enable_seasonal_variances
        read(ioin(n)) kmt
      enddo

      write(ioout) xt,yt,xu,yu,zt,zw(1:km)
      write(ioout) icounter
      write(ioout) enable_monthly_variances
      write(ioout) enable_seasonal_variances
      write(ioout) kmt

      allocate( buf(imt,jmt),buf2(imt,jmt) )

 10   read(ioin(1), end=20) blk,ident ! number of blocks and name
      do n=2,nr_infiles
        read(ioin(n)) blk,ident  ! number of blocks and name
      enddo
      print*,' found section ',ident(1:len_trim(ident))
      write(ioout) blk,ident
      do m=1,blk
        buf=0.0
        do n=1,nr_infiles
          read(ioin(n)) buf2 ; buf=buf+buf2
        enddo
        write(ioout) buf
      enddo
      goto 10
 20   continue

c   close all files 
      close (ioout)
      do n=1,nr_infiles
        close(ioin(n))
      enddo
      print*,'all done, bye'
      stop
 100  print*,' program needs command line parameter'
      print*,' input file names, output file name'
      print*,' files must be variances written by SPFLAME'
      stop
      end program sum_var



c   dummy routines

      subroutine barrier
      end

      subroutine halt_stop(s)
      character*(*) s
      print*,s
      stop
      end




