

!=======================================================================
! timing module
! stores elapsed time between calls of tic/toc subroutines
! there is the need to specify a time measurement routine below
!=======================================================================

 module timing_module
 implicit none
 integer, parameter, private :: max_counter = 1000
 integer,private             :: act_counter = 0
 character (len=80),private  :: ref_counter(max_counter)
 real,private              :: counter(0:max_counter),now(0:max_counter)

 private elapsed
 public tic,toc
 contains

 function elapsed()
 real :: elapsed
!
!  elapsed should give the elasped cpu (user) time
!  a function which gives elapsed cpu time is needed here
!
! this works for linux and many other unix machines
       real (kind=4) :: etime,tarray(2),fxa
       fxa=etime(tarray)
       elapsed = tarray(1)
! NEC
!       real*8 tarray(2),etime,sec
!       sec=etime(tarray)
!       elapsed=tarray(1)
! AIX
!       REAL (kind=4) :: etime_
!       TYPE TB_TYPE
!         SEQUENCE
!         REAL (kind=4) :: USRTIME
!         REAL (kind=4) :: SYSTIME
!       END TYPE
!       TYPE (TB_TYPE) ETIME_STRUCT
!       elapsed = etime_(ETIME_STRUCT)
!       elapsed = etime_struct%usrtime
 end function elapsed


 subroutine tic(ref)
 character (len=*), intent(in)  :: ref
 integer :: n,len
 now(0)=elapsed()
 len=len_trim(ref)
 do n=1,act_counter
    if (ref(1:len) == ref_counter(n)(1:len) ) then
         now(n) = now(0)
         counter(0) = counter(0)+elapsed()-now(0)
         return
    endif
 enddo
 if (act_counter == max_counter ) then
        print*,' ERROR:'
        print*,' number of counters exceeds max_counter = ',max_counter
        print*,' in tic'
        print*,' ref = ',ref
 endif
 act_counter = act_counter + 1
 ref_counter(act_counter) = ref
 now(act_counter) = elapsed()
 counter(0) = counter(0)+elapsed()-now(0)
 end subroutine tic

 subroutine toc(ref)
 character (len=*), intent(in) :: ref
 integer :: n,len

 now(0)=elapsed()
 len=len_trim(ref)
 do n=1,act_counter
        if (ref(1:len) == ref_counter(n)(1:len) ) then
         counter(n) = counter(n)+now(0)-now(n)
         counter(0) = counter(0)+elapsed()-now(0)
         return
        endif
 enddo
 print*,' ERROR:'
 print*,' cannot find ',ref(1:len),' in my list'
 print*,' in toc'
 end subroutine toc

 function timing_secs(ref)
 character (len=*), intent(in) :: ref
 real :: timing_secs
 integer :: n,len
 if (ref=='tictoc') then
       timing_secs = counter(0)
       return
  endif
  len=len_trim(ref)
  do n=1,act_counter
        if (ref(1:len) == ref_counter(n)(1:len) ) then
         timing_secs = counter(n)
         return
        endif
  enddo
  print*,' ERROR:'
  print*,' cannot find ',ref(1:len),' in my list'
  print*,' in timing_secs'
  end function timing_secs

  end module timing_module
 
