

!=======================================================================
! Setup as in Nurser and Lee (2004) "Isopycnal Averaging at Constant 
! Height. Part I: The Formulation and a Case Study" JPO (34)
!=======================================================================


module config_module
 ! use this module only locally in this file
 implicit none
 real*8,parameter :: hRESOLVE = 1.0  ! 2 in original model 
 real*8,parameter :: vRESOLVE = 1.0  ! 2 in original model
 real*8,parameter :: rho_0 =1024.0, g=9.81
 real*8,parameter :: pi      = 3.14159265358979323846264338327950588
 real*8,parameter :: omega   = pi/43082.0 ! earth rotation freq. in 1/s
 real*8,parameter :: radius  = 6370.0e3,degtom = radius/180.0*pi
 real*8 :: M_0, N_0
end module config_module


subroutine set_parameter
 use pyOM_module
 use fcontrol_module
 use config_module
 implicit none
 real :: f_0,Ro,delta,s,fxa
 nx   = 31*hRESOLVE 
 ny   = 51*hRESOLVE
 nz   = 26*vRESOLVE

 dx    = 20.0e3/hRESOLVE
 dz    = 40.000/vRESOLVE
 dt    = 1200.0/hRESOLVE

 K_h=0000.0/hRESOLVE**2
 K_v=1.0e-4/vRESOLVE
 A_h=0.0e+4/hRESOLVE**2
 A_v=10.e-4/vRESOLVE

 Ahbi  = 1.25e11 /(hRESOLVE/2)**4  ! U/T = A U/L^4 
 Khbi  = Ahbi
 cdbot = 1e-5*vRESOLVE

 eps2D_sor = 1e-7
 runlen   = 365.0*86400.0
 snapint  = 3.0*86400.0

 enable_noslip               = .true.
 enable_cyclic_x             = .true.
 enable_bottom_stress        = .true.
 enable_biharmonic_friction  = .true.
 enable_hydrostatic          = .true.
 enable_quicker_advection    = .true.

 N_0     = ((0.01915234375+0.047880859375)/2-0) /((nz-2)*dz) 
 M_0     = (0.047880859375/2-0.01915234375/2)   /((ny-2)*dx)

end subroutine set_parameter

subroutine set_coriolis
 use pyOM_module   
 use config_module
 implicit none
 integer :: j
 real*8 :: phi0 
 phi0 = -49.3126877545132  /180. *pi
 do j=1,ny
      coriolis_t(j) = 2*omega*sin(phi0) + 2*omega*cos(phi0)/radius*yt(j)
 enddo
end subroutine set_coriolis

subroutine initial_conditions
 use pyOM_module
 use fcontrol_module
 use config_module
 implicit none
 integer :: i,j,k
 real :: B0,x,y,bS,bN,BSz,BNz
 bS=-0.01915234375
 bN=-0.047880859375
 do k=1,nz
      BSz=bS*(zt(k)-zt(1))/(zt(nz)-zt(1))
      BNz=bN*(zt(k)-zt(1))/(zt(nz)-zt(1))
      do j=1,ny
        B0=(BSz*(yt(ny-1)-yt(j))+BNz*(yt(j)-yt(2)))/ (yt(ny-1)-yt(2))
        do i=1,nx
          x=float(i)/float(nx)
          y = (yt(j)-yt(2))/ (yt(ny-1)-yt(2))
          b(i,j,k,:) = (B0+0.5e-3*sin(x*8.5*pi)*exp(-(y-0.5)**2/0.5**2))*maskT(i,j,k)
      enddo
    enddo
 enddo
end subroutine initial_conditions

subroutine restoring_zones
 use pyOM_module
 use fcontrol_module
 use config_module
 implicit none
 integer :: i,j,k,js,je,spg_width
 real :: t_rest,B0,bS,bN
 spg_width = 5*hRESOLVE
 t_rest=1./(2.*86400)
 bS=-0.01915234375
 bN=-0.047880859375

 js=max(2,js_pe); je = min(je_pe,ny-1)
 if (my_blk_j==1) then
  do k=1,nz
    B0=bS*(zt(k)-((zt(2)+zt(1))/2))/(zt(nz)-((zt(2)+zt(1))/2))
    do j=2,spg_width+1
     b(:,j,k,taup1)=b(:,j,k,taup1)+maskT(:,j,k)*c2dt*t_rest*(1.*(spg_width+1-1.*j))/(spg_width+1-2)  &
                    *(B0-b(:,j,k,taum1))
    enddo
  enddo
 endif
 if (my_blk_j==n_pes_j) then
  do k=1,nz
   B0=bN*(zt(k)-((zt(2)+zt(1))/2))/(zt(nz)-((zt(2)+zt(1))/2))
   do j=ny-1,ny-spg_width,-1
    b(:,j,k,taup1)=b(:,j,k,taup1)+maskT(:,j,k)*c2dt*t_rest*(1.*(ny-spg_width-1.*j))/(ny-spg_width-ny+1)  &
                     *(B0-b(:,j,k,taum1))
   enddo
  enddo
 endif
end subroutine restoring_zones

subroutine boundary_conditions
 use pyOM_module
 use fcontrol_module
 use config_module
 implicit none
 integer :: i,j,spg_width
 real :: t_rest,bstar,bS,bN,L_y,y,db
 spg_width = 5*hRESOLVE
 t_rest=7*86400
 bS=-0.01915234375
 bN=-0.047880859375

 do j=1,spg_width
        surface_flux(:,j)=0.0
 enddo
 do j=spg_width+1,ny-spg_width
      bstar=(bS*(ny-1-j)+bN*(j-2))/(ny-1-2)
      do i=1,nx
        surface_flux(i,j)=dz/t_rest*(bstar-b(i,j,nz-1,tau))
      enddo
 enddo
 do j=ny-spg_width+1,ny
        surface_flux(:,j)=0.0
 enddo
end subroutine boundary_conditions

subroutine topography
end subroutine topography

subroutine momentum_restoring_zones
end subroutine momentum_restoring_zones

subroutine tracer_sources
end subroutine tracer_sources



