
!=======================================================================
!     Templates for setup
!=======================================================================

  subroutine set_parameter
      use pyOM_module   
      use fcontrol_module
      implicit none
      real*8 :: fac=0.5
! ----------------------------------
!       set here main parameter
! ----------------------------------
      nx=3*64*fac;nz=40*fac
      ny=3
      dx=0.25/fac 
      dz=0.25/fac 
      dt=0.025/fac
      eps2d_sor = 1e-6
      eps3d_sor = 1e-6
      enable_cyclic_x            =.true.
      enable_cyclic_y            =.true.
      enable_hydrostatic         =.false.

!      enable_quicker_advection       =.true.
!      enable_quicker_mom_advection   =.true.

      enable_biharmonic_friction =.true.
      enable_vert_biha_friction  =.true.
      enable_biharmonic_diffusion=.true.
      enable_vert_biha_diffusion =.true.
      Ahbi = (5e-3/fac**2)*dx**2
      Khbi = Ahbi
      Avbi = (5e-3/fac**2)*dx**2
      Kvbi = Avbi

!      A_h = 20e-3/fac**2
!      K_h = A_h
!      A_v = A_h
!      K_v = A_h

      runlen=360.; snapint=0.25
  end subroutine set_parameter


 subroutine set_coriolis
 end subroutine set_coriolis


 subroutine initial_conditions
      use pyOM_module   
      implicit none
      integer :: i,j,k
      real*8 :: fxa,pi=3.1415
      do k=1,nz
       do j=1,ny
        do i=1,nx
         fxa=1e-3*zt(1)*sin(xt(i)/(20*dx)*pi)
         b(i,j,k,:)=1e-2*tanh( (fxa+zt(k)-zt(nz/2) ) /zt(1)*100 )
         b(i,j,k,:)=b(i,j,k,:)*maskT(i,j,k)
         u(i,j,k,:)= 2+tanh( (zt(k)-zt(nz/2))/zt(1)*100)
        enddo
       enddo
      enddo
 end subroutine initial_conditions



 subroutine restoring_zones
      use pyOM_module   
      implicit none
      integer :: i,j,k,js,je
      real*8 :: T_rest,B0
! ----------------------------------
!      add here restoring zones
! ----------------------------------
      js=max(2,js_pe); je = min(je_pe,ny -1)
      T_rest=1./(15.*dt)
      do k=1,nz
       do i=2,nx/8
        do j=js,je
         b0=1e-2*tanh( (zt(k)-zt(nz/2) ) /zt(1)*100 )
         b(i,j,k,taup1)=b(i,j,k,taup1)+maskT(i,j,k)*c2dt*  t_rest*(B0-b(i,j,k,taum1))
        enddo
       enddo
      enddo
 end subroutine restoring_zones


 subroutine momentum_restoring_zones
      use pyOM_module   
      implicit none
      integer :: i,j,k,js,je
      real*8 :: T_rest,B0
! ----------------------------------
!      add here restoring zones for momentum
! ----------------------------------

      js=max(2,js_pe); je = min(je_pe,ny-1)
      T_rest=1./(15.*dt)
      do k=1,nz
       do i=2,nx/8
        do j=js,je
         B0=2+tanh( (zt(k)-zt(nz/2))/zt(1)*100)
         fu(i,j,k)= fu(i,j,k)+maskU(i,j,k)* T_rest*(B0-u(i,j,k,taum1))
        enddo
       enddo
      enddo
end subroutine momentum_restoring_zones


subroutine boundary_conditions
end subroutine boundary_conditions

subroutine topography
end subroutine topography

subroutine tracer_sources
end subroutine tracer_sources

