
!=======================================================================
!     Templates for setup
!
!    internal wave beams
!=======================================================================

subroutine set_parameter
      use pyOM_module
      use fcontrol_module
      implicit none
      real :: fac=1.0
! ----------------------------------
!       set here main parameter
! ----------------------------------

      nx=64*fac;nz=60*fac;ny=3
      dx=0.25/fac
      dz=0.25/fac
      dt=0.025/fac

      eps2d_sor = 1e-7
      eps3d_sor = 1e-7
      enable_cyclic_x            =.true.
      enable_cyclic_y            =.true.
      enable_quicker_advection   =.true.
      enable_hydrostatic         =.false.
      enable_biharmonic_friction =.true.
      enable_vert_biha_friction  =.true.
      enable_biharmonic_diffusion=.true.
      enable_vert_biha_diffusion =.true.
      Ahbi = (5e-3/fac**2)*dx**2
      Khbi = Ahbi
      Avbi = (5e-3/fac**2)*dx**2
      Kvbi = Avbi
      A_h = 00e-3/fac**2
      A_v = A_h
      K_h = 0
      K_v = 0

      enable_back_state  =.true.
      runlen=150. !/ fac**2
      snapint = dt*10
 end subroutine set_parameter


subroutine set_coriolis
end subroutine set_coriolis


subroutine initial_conditions
      use pyOM_module
      implicit none
      integer :: i,j,k
      real*8 :: N_0=2*3.1415/10.0
! ----------------------------------
!      add here initial conditions
! ----------------------------------
      do k=1,nz
       do j=1,ny
        do i=1,nx
         back(i,j,k,:) = -N_0**2*zt(k)*maskT(i,j,k)
        enddo
       enddo
      enddo
end subroutine initial_conditions


subroutine momentum_restoring_zones
   use pyOM_module
   use fcontrol_module
   implicit none
   integer :: i,j,k,js,je
   real*8 :: B0,om0 = 1./(1.5*10),time, pi=3.1415
! ----------------------------------
!      add here restoring zones for momentum
! ----------------------------------
      js=max(2,js_pe); je = min(je_pe,ny-1)
      time = itt*dt
      B0 =  1./(100*60.*dt)*sin( 2*pi*om0*time )
      do k=nz/2,nz/2+0
       do i=nx/2,nx/2+0
        do j=js,je
         fu(i,j,k)= fu(i,j,k)+maskU(i,j,k)*B0
        enddo
       enddo
      enddo
 end subroutine momentum_restoring_zones

subroutine restoring_zones
end subroutine restoring_zones

subroutine boundary_conditions
end subroutine boundary_conditions

subroutine topography
end subroutine topography

subroutine tracer_sources
end subroutine tracer_sources


