
!=======================================================================
!     Templates for setup
!     Exp. Disturb in Olbers and Eden, JPO, 2003
!     Long Rossby wave propagation
!=======================================================================

subroutine set_parameter
 ! ----------------------------------
 !       set here main parameter
 ! ----------------------------------
 use pyOM_module
 use fcontrol_module
 implicit none
 nx=20;nz=12;ny=20
 dx=2.0*60*1852.0
 dz=500.0
 dt=3600.0*2
 K_h=00.0
 K_v=1.e-4
 A_h=2e3
 A_v=1.e-3
 eps2D_sor = 1e-12
 enable_noslip               = .true.
 enable_hydrostatic          = .true.
 enable_quicker_advection    = .true.
 enable_quicker_mom_advection= .true.
 enable_back_state           = .true.
 runlen=10*365.0*86400.
 snapint = 5.0*86400.
end subroutine set_parameter


subroutine set_coriolis
   use pyOM_module   
   implicit none
   integer :: j
   real*8,parameter :: pi=3.1415   
   real*8,parameter :: radius  = 6370.0e3   ! earth radius
   real*8,parameter :: omega   = pi/43082.0 ! earth rotation freq. in 1/s
   real*8,parameter :: phi0 = 30.0 /180. *pi
   do j=1,ny
    coriolis_t(j) = 2*omega*sin(phi0) + 2*omega*cos(phi0)/radius*yt(j)
   enddo
end subroutine set_coriolis

subroutine initial_conditions
 use pyOM_module
 implicit none
 integer :: i,j,k
 real*8 :: x,y,B0,N_0
 ! ----------------------------------
 !      add here initial conditions
 ! ----------------------------------
  N_0     = 2.6e-3
  do k=1,nz
    do j=1,ny
       do i=1,nx
         back(i,j,k,:) = -N_0**2*zt(k)*maskT(i,j,k)
         x=(float(i)/float(nx)-0.5)*2.
         y=(float(j)/float(ny)-0.5)*2.
         B0 = 1e-5*exp(-(x-0.6)**2*10.)*exp(-(y)**2*10.) *exp(-(zt(nz)-zt(k))/500. )
         b(i,j,k,:) = B0*maskT(i,j,k)
       enddo
   enddo
 enddo
end subroutine initial_conditions

subroutine restoring_zones
end subroutine restoring_zones

subroutine momentum_restoring_zones
end subroutine momentum_restoring_zones

subroutine boundary_conditions
end subroutine boundary_conditions

subroutine topography
end subroutine topography

subroutine tracer_sources
end subroutine tracer_sources


