
!=======================================================================
!  idealised Southern Ocean, same as in Viebahn and Eden (2010) Ocean modeling
!======================================================================= 


module config_module
 ! use this module only locally in this file
 implicit none
 real*8,parameter :: hRESOLVE = 0.5   ! 1 in original model
 real*8,parameter :: vRESOLVE = 1.0   ! 1 in original model
 real*8,parameter :: N_0     = 0.004
 real*8,parameter :: pi      = 3.14159265358979323846264338327950588
 real*8,parameter :: omega   = pi/43082.0 ! earth rotation freq. in 1/s
 real*8,parameter :: radius  = 6370.0e3
end module config_module


subroutine set_parameter
 ! ----------------------------------
 !       set here main parameter
 ! ----------------------------------
 use pyOM_module   
 use fcontrol_module
 use config_module
 implicit none
      nx   = 128*hRESOLVE 
      nz   = 20 *vRESOLVE;
      ny   = 128*hRESOLVE
      dx    = 20e3/hRESOLVE
      dz    = 50.0 /vRESOLVE
      dt    = 1200.0/hRESOLVE

      K_h=0000.0 /hRESOLVE
      A_h=0000.0 /hRESOLVE
!      A_h=10000.0!/hRESOLVE  ! for coarse model version
      Ahbi  = 5e11/hRESOLVE**2
      Khbi  = Ahbi

      K_v=1.0e-4/vRESOLVE
      A_v=10.e-4/vRESOLVE
      cdbot = 1e-5*vRESOLVE

      eps2D_sor = 1e-9

      enable_noslip               = .true.
      enable_cyclic_x             = .true.
      enable_bottom_stress        = .true.
      !enable_biharmonic_friction  = .true.  ! was on in original model
      enable_hydrostatic          = .true.
      enable_quicker_advection    = .true.  
      enable_pv_mixing            = .true.   ! was off in original model

      !enable_vert_friction_trm = .true. ! for coarse model version
      !enable_bolus_velocity    = .true. ! for coarse model version
      !enable_pv_mixing         = .true. ! for coarse model version
      !K_gm=2000.0 ! for coarse model version
      !enable_diag_zonalave = .true.
      !enable_diag_timeave  = .true.
      runlen = 365*86400.*20   ! was  one year in original model
      snapint =  3.*86400.     ! was 3 days in original model
end subroutine set_parameter


subroutine set_coriolis
 ! ----------------------------------
 !      add here initial conditions
 ! ----------------------------------
 use pyOM_module   
 use config_module   
 implicit none
 integer :: j
 real*8:: phi0 
 phi0 = -25.0 /180. *pi
 do j=1,ny
      coriolis_t(j) = 2*omega*sin(phi0) + 2*omega*cos(phi0)/radius*yt(j)
 enddo
end subroutine set_coriolis


subroutine initial_conditions
 ! ----------------------------------
 !      add here initial conditions
 ! ----------------------------------
 use pyOM_module   
 use config_module   
 implicit none
 integer :: i,j,k
 real*8 :: bstar,B0,x,y
 do j=1,ny
   call b_surface(bstar,j)
   do k=1,nz
     do i=1,nx
         x=float(i)/float(nx)
         y = (yt(j)-yt(2))/ (yt(ny-1)-yt(2))
         B0=0.0e-3*sin(x*8.5*pi)*exp(-(y-0.5)**2/0.5**2)
         b(i,j,k,:)  = (-30e-3+B0-N_0**2*zt(k))*maskT(i,j,k)
     enddo
   enddo
 enddo
end subroutine initial_conditions


subroutine b_surface(bstar,j)
 use pyOM_module   
 use config_module   
 implicit none
 integer :: j
 real*8 :: db,bstar,y2,L_y
 L_y = yt(ny )-yt(1)
 db = -30e-3
 bstar=db
 if (yt(j)<L_y/2.0) then
       bstar=db*yt(j)/(L_y/2.0)
 endif
 y2=L_y*0.75
 if (yt(j)>y2) then
       bstar=db*(1-(yt(j)-y2)/(yt(ny )-y2) )
 endif
end subroutine b_surface


subroutine boundary_conditions
 ! ----------------------------------
 !    add here boundary conditions
 ! ----------------------------------
 use pyOM_module   
 use config_module   
 implicit none
 integer :: i,j
 real*8 :: L_y,y,t_rest,bstar
 L_y = yt(ny )-yt(1)
 t_rest=30*86400
 do j=1,ny 
   call b_surface(bstar,j)
   do i=1,nx 
     if (yt(j)<L_y/2.0) then
         y = yu(j)/L_y
         surface_taux(i,j) = .1e-3*sin(2*pi*y)*maskU(i,j,nz-1)
     endif
     surface_flux(i,j)=dz/t_rest*(bstar-b(i,j,nz-1,tau)) 
   enddo
 enddo
end subroutine boundary_conditions

subroutine topography
 ! ----------------------------------
 !      Add here topography  
 ! ----------------------------------
 use pyOM_module   
 implicit none
 integer :: i,j
 real*8 :: L_x,L_y
 L_x = xt(nx )-xt(1)
 L_y = yt(ny )-yt(1)
 do i=1,nx 
   do j=1,ny 
        if ((yt(j)>L_y/2.0).and. (xt(i)>L_x*.75.or.xt(i)<L_x*.25))  maskT(i,j,:)=0.0
   enddo
 enddo
end subroutine topography

subroutine restoring_zones
end subroutine restoring_zones

subroutine momentum_restoring_zones
end subroutine momentum_restoring_zones

subroutine tracer_sources
end subroutine tracer_sources


