#!/usr/bin/env python

from numpy.distutils.core import Extension

src= ['../for_src/pyOM_module.f90',
      '../for_src/advection.f90',
      '../for_src/biharmonic.f90',
      '../for_src/buoyancy.f90',
      '../for_src/congrad2D.f90',
      '../for_src/congrad3D.f90',
      '../for_src/convection.f90',
      '../for_src/integrate.f90',
      '../for_src/mom_adv.f90',
      '../for_src/momentum.f90',
      '../for_src/pressure.f90',
      '../for_src/tracer.f90',
      '../for_src/background_state.f90',
      '../for_src/vert_friction.f90']


pyOM_MPI= Extension(name = 'pyOM_code_MPI',
                    sources = src + ['../for_src/boundary_MPI.f90'] ,
                    libraries = ['mpi','mpi_f77',],
                    include_dirs=['/usr/include/mpi'],
                    # for MAC osx
                    #include_dirs=['/usr/local/include'],
                    #library_dirs=['/usr/local/lib'],
                    runtime_library_dirs = [],
                    )

pyOM    = Extension(name = 'pyOM_code',
                    sources = src + ['../for_src/boundary.f90'] ,
                    libraries = [],
                    include_dirs=[],
                    library_dirs=[])


# on linux with gfortran and bounds check
#python setup.py config_fc --f77flags='-fbounds-check' --f90flags='-fbounds-check' install --install-lib=.


if __name__ == "__main__":
    from numpy.distutils.core import setup

    setup(name = 'pyOM', 
          description       = "pyOM",
          version           = '1.0',
          author            = "Carsten Eden",
          author_email      = "carsten.eden@zmaw.de",
          ext_modules = [pyOM,pyOM_MPI],
          )
