
!=======================================================================
!  closed eddying domain with restoring zones at side walls
!  Experiment BASIN in Eden (2010), Ocean modeling 32 (2010) 58–71
!=======================================================================

module config_module
 ! use this module only locally in this file
 implicit none
 real*8,parameter :: hRESOLVE = 0.5   ! 2 in original model
 real*8,parameter :: vRESOLVE = 1.0   ! 2 in original model
 real*8,parameter :: rho_0 =1024.0, g=9.81
 real*8,parameter :: M_0     = sqrt(0.5*1e-5*0.1/rho_0*g)
 real*8,parameter :: N_0     = 0.004
 real*8,parameter :: pi      = 3.14159265358979323846264338327950588
 real*8,parameter :: omega   = pi/43082.0 ! earth rotation freq. in 1/s
 real*8,parameter :: radius  = 6370.0e3,degtom = radius/180.0*pi
end module config_module

subroutine set_parameter
 ! ----------------------------------
 !       set here main parameter
 ! ----------------------------------
 use pyOM_module
 use fcontrol_module
 use config_module
 implicit none
 nx = 128*hRESOLVE 
 nz = 20 *vRESOLVE;
 ny = 128*hRESOLVE
 dx = 1./3.*degtom*cos(30./180.*pi)/hRESOLVE
 dz = 100.0 /vRESOLVE
 dt = 1200.0/hRESOLVE
 K_h=000.0 /hRESOLVE
 K_v=1.0e-4/vRESOLVE
 A_h=0000.0/hRESOLVE
 A_v=10.e-4/vRESOLVE
!      enable_biharmonic_friction    = .true. ! enabled in original model
 Ahbi  = 1.25e11!/RESOLVE**4
 Khbi  = Ahbi
 enable_bottom_stress     = .true.
 enable_bottom_noslip     = .true.
 cdbot = 2e-4/dz
 enable_free_surface      = .true.
 eps2D_sor = 1e-9
 enable_noslip            = .true.
 enable_hydrostatic       = .true.
 enable_quicker_advection = .true.
 enable_4th_mom_advection = .true.
 enable_pv_mixing         = .true.  ! this was off in original model
 runlen   = 36.5*5 *86400.0 ! 365.0/RESOLVE**3
 snapint  = 5.0 *86400.0 
end subroutine set_parameter

subroutine set_coriolis
 use pyOM_module   
 use config_module
 implicit none
 integer :: j
 real*8 :: phi0 
 phi0 = 30.0 /180. *pi
 do j=1,ny
      coriolis_t(j) = 2*omega*sin(phi0) + 2*omega*cos(phi0)/radius*yt(j)
 enddo
end subroutine set_coriolis

subroutine initial_conditions
 ! ----------------------------------
 !      add here initial conditions
 ! ----------------------------------
 use pyOM_module
 use config_module
 implicit none
 integer :: i,j,k
 real*8 :: B0,x,y
 do k=1,nz
   do j=1,ny
      do i=1,nx
         x=float(i)/float(nx)
         y = (yt(j)-yt(2))/ (yt(ny-1)-yt(2))
         B0=(M_0)**2*yt(j) !    +0.5e-3*sin(x*8.5*pi)*exp(-(y-0.5)**2/0.5**2)
         b(i,j,k,:)  = (B0-N_0**2*zt(k))*maskT(i,j,k)
      enddo
    enddo
 enddo
end subroutine initial_conditions

subroutine restoring_zones
 use pyOM_module
 use config_module
 implicit none
 integer :: i,j,k,js,je, spg_width 
 real :: T_rest=1./(5.*86400),B0,qq,MM
 ! ----------------------------------
 !      add here restoring zones
 ! ----------------------------------
 js=max(2,js_pe); je = min(je_pe,ny-1)
 spg_width = 3*hRESOLVE
 if (my_blk_j==1) then
   do k=1,nz
      do j=2,spg_width+1
         B0= yt(j)*M_0**2-N_0**2*zt(k)
         b(:,j,k,taup1)=b(:,j,k,taup1)+maskT(:,j,k)*c2dt*t_rest/(j-1.)*(B0-b(:,j,k,taum1))
      enddo
   enddo
 endif
 if (my_blk_j==n_pes_j) then
   do k=1,nz
      do j=ny-1,ny-spg_width,-1
         B0= yt(j)*M_0**2-N_0**2*zt(k)
         b(:,j,k,taup1)=b(:,j,k,taup1)+maskT(:,j,k)*c2dt*t_rest/(-1.*(j-ny))*(B0-b(:,j,k,taum1))
      enddo
   enddo
 endif
end subroutine restoring_zones

subroutine topography
 use pyOM_module
 use config_module
 implicit none
 real*8 :: h,h0,L_x,h_t,L_y
 integer :: i,j,k

 h0=(nz-2)*dz
 h_t=h0/10.
 L_y= 1000e3
 L_x= 1000e3
 do k=1,nz
    do j=1,ny
      do i=1,nx
         h=h0-h_t*cos(yt(j)/L_y*2*pi)
         if (zt(k).lt.-h) maskT(i,j,k)=0.0
      enddo
    enddo
 enddo
 maskT(1,:,:)=0.0
 maskT(nx,:,:)=0.0
 maskT(:,1,:)=0.0
 maskT(:,ny,:)=0.0
end subroutine topography

subroutine boundary_conditions
end subroutine boundary_conditions

subroutine momentum_restoring_zones
end subroutine momentum_restoring_zones

subroutine tracer_sources
end subroutine tracer_sources



