
!=======================================================================
!     Templates for setup
!
!      Eady problem
!=======================================================================

subroutine set_parameter
 use pyOM_module   
 use fcontrol_module
 implicit none
 real*8 :: fac=1.0
 ! ----------------------------------
 !       set here main parameter
 ! ----------------------------------
 nx  = 32*fac; nz  = 20 *fac; ny  = 30*fac
 dx  = 20e3/fac
 dz  = 100.0 /fac
 dt  = 1200.0 /fac
 A_v = 10.e-4 
 K_v = 1.0e-4 
 eps2D_sor = 1e-9
 enable_hydrostatic          = .true.
 enable_cyclic_x             = .true.
 enable_quicker_advection    = .true.
 enable_quicker_mom_advection= .true.
 enable_biharmonic_friction  = .false.
 enable_biharmonic_diffusion = .false.
 Ahbi  = 5e11/fac**2
 Khbi  = Ahbi
 enable_back_state           = .true.
 enable_back_zonal_flow      = .true.
 runlen = 365*86400.
 snapint =  1.0*86400.0
end subroutine set_parameter


subroutine set_coriolis
 use pyOM_module   
 implicit none
 ! ----------------------------------
 !      add here initial conditions
 ! ----------------------------------
 coriolis_t(:) = 1e-4
end subroutine set_coriolis


subroutine initial_conditions
 use pyOM_module   
 implicit none
 integer :: i,j,k
 real*8 :: fxa,kx,ky,L_r,U_0,N_0, d ,h,f
 complex :: c1,A
 real*8,parameter :: pi=3.1415   
 
 U_0 = 0.5
 N_0 = 0.004
 
 f=coriolis_t(ny/2)
 L_r = N_0*(nz-2)*dz/(coriolis_t(ny /2)*pi)
 kx=1./L_r
 kx=1.6*coriolis_t(ny /2)/N_0/((nz-2)*dz)
 ky=pi/((ny-2)*dx)

 h = (nz-2)*dz
 d=f/N_0/(kx**2+ky**2)**0.5

 fxa=(exp(h/d)+exp(-h/d))/(exp(h/d)-exp(-h/d))
 c1= (1+0.25*(h/d)**2-h/d*fxa )
 c1=(sqrt(c1)*d/h+0.5)*U_0
 A=(U_0-c1)/U_0*h/d

 do k=1,nz
   do j=1,ny 
      do i=1,nx 
         fxa=1e-2*sin(kx*xt(i))*sin(ky*yt(j))
         fxa=fxa* abs( A/d*sinh(zt(k)/d)+cosh(zt(k)/d)/d )
         b(i,j,k,:)=b(i,j,k,:)+fxa*maskT(i,j,k)
      enddo
   enddo
 enddo

 do k=1,nz
     u0(:,:,k)=(U_0/2+U_0*zt(k)/(nz*dz))*maskU(:,:,k)
 enddo
 back=0.
 do k=1,nz
   do j=1,ny -1
      back(:,j+1,k,1)=back(:,j,k,1)+dx*maskT(:,j,k)*U_0/(nz*dz) *(coriolis_t(j)+coriolis_t(j+1))/2.0
   enddo
 enddo
 do k=1,nz
    back(:,:,k,1)=(back(:,:,k,1)-N_0**2*zt(k))*maskT(:,:,k)
 enddo
 back(:,:,:,2)=back(:,:,:,1)
 back(:,:,:,3)=back(:,:,:,1)
end subroutine initial_conditions


subroutine restoring_zones
end subroutine restoring_zones

subroutine momentum_restoring_zones
end subroutine momentum_restoring_zones

subroutine boundary_conditions
end subroutine boundary_conditions

subroutine topography
end subroutine topography

subroutine tracer_sources
end subroutine tracer_sources


