
!=======================================================================
!  idealised Southern Ocean, channel with prescribed stratification
!======================================================================= 


module config_module
 ! use this module only locally in this file
 implicit none
 real*8,parameter :: hRESOLVE = 2.0   ! 1 in original model
 real*8,parameter :: vRESOLVE = 2.0   ! 1 in original model
 real*8,parameter :: pi      = 3.14159265358979323846264338327950588
 real*8,parameter :: omega   = pi/43082.0 ! earth rotation freq. in 1/s
 real*8,parameter :: radius  = 6370.0e3

 real*8 :: N_0     = 0.002
 real*8 :: tau0 = 0.02,  K0gm = 2000.0, h0 = 0.25
end module config_module


subroutine set_parameter
 ! ----------------------------------
 !       set here main parameter
 ! ----------------------------------
 use pyOM_module   
 use fcontrol_module
 use config_module
 implicit none
 namelist /acc_wind/ N_0,tau0,K0gm,h0

      open(10,file='namelist',form='formatted',status='old')
      read(10, nml = acc_wind )
      close(10)
      if (my_pe==0) write(6, nml=acc_wind)
  
      nx   = 31*hRESOLVE
      nz   = 40*vRESOLVE
      ny   = 16*hRESOLVE
      dx    = 80e3/hRESOLVE
      dz    = 100.0/vRESOLVE
      dt    = 12e3/hRESOLVE

      K_h=0000.0 
      A_h=2000.0/hRESOLVE

      K_v=10e-4/vRESOLVE
      A_v=10e-4/vRESOLVE

      eps2D_sor = 1e-9

      !enable_noslip               = .true.
      enable_bottom_noslip        = .true.
      enable_cyclic_x             = .true.
      enable_hydrostatic          = .true.
      enable_quicker_advection    = .true.  

      enable_bolus_velocity  = .true. 
      K_gm=K0gm
      runlen = 365*86400.*20   
      snapint =  365./12.*86400.     

      enable_back_state = .true.
      enable_diag_barbi = .true.

end subroutine set_parameter


subroutine set_coriolis
 use pyOM_module   
 use config_module   
 implicit none
 integer :: j
 real*8:: phi0 
 phi0 = 50.0 /180. *pi
 do j=1,ny
      coriolis_t(j) = 2*omega*sin(phi0) + 2*omega*cos(phi0)/radius*yt(j)
 enddo
end subroutine set_coriolis


subroutine initial_conditions
 ! ----------------------------------
 !      add here initial conditions
 ! ----------------------------------
 use pyOM_module   
 use config_module   
 implicit none
 integer :: i,j,k
 back=0.
 do k=1,nz
    back(:,:,k,1)=(back(:,:,k,1)-N_0**2*zt(k))*maskT(:,:,k)
 enddo
 back(:,:,:,2)=back(:,:,:,1)
 back(:,:,:,3)=back(:,:,:,1)
end subroutine initial_conditions



subroutine boundary_conditions
 ! ----------------------------------
 !    add here boundary conditions
 ! ----------------------------------
 use pyOM_module   
 use config_module   
 implicit none
 integer :: i,j
 real*8 :: L_y,y,t_rest,bstar
 L_y = yt(ny )-yt(1)
 do j=1,ny 
   do i=1,nx 
    y = yu(j)/L_y
    surface_taux(i,j) = tau0*1e-3*sin(pi*y)*maskU(i,j,nz-1)
   enddo
 enddo
end subroutine boundary_conditions

subroutine topography
 ! ----------------------------------
 !      Add here topography  
 ! ----------------------------------
 use pyOM_module   
 use config_module   
 implicit none
 integer :: i,j,k
 real*8 :: L_x
 L_x = xt(nx-1 )-xt(2)
 do j=1,ny 
   do i=1,nx 
     k=  nint(nz*h0*(1 + sin(4*pi*xt(i)/L_x))/2.0 )+1
     k=min(nz,max(1,k))
     maskT(i,j,1:k) = 0.0
   enddo
 enddo
end subroutine topography

subroutine restoring_zones
end subroutine restoring_zones

subroutine momentum_restoring_zones
end subroutine momentum_restoring_zones

subroutine tracer_sources
end subroutine tracer_sources


