

!=======================================================================
!     Templates for setup
!
!      idealised MOC with freshwater forcing
!=======================================================================


 subroutine set_parameter
      use pyOM_module   
      use fcontrol_module
      implicit none
      real*8 :: RESOLVE=0.25, vRESOLVE=0.5
! ----------------------------------
!       set here main parameter
! ----------------------------------
      nx=64 *RESOLVE
      ny=64 *RESOLVE
      nz=30 *vRESOLVE

      dx=80e3  /RESOLVE
      dt=2400.0  /RESOLVE  
      dz=50.0  /vRESOLVE

      A_h=5.0e4 /RESOLVE**2 ! u_t = A u_xx,  1/T = A /L^2 
      A_v=1e-4
      K_v=1e-4
      K_h=0000.0 
      cdbot = 0e-5!*RESOLVE
      cdint = 2e-6
      eps2D_sor = 1e-9

!      enable_noslip               = .true.
      enable_interior_stress      = .true.
!      enable_bottom_stress        = .true.
      enable_hydrostatic          = .true.
      enable_quicker_advection    = .true.  

      enable_diag_zonalave = .true.
      enable_diag_timeave = .false.

!      runlen = 365*50000*86400.
      runlen = 50*365*86400.
      snapint =  365*86400.*0.5

      enable_diag_tracer    = .true.
      nt=1
      delimit_tracer_fluxes      = .false.
      enable_isopycnal_diffusion = .true.
      K_gm=2000.0
 end subroutine set_parameter


 subroutine set_coriolis
      use pyOM_module   
      implicit none
! ----------------------------------
!      add here initial conditions
! ----------------------------------
      integer :: j
      real*8,parameter :: pi=3.1415   
      real*8,parameter :: radius  = 6370.0e3   ! earth radius
      real*8,parameter :: omega   = pi/43082.0 ! earth rotation freq. in 1/s
      real*8,parameter :: phi0 = 0 /180. *pi
      do j=1,ny
      coriolis_t(j) = 2*omega*sin(phi0) + 2*omega*cos(phi0)/radius*yt(j)
      enddo
 end subroutine set_coriolis


 subroutine boundary_conditions
! ----------------------------------
!    add here boundary conditions
! ----------------------------------
      use pyOM_module   
      implicit none
      integer :: j,k,js,je
      real*8 :: Ly,t_rest,sst(nx ,ny ),sss(nx ,ny ),sig(nx ,ny )
      real*8 :: salt_flux(ny ),t_star(ny )
! ----------------------------------
!      add here restoring zones, surface boundary conditions etc.
! ----------------------------------
      js=max(2,js_pe); je = min(je_pe,ny -1)
      Ly = yt(ny )-yt(1)
      call get_salt_flux(salt_flux)
      t_rest=30*86400
      do j=js,je
       t_star(j)=15*(1-exp(-(yt(j)-yt(ny -1))**2/(Ly/8.)**2 )) 
      enddo
      k=nz-1
      do j=js,je ! sig = 0.8 S - 0.2T ,  T = (0.8S -sig)/0.2
       sig(:,j)=  b(:,j,k,taum1)*1024/9.81
       sss(:,j)= tr(:,j,k,taum1,1)
       sst(:,j) = (0.8*sss(:,j)-sig(:,j)) /0.2
       surface_flux(:,j)=dz/t_rest*(t_star(j)-sst(:,j)) 
       surface_flux(:,j)=(0.8*salt_flux(j)-0.2*surface_flux(:,j))/1024*9.81
      enddo
end subroutine boundary_conditions


subroutine tracer_sources
      use pyOM_module   
      implicit none
      integer :: j,k,js,je
      real*8 :: salt_flux(ny)
! ----------------------------------
!      add here restoring zones, surface boundary conditions etc.
! ----------------------------------
      js=max(2,js_pe); je = min(je_pe,ny-1)
      call get_salt_flux(salt_flux)
      k=nz-1
      do j=js,je
       tr(:,j,k,taup1,1)=tr(:,j,k,taup1,1)+maskT(:,j,k)*c2dt*salt_flux(j)/dz
      enddo
end subroutine tracer_sources


subroutine get_salt_flux(salt_flux)
      use pyOM_module   
      implicit none
      real*8 :: salt_flux(ny )
      integer :: j,js,je
      real*8 :: fxa,Ly
      js=max(2,js_pe); je = min(je_pe,ny -1)
      Ly = yt(ny )-yt(1)
!     surface forcing
      salt_flux(js:je)=0.0
      fxa=0.5/86400.
      do j=js,je
       salt_flux(j)=-fxa*exp(-(yt(j)-yt(ny -1))**2/(Ly/8.)**2 )
      enddo
      fxa=0.; 
      do j=js,je
       fxa=fxa+salt_flux(j)
      enddo; 
      call global_sum(fxa)
      fxa=fxa/(ny -2.)
      salt_flux=salt_flux-fxa
end subroutine get_salt_flux

subroutine initial_conditions
end subroutine initial_conditions

subroutine restoring_zones
end subroutine restoring_zones

subroutine momentum_restoring_zones
end subroutine momentum_restoring_zones

subroutine topography
end subroutine topography
