

 subroutine solve_pressure(ierr)
!=======================================================================
!      solve for surface pressure or implicit linear free surface
!=======================================================================
      use pyOM_module   
      implicit none
      integer, intent(out) :: ierr
      integer :: i,j,k,n,js,je,js2,je2, maxitt=5000
      real*8 :: forc2D(nx,ny), forc3D(nx,ny,nz)
      real*8 :: fpx(nx,ny), fpy(nx,ny)
      real*8 :: etam(nx,ny),bum(nx,ny),bvm(nx,ny)
      real*8, parameter :: g      = 9.806           ! Earth accelaration constant in m/s^2
      ierr=0

!---------------------------------------------------------------------------------
!       boundary exchange for forcing
!---------------------------------------------------------------------------------
      call border_exchg3D(nx,ny,nz,fu,1)
      call setcyclic3D(nx,ny,nz,fu)
      call border_exchg3D(nx,ny,nz,fv,1)
      call setcyclic3D(nx,ny,nz,fv)
      if (.not. enable_hydrostatic) then
       call border_exchg3D(nx,ny,nz,fw,1)
       call setcyclic3D(nx,ny,nz,fw)
      endif
      call border_exchg3D(nx,ny,nz,b(:,:,:,taup1),2)
      call setcyclic3D(nx,ny,nz,b(:,:,:,taup1) )

      js =max(2,js_pe);   je  = min(je_pe,ny-1)
      js2=max(1,js_pe-1); je2 = min(je_pe+1,ny)
!---------------------------------------------------------------------------------
!      hydrostatic pressure
!---------------------------------------------------------------------------------
      do j=js2,je2
       p_hydro(:,j,nz) = 0
       do k=nz-1,1,-1
        p_hydro(:,j,k)= maskT(:,j,k)* (p_hydro(:,j,k+1)+(b(:,j,k+1,tau)+b(:,j,k,tau))/2.0*dz)
       enddo
      enddo
      call setcyclic3D(nx,ny,nz,p_hydro)
!---------------------------------------------------------------------------------
!       surface pressure forcing, etc
!---------------------------------------------------------------------------------
      fpx(:,js_pe:je_pe)=0.;fpy(:,js_pe:je_pe)=0.
      do k=1,nz-1
       do j=js,je
        do i=2,nx-1
           fpx(i,j)=fpx(i,j)+(fu(i,j,k)-(p_hydro(i+1,j,k)-p_hydro(i,j,k))/dx )*maskU(i,j,k)*dz
           fpy(i,j)=fpy(i,j)+(fv(i,j,k)-(p_hydro(i,j+1,k)-p_hydro(i,j,k))/dx )*maskV(i,j,k)*dz
        enddo
       enddo
      enddo

      if (enable_free_surface) then
      do k=1,nz-1
       do j=js,je
        do i=2,nx-1
           fpx(i,j)=fpx(i,j)+(u(i,j,k,taum1)/c2dt   )*maskU(i,j,k)*dz
           fpy(i,j)=fpy(i,j)+(v(i,j,k,taum1)/c2dt   )*maskV(i,j,k)*dz
        enddo
       enddo
      enddo
      endif

      if (.not.enable_hydrostatic) then
       do k=1,nz-1
        do j=js,je
         do i=2,nx-1
           fpx(i,j)=fpx(i,j)    -(psi(i+1,j,k)-psi(i,j,k))/dx*maskU(i,j,k)*dz
           fpy(i,j)=fpy(i,j)    -(psi(i,j+1,k)-psi(i,j,k))/dx*maskV(i,j,k)*dz
         enddo
        enddo
       enddo
      endif

      if (enable_expl_free_surf) then
       do k=1,nz-1
        do j=js,je
         do i=2,nx-1
           fpx(i,j)=fpx(i,j)-   maskU(i,j,k)*dz* &
           coriolis_t(j)*(v(i,j  ,k,tau)+v(i+1,j  ,k,tau)+  v(i,j-1,k,tau)+v(i+1,j-1,k,tau))/4.0
           fpy(i,j)=fpy(i,j)  +maskV(i,j,k)*dz*  (coriolis_t(j  )*(u(i-1,j  ,k,tau)+u(i,j  ,k,tau))  &
           +coriolis_t(j+1)*(u(i-1,j+1,k,tau)+u(i,j+1,k,tau)))/4.0
         enddo
        enddo
       enddo
      endif

      call border_exchg2D(nx,ny,fpx,1); call border_exchg2D(nx,ny,fpy,1)
      call setcyclic2D(nx,ny,fpx); call setcyclic2D(nx,ny,fpy)

      if (enable_expl_free_surf) then
        n=nint(dt/dtex)
        do j=js2,je2
         etam(:,j)=0;
         bum(:,j)=0;
         bvm(:,j)=0;
        enddo
        do k=1,n*2
!        (eta'-eta)/dt + U_x + V_y = 0
!        (U'-U)/dt + g H eta_x = fu
!        (V'-V)/dt + g H eta_y = fv
         do j=js,je
          do i=2,nx-1
           eta(i,j,taum1)=eta(i,j,tau)+maskT(i,j,nz-1)*dtex*(  &
               -(bu(i,j,tau)-bu(i-1,j,tau))/dx -(bv(i,j,tau)-bv(i,j-1,tau))/dx )
           bu(i,j,taum1)=bu(i,j,tau)+maskU(i,j,nz-1)*dtex*(- g*hu(i,j)*(eta(i+1,j,tau)-eta(i,j,tau))/dx &
          +coriolis_t(j)*(bv(i,j,tau)+bv(i+1,j,tau)+ bv(i,j-1,tau)+bv(i+1,j-1,tau))/4.0 + fpx(i,j) )
           bv(i,j,taum1)=bv(i,j,tau)+maskV(i,j,nz-1)*dtex*(- g*hv(i,j)*(eta(i,j+1,tau)-eta(i,j,tau))/dx &
           -(coriolis_t(j  )*(bu(i-1,j,tau)+bu(i,j,tau))+coriolis_t(j+1)*(bu(i-1,j+1,tau)+bu(i,j+1,tau)))/4.0+fpy(i,j) )
          enddo
         enddo
         call border_exchg2D(nx,ny,eta(:,:,taum1),1); 
         call setcyclic2D(nx,ny,eta(:,:,taum1))
         call border_exchg2D(nx,ny,bu(:,:,taum1),1); 
         call setcyclic2D(nx,ny,bu(:,:,taum1))
         call border_exchg2D(nx,ny,bv(:,:,taum1),1); 
         call setcyclic2D(nx,ny,bv(:,:,taum1))
!        (eta''-eta)/dt+U'_x+V'_y = 0
!        (U''-U)/dt + g H eta'_x = fu
!        (V''-V)/dt + g H eta'_y = fv
         do j=js,je
          do i=2,nx-1
           eta(i,j,taup1)=eta(i,j,tau)+maskT(i,j,nz-1)*dtex*(  &
               -(bu(i,j,taum1)-bu(i-1,j,taum1))/dx-(bv(i,j,taum1)-bv(i,j-1,taum1))/dx )
           bu(i,j,taup1)=bu(i,j,tau)+maskU(i,j,nz-1)*dtex*(- g*hu(i,j)*(eta(i+1,j,taum1)-eta(i,j,taum1))/dx &
          +coriolis_t(j)*(bv(i,j,taum1)+bv(i+1,j,taum1)+ bv(i,j-1,taum1)+bv(i+1,j-1,taum1))/4.0 + fpx(i,j) )
           bv(i,j,taup1)=bv(i,j,tau)+maskV(i,j,nz-1)*dtex*(- g*hv(i,j)*(eta(i,j+1,taum1)-eta(i,j,taum1))/dx & 
      -(coriolis_t(j)*(bu(i-1,j,taum1)+bu(i,j,taum1))+coriolis_t(j+1)*(bu(i-1,j+1,taum1)+bu(i,j+1,taum1)))/4.0+fpy(i,j) )
          enddo
         enddo
         call border_exchg2D(nx,ny,eta(:,:,taup1),1); 
         call setcyclic2D(nx,ny,eta(:,:,taup1))
         call border_exchg2D(nx,ny,bu(:,:,taup1),1); 
         call setcyclic2D(nx,ny,bu(:,:,taup1))
         call border_exchg2D(nx,ny,bv(:,:,taup1),1); 
         call setcyclic2D(nx,ny,bv(:,:,taup1))
!       shift time positions
         do j=js2,je2
          eta(:,j,tau)=eta(:,j,taup1)
          bu(:,j,tau)=bu(:,j,taup1)
          bv(:,j,tau)=bv(:,j,taup1)
         enddo
!        accumulate eta,u and v
         do j=js2,je2
          etam(:,j)=etam(:,j)+eta(:,j,taup1)
          bum(:,j)=bum(:,j)+bu(:,j,taup1)
          bvm(:,j)=bvm(:,j)+bv(:,j,taup1)
         enddo
        enddo! n
!       use averaged eta, u and v
        do j=js2,je2
          eta(:,j,tau)=etam(:,j)/(2.*n); eta(:,j,taup1)=eta(:,j,tau)
          bu(:,j,tau)=bum(:,j)/(2.*n); bu(:,j,taup1)=bu(:,j,tau)
          bv(:,j,tau)=bvm(:,j)/(2.*n); bv(:,j,taup1)=bv(:,j,tau)
        enddo
        do j=js2,je2
         p_surf(:,j)=eta(:,j,taup1)*g
        enddo
      else ! enable_expl_free_surf
       forc2D(:,js_pe:je_pe)=0.0
       do j=js,je
        do i=2,nx-1
         forc2D(i,j)=(fpx(i,j)-fpx(i-1,j))/dx+(fpy(i,j)-fpy(i,j-1))/dx 
        enddo
       enddo
       if (enable_free_surface) then
        do j=js,je
         do i=2,nx-1
          forc2D(i,j)=forc2D(i,j)-eta(i,j,taum1)/(c2dt**2)
         enddo
        enddo
       endif
       call setcyclic2D(nx,ny,forc2D)
!---------------------------------------------------------------------------------
!      solve for surface pressure or free surface
!---------------------------------------------------------------------------------
       if (enable_free_surface) then
        p_surf(:,js_pe:je_pe)=eta(:,js_pe:je_pe,taup1)
        call border_exchg2D(nx,ny,p_surf,1); call setcyclic2D(nx,ny,p_surf)
       endif
       call congrad2D(nx,ny,cf2D,forc2D,maxitt,sor2D_itts,eps2D_sor)
       if (enable_free_surface) then
        do j=js,je
         do i=2,nx-1
          eta(i,j,taup1)=p_surf(i,j)
          p_surf(i,j)=eta(i,j,taup1)*g
          eta(i,j,tau) = eta(i,j,tau) + gamma* (0.5*(eta(i,j,taup1) + eta(i,j,taum1)) - eta(i,j,tau)) 
         enddo
        enddo
       endif
       call border_exchg2D(nx,ny,p_surf,1); call setcyclic2D(nx,ny,p_surf)
      endif

!---------------------------------------------------------------------------------
!       full pressure is surface pressure plus hydrostatic pressure
!---------------------------------------------------------------------------------
      do k=1,nz
       do j=js,je
        p_full(:,j,k,tau) =(p_hydro(:,j,k)+p_surf(:,j))*maskT(:,j,k)
       enddo
      enddo
      call border_exchg3D(nx,ny,nz,p_full(:,:,:,tau),1)
      call setcyclic3D(nx,ny,nz,p_full(:,:,:,tau))

      if (.not. enable_hydrostatic) then
!---------------------------------------------------------------------------------
!        forcing for non-hydrostatic pressure
!---------------------------------------------------------------------------------
       forc3D=0.
       do k=2,nz-1
        do j=js,je
         do i=2,nx-1
          forc3D(i,j,k)= (fw(i,j,k)-fw(i,j,k-1))/dz+ (fu(i,j,k)-fu(i-1,j,k))/dx + (fv(i,j,k)-fv(i,j-1,k))/dx &
        -((p_full(i+1,j,k,tau)-p_full(i,j,k,tau))/dx*maskU(i  ,j,k)   &
         -(p_full(i,j,k,tau)-p_full(i-1,j,k,tau))/dx*maskU(i-1,j,k))/dx   &
        -((p_full(i,j+1,k,tau)-p_full(i,j,k,tau))/dx*maskV(i,j  ,k)   &
         -(p_full(i,j,k,tau)-p_full(i,j-1,k,tau))/dx*maskV(i,j-1,k))/dx
         enddo
        enddo
       enddo
       call setcyclic3D(nx,ny,nz,forc3D)
!---------------------------------------------------------------------------------
!        solve for non hydrostatic pressure
!---------------------------------------------------------------------------------
       call congrad3D(nx,ny,nz,cf3D,forc3D,maxitt,sor3D_itts,eps3D_sor)
       call border_exchg3D(nx,ny,nz,psi,1)
       call setcyclic3D(nx,ny,nz,psi)
!---------------------------------------------------------------------------------
!       full pressure 
!---------------------------------------------------------------------------------
       do j=js,je
        p_full(:,j,:,tau) =(p_full(:,j,:,tau)+psi(:,j,:))*maskT(:,j,:)
       enddo
       call border_exchg3D(nx,ny,nz,p_full(:,:,:,tau),1)
       call setcyclic3D(nx,ny,nz,p_full(:,:,:,tau))
      endif

 end subroutine solve_pressure



 subroutine make_coef3D(ierr)
      use pyOM_module   
      implicit none
!-----------------------------------------------------------------------
!             A * dpsi = forc
!                       res = A * p
!          res = res +  cf(...,ii,jj,kk) * p(i+ii,j+jj,k+kk) 
!
!          forc = p_xx + p_yy + p_zz
!         forc = (p(i+1) - 2p(i) + p(i-1))  /dx^2 ...
!              = [ (p(i+1) - p(i))/dx - (p(i)-p(i-1))/dx ] /dx 
!-----------------------------------------------------------------------
      integer, intent(out) :: ierr
      real*8 :: mp,mm
      integer :: i,j,k
      ierr = 0
      call check_pyOM_module(ierr); if (ierr/=0) return
      cf3D=0.
      do k=2,nz-1
       do j=2,ny-1
        do i=2,nx-1
         mp=maskT(i,j,k)*maskT(i+1,j,k)/dx**2
         mm=maskT(i,j,k)*maskT(i-1,j,k)/dx**2
         cf3D(i,j,k, 0+2, 0+2, 0+2)= cf3D(i,j,k, 0+2, 0+2, 0+2)-mp
         cf3D(i,j,k, 1+2, 0+2, 0+2)= cf3D(i,j,k, 1+2, 0+2, 0+2)+mp
         cf3D(i,j,k, 0+2, 0+2, 0+2)= cf3D(i,j,k, 0+2, 0+2, 0+2)-mm
         cf3D(i,j,k,-1+2, 0+2, 0+2)= cf3D(i,j,k,-1+2, 0+2, 0+2)+mm

         mp=maskT(i,j,k)*maskT(i,j+1,k)/dx**2
         mm=maskT(i,j,k)*maskT(i,j-1,k)/dx**2
         cf3D(i,j,k, 0+2, 0+2, 0+2)= cf3D(i,j,k, 0+2, 0+2, 0+2)-mp
         cf3D(i,j,k, 0+2, 1+2, 0+2)= cf3D(i,j,k, 0+2, 1+2, 0+2)+mp
         cf3D(i,j,k, 0+2, 0+2, 0+2)= cf3D(i,j,k, 0+2, 0+2, 0+2)-mm
         cf3D(i,j,k, 0+2,-1+2, 0+2)= cf3D(i,j,k, 0+2,-1+2, 0+2)+mm

         mp=maskT(i,j,k)*maskT(i,j,k+1)/dz**2
         mm=maskT(i,j,k)*maskT(i,j,k-1)/dz**2
         cf3D(i,j,k, 0+2, 0+2, 0+2)= cf3D(i,j,k, 0+2, 0+2, 0+2)-mp
         cf3D(i,j,k, 0+2, 0+2, 1+2)= cf3D(i,j,k, 0+2, 0+2, 1+2)+mp
         cf3D(i,j,k, 0+2, 0+2, 0+2)= cf3D(i,j,k, 0+2, 0+2, 0+2)-mm
         cf3D(i,j,k, 0+2, 0+2,-1+2)= cf3D(i,j,k, 0+2, 0+2,-1+2)+mm

        end do
       end do
      end do
 end subroutine make_coef3D


 subroutine make_coef2D(ierr)
      use pyOM_module   
      implicit none
!-----------------------------------------------------------------------
!         A * dpsi = forc
!         res = A * p
!         res = res +  cf(...,ii,jj,kk) * p(i+ii,j+jj,k+kk) 
!
!         forc = (h p_x)_x +(h p_y)_y + (hp_z)_z
!         forc = [ hu(i)(p(i+1) - p(i))/dx - hu(i-1)(p(i)-p(i-1))/dx ] /dx 
!         forc = hu(i) p(i+1)/dx^2  - p(i) (hu(i)+hu(i-1))/dx^2  + hu(i-1) p(i-1)/dx^2
!-----------------------------------------------------------------------
      integer, intent(out) :: ierr
      real*8, parameter :: g      = 9.806           ! Earth accelaration constant in m/s^2
      real*8 :: maskM(nx,ny),mp,mm
      integer :: i,j
      ierr=0
      call check_pyOM_module(ierr); if (ierr/=0) return

      cf2D=0.
      maskM=maskT(:,:,nz-1)
      do j=2,ny-1
       do i=2,nx-1
         mp=maskM(i,j)*maskM(i+1,j)/dx**2
         mm=maskM(i,j)*maskM(i-1,j)/dx**2
         cf2D(i,j, 0+2, 0+2)= cf2D(i,j, 0+2, 0+2)-mp*hu(i  ,j)
         cf2D(i,j, 1+2, 0+2)= cf2D(i,j, 1+2, 0+2)+mp*hu(i  ,j)
         cf2D(i,j, 0+2, 0+2)= cf2D(i,j, 0+2, 0+2)-mm*hu(i-1,j)
         cf2D(i,j,-1+2, 0+2)= cf2D(i,j,-1+2, 0+2)+mm*hu(i-1,j)

         mp=maskM(i,j)*maskM(i,j+1)/dx**2
         mm=maskM(i,j)*maskM(i,j-1)/dx**2
         cf2D(i,j, 0+2, 0+2)= cf2D(i,j, 0+2, 0+2)-mp*hv(i,j)
         cf2D(i,j, 0+2, 1+2)= cf2D(i,j, 0+2, 1+2)+mp*hv(i,j)
         cf2D(i,j, 0+2, 0+2)= cf2D(i,j, 0+2, 0+2)-mm*hv(i,j-1)
         cf2D(i,j, 0+2,-1+2)= cf2D(i,j, 0+2,-1+2)+mm*hv(i,j-1)
       end do
      end do
      if (enable_free_surface) then
       cf2D=cf2D*g
       do j=2,ny-1
        do i=2,nx-1
         cf2D(i,j, 0+2, 0+2)= cf2D(i,j,0+2,0+2)-1/( c2dt )**2
        end do
       end do
      endif
 end subroutine make_coef2D


