

 
 subroutine momentum_tendency(ierr)
!=======================================================================
!       tendencies for momentum stored in F_u, F_v and F_w
!=======================================================================
      use pyOM_module   
      implicit none
      integer, intent(out) :: ierr
      integer :: i,j,k,js,je
      real*8 :: adv_fe(nx,ny,nz), adv_ft(nx,ny,nz)
      real*8 :: adv_fn(nx,ny,nz), diff_fn(nx,ny,nz)
      real*8 :: diff_fe(nx,ny,nz),diff_ft(nx,ny,nz)
      real*8 :: fxa
      ierr=0
      js=max(2,js_pe); je = min(je_pe,ny-1)
!---------------------------------------------------------------------------------
!      Zonal momentum equation: advective and diffusive fluxes
!---------------------------------------------------------------------------------
      adv_fe(:,js_pe:je_pe,:)=0.0; 
      adv_fn(:,js_pe:je_pe,:)=0.0; 
      adv_ft(:,js_pe:je_pe,:)=0.0; 
      if (enable_4th_mom_advection) then
       call setcyclic3D_j2(nx,ny,nz,u(:,:,:,tau) )
       call adv_flux_u_4th(nx,ny,nz,adv_fe,adv_fn,adv_ft)
      elseif (enable_quicker_mom_advection) then
       call setcyclic3D_j2(nx,ny,nz,u(:,:,:,taum1) )
       call adv_flux_u_quicker(nx,ny,nz,adv_fe,adv_fn,adv_ft)
      elseif (enable_no_mom_advection) then
          ! do nothing
          adv_fn(:,js-1 :je_pe,:)=0.0; 
      else
       call adv_flux_u_2nd(nx,ny,nz,adv_fe,adv_fn,adv_ft)
      endif

      diff_fe(:,js_pe:je_pe,:)=0.0; 
      diff_fn(:,js_pe:je_pe,:)=0.0; 
      call harm_hfric_u(nx,ny,nz,diff_fe,diff_fn)
!---------------------------------------------------------------------------------
!      vertical friction
!---------------------------------------------------------------------------------
      diff_ft(:,js_pe:je_pe,:)=0.0; 
      do k=1,nz-1
       do j=js,je
        do i=2,nx-1
          diff_ft(i,j,k)=A_v*(u(i,j,k+1,taum1)-u(i,j,k,taum1))/dz *maskU(i,j,k+1)*maskU(i,j,k)
        enddo
       enddo
      enddo
!---------------------------------------------------------------------------------
!      add surface and bottom boundary conditions 
!---------------------------------------------------------------------------------
      do j=js,je
       diff_ft(:,j,nz-1)= surface_taux(:,j)*maskU(:,j,nz-1)
       diff_ft(:,j,1   )= bottom_taux(:,j)*maskU(:,j,2   )
      enddo
!---------------------------------------------------------------------------------
!    account for no slip at bottom
!---------------------------------------------------------------------------------
      if (enable_bottom_noslip) then
       do k=1,nz-1
        do j=js,je
         diff_ft(:,j,k)=diff_ft(:,j,k)+2*A_v*u(:,j,k+1,taum1)/dz*(1-maskU(:,j,k))*maskU(:,j,k+1)
        enddo
       enddo
      endif
!---------------------------------------------------------------------------------
!      F_u = - u u_x - v u_y - w u_z + A_h u_xx + A_v u_zz  + f_vert v - f_hor w
!---------------------------------------------------------------------------------
      do k=2,nz-1
       do j=js,je
        do i=2,nx-1
         fu(i,j,k)= maskU(i,j,k)*(  &
          -(adv_fe(i,j,k) - adv_fe(i-1,j,k) )/dx  &
          -(adv_fn(i,j,k) - adv_fn(i,j-1,k) )/dx  &
          -(adv_ft(i,j,k) - adv_ft(i,j,k-1) )/dz  &
          +(diff_ft(i,j,k) - diff_ft(i,j,k-1))/dz   &
          +(diff_fe(i,j,k) - diff_fe(i-1,j,k))/dx  &
          +(diff_fn(i,j,k) - diff_fn(i,j-1,k))/dx  &
                                   )
        enddo
       enddo
      enddo
!---------------------------------------------------------------------------------
!      Meridional momentum equation: advective and diffusive fluxes
!---------------------------------------------------------------------------------
      adv_fe(:,js_pe:je_pe,:)=0.0; 
      adv_fn(:,js_pe:je_pe,:)=0.0; 
      adv_ft(:,js_pe:je_pe,:)=0.0; 
      if (enable_4th_mom_advection) then
       call setcyclic3D_j2(nx,ny,nz,v(:,:,:,tau) )
       call adv_flux_v_4th(nx,ny,nz,adv_fe,adv_fn,adv_ft)
      elseif (enable_quicker_mom_advection) then
       call setcyclic3D_j2(nx,ny,nz,v(:,:,:,taum1) )
       call adv_flux_v_quicker(nx,ny,nz,adv_fe,adv_fn,adv_ft)
      elseif (enable_no_mom_advection) then
        ! do nothing
        adv_fn(:,js-1 :je_pe,:)=0.0; 
      else
       call adv_flux_v_2nd(nx,ny,nz,adv_fe,adv_fn,adv_ft)
      endif

      diff_fe(:,js_pe:je_pe,:)=0.0; 
      diff_fn(:,js_pe:je_pe,:)=0.0; 
      call harm_hfric_v(nx,ny,nz,diff_fe,diff_fn)
!---------------------------------------------------------------------------------
!      vertical friction
!---------------------------------------------------------------------------------
      diff_ft(:,js_pe:je_pe,:)=0.0; 
      do k=1,nz-1
       do j=js,je
        do i=2,nx-1
          diff_ft(i,j,k)=A_v*(v(i,j,k+1,taum1)-v(i,j,k,taum1))/dz*maskV(i,j,k+1)*maskV(i,j,k)
        enddo
       enddo
      enddo
!---------------------------------------------------------------------------------
!      add surface and bottom boundary conditions 
!---------------------------------------------------------------------------------
      do j=js,je
       diff_ft(:,j,nz-1)= surface_tauy(:,j)*maskV(:,j,nz-1)
       diff_ft(:,j,1   )= bottom_tauy(:,j)*maskV(:,j,2)
      enddo
!---------------------------------------------------------------------------------
!    account for no slip at bottom
!---------------------------------------------------------------------------------
      if (enable_bottom_noslip) then
       do k=1,nz-1
        do j=js,je
         diff_ft(:,j,k)=diff_ft(:,j,k)+2*A_v*v(:,j,k+1,taum1)/dz*(1-maskV(:,j,k))*maskV(:,j,k+1)
        enddo
       enddo
      endif
!---------------------------------------------------------------------------------
!      F_v = - u v_x - v v_y - w v_z + A_h v_xx + A_v v_zz - f_vert u
!---------------------------------------------------------------------------------
      do k=2,nz-1
       do j=js,je
        do i=2,nx-1
         fv(i,j,k)= maskV(i,j,k)*(  &
          -(adv_fe(i,j,k) - adv_fe(i-1,j,k) )/dx  &
          -(adv_fn(i,j,k) - adv_fn(i,j-1,k) )/dx  &
          -(adv_ft(i,j,k) - adv_ft(i,j,k-1) )/dz  &
          +(diff_ft(i,j,k) - diff_ft(i,j,k-1))/dz  &
          +(diff_fe(i,j,k) - diff_fe(i-1,j,k))/dx  &
          +(diff_fn(i,j,k) - diff_fn(i,j-1,k))/dx  &
                                   )
        enddo
       enddo
      enddo
!---------------------------------------------------------------------------------
!        vertical momentum equation: advective and diffusive fluxes
!---------------------------------------------------------------------------------
      if (.not. enable_hydrostatic) then
       adv_fe(:,js_pe:je_pe,:)=0.0; 
       adv_fn(:,js_pe:je_pe,:)=0.0; 
       adv_ft(:,js_pe:je_pe,:)=0.0; 
       if (enable_4th_mom_advection) then
        call setcyclic3D_j2(nx,ny,nz,w(:,:,:,tau) )
        call adv_flux_w_4th(nx,ny,nz,adv_fe,adv_fn,adv_ft)
       elseif (enable_quicker_mom_advection) then
        call setcyclic3D_j2(nx,ny,nz,w(:,:,:,taum1) )
        call adv_flux_w_quicker(nx,ny,nz,adv_fe,adv_fn,adv_ft)
       elseif (enable_no_mom_advection) then
        ! do nothing
         adv_fn(:,js-1:je_pe,:)=0.0; 
       else
        call adv_flux_w_2nd(nx,ny,nz,adv_fe,adv_fn,adv_ft)
       endif

       diff_fe(:,js_pe:je_pe,:)=0.0; 
       diff_fn(:,js_pe:je_pe,:)=0.0; 
       call harm_hfric_w(nx,ny,nz,diff_fe,diff_fn)
!---------------------------------------------------------------------------------
!       vertical friction
!---------------------------------------------------------------------------------
       diff_ft(:,js_pe:je_pe,:)=0.0; 
       do k=1,nz-1
        do j=js,je
         do i=2,nx-1
          diff_ft(i,j,k)=A_v*(w(i,j,k+1,taum1)-w(i,j,k,taum1))/dz*maskW(i,j,k+1)*maskW(i,j,k)
         enddo
        enddo
       enddo
!---------------------------------------------------------------------------------
!        F_w = - u w_x - v w_y - w w_z  + A_h w_xx + A_v w_zz  +f_hor u 
!---------------------------------------------------------------------------------
       do k=2,nz-1
        do j=js,je
         do i=2,nx-1
          fw(i,j,k)= maskW(i,j,k)*(   &
           -(adv_fe(i,j,k) - adv_fe(i-1,j,k) )/dx   &
           -(adv_fn(i,j,k) - adv_fn(i,j-1,k) )/dx   &
           -(adv_ft(i,j,k) - adv_ft(i,j,k-1) )/dz   &
           +(diff_fe(i,j,k) - diff_fe(i-1,j,k))/dx   &
           +(diff_fn(i,j,k) - diff_fn(i,j-1,k))/dx   &
           +(diff_ft(i,j,k) - diff_ft(i,j,k-1))/dz   &
                                   )
         enddo
        enddo
       enddo
      endif
!---------------------------------------------------------------------------------
!      Add coriolis force to F_u, F_v and F_w
!---------------------------------------------------------------------------------
      call coriolis_force
!---------------------------------------------------------------------------------
!       add bottom drag : u_t = - c_D u 
!---------------------------------------------------------------------------------
      if (enable_bottom_stress) then
       do j=js,je
        do i=2,nx-1
         k=max(1,k_bottom_u(i,j))
         fxa = cdbot*u(i,j,k,taum1)
         fu(i,j,k) = fu(i,j,k)-maskU(i,j,k)*fxa
         k=max(1,k_bottom_v(i,j))
         fxa = cdbot*v(i,j,k,taum1)
         fv(i,j,k) = fv(i,j,k)-maskV(i,j,k)*fxa
        enddo
       enddo
      endif
!---------------------------------------------------------------------------------
!       add interior drag : u_t = - c_D u 
!---------------------------------------------------------------------------------
      if (enable_interior_stress) then
       do k=2,nz-1
        do j=js,je
         do i=2,nx-1
          fxa = cdint*u(i,j,k,taum1)
          fu(i,j,k) = fu(i,j,k)-maskU(i,j,k)*fxa
          fxa = cdint*v(i,j,k,taum1)
          fv(i,j,k) = fv(i,j,k)-maskV(i,j,k)*fxa
         enddo
        enddo
       enddo
      endif
!---------------------------------------------------------------------------------
!      add biharmonic friction
!---------------------------------------------------------------------------------
      if (enable_biharmonic_friction) then
       call biha_hfric_u(nx,ny,nz,diff_fe,diff_fn)
       call biha_hfric_v(nx,ny,nz,diff_fe,diff_fn)
       if (.not.enable_hydrostatic) call biha_hfric_w(nx,ny,nz,diff_fe,diff_fn)
      endif
      if (enable_vert_biha_friction) then
       call biha_vfric_u (nx,ny,nz,diff_ft)
       call biha_vfric_v (nx,ny,nz,diff_ft)
       if (.not.enable_hydrostatic) then
        call biha_vfric_w(nx,ny,nz,diff_ft)
       endif
      endif
 end subroutine momentum_tendency





 subroutine coriolis_force
!=======================================================================
!      Add coriolis force to F_u, F_v and F_w
!=======================================================================
      use pyOM_module   
      implicit none
      integer :: i,j,k,js,je
      js=max(2,js_pe); je = min(je_pe,ny-1)

!---------------------------------------------------------------------------------
!      F_u =  A_h u_xx + A_v u_zz  + f_vert v - f_hor w +...
!---------------------------------------------------------------------------------
      do k=2,nz-1
       do j=js,je
        do i=2,nx-1
         fu(i,j,k)=fu(i,j,k)+maskU(i,j,k)*coriolis_t(j)*(v(i,j  ,k,tau)+v(i+1,j  ,k,tau)+ &
                                                         v(i,j-1,k,tau)+v(i+1,j-1,k,tau))/4.0
        enddo
       enddo
      enddo
      if (.not. enable_hydrostatic) then
       do k=2,nz-1
        do j=js,je
         do i=2,nx-1
          fu(i,j,k)=fu(i,j,k)-maskU(i,j,k)*coriolis_hor(j)*(w(i,j,k  ,tau) + w(i+1,j,k  ,tau)+ &
                                                            w(i,j,k-1,tau) + w(i+1,j,k-1,tau) )/4.0
         enddo
        enddo
       enddo
      endif
!---------------------------------------------------------------------------------
!      F_v =  A_h v_xx + A_v v_zz - f_vert u
!---------------------------------------------------------------------------------
      do k=2,nz-1
       do j=js,je
        do i=2,nx-1
         fv(i,j,k)= fv(i,j,k)-maskV(i,j,k)*(coriolis_t(j  )*(u(i-1,j  ,k,tau)+u(i,j  ,k,tau))  &
                                           +coriolis_t(j+1)*(u(i-1,j+1,k,tau)+u(i,j+1,k,tau)))/4.0
        enddo
       enddo
      enddo
!---------------------------------------------------------------------------------
!        F_w = - u w_x - v w_y - w w_z  + A_h w_xx + A_v w_zz + f_hor u 
!---------------------------------------------------------------------------------
      if (.not. enable_hydrostatic) then
       do k=2,nz-1
        do j=js,je
         do i=2,nx-1
          fw(i,j,k)=fw(i,j,k)+maskW(i,j,k)*coriolis_hor(j)*(u(i,j,k  ,tau)+u(i-1,j,k  ,tau)+ &
                                                            u(i,j,k+1,tau)+u(i-1,j,k+1,tau))/4.0
         enddo
        enddo
       enddo
      endif
 end subroutine coriolis_force



 subroutine harm_hfric_u(nx_,ny_,nz_,diff_fe,diff_fn)
!=======================================================================
!       horizontal harmonic friction for u  
!       diff. fluxes are stored in diff_fe and diff_fn
!       account for no slip boundary condition if requested
!=======================================================================
      use pyOM_module   
      implicit none
      integer :: nx_,ny_,nz_
      integer :: i,j,k,js,je
      real*8 :: diff_fn(nx_,ny_,nz_), diff_fe(nx_,ny_,nz_)

      js=max(2,js_pe); je = min(je_pe,ny-1)
      do k=2,nz-1
       do j=js,je
        do i=1,nx-1
          diff_fe(i,j,k)=A_h*(u(i+1,j,k,taum1)-u(i,j,k,taum1))/dx
        enddo
       enddo
      enddo
      call setcyclic3D(nx_,ny_,nz_,diff_fe)
      do k=2,nz-1
       do j=js,je
        do i=2,nx-1
          diff_fn(i,j,k)=A_h*(u(i,j+1,k,taum1)-u(i,j,k,taum1))/dx *maskU(i,j+1,k)*maskU(i,j,k)
        enddo
       enddo
      enddo
      if (enable_noslip) then
       do j=js-1,je
         diff_fn(:,j,:)=diff_fn(:,j,:)-2*A_h*u(:,j,:,taum1)/dx *(1-maskU(:,j+1,:))*maskU(:,j,:)
         diff_fn(:,j,:)=diff_fn(:,j,:)+2*A_h*u(:,j+1,:,taum1)/dx*(1-maskU(:,j,:))*maskU(:,j+1,:)
       enddo
      endif
      call border_exchg3D(nx_,ny_,nz_,diff_fn,1)
      call setcyclic3D(nx_,ny_,nz_,diff_fn)
 end subroutine harm_hfric_u





 subroutine harm_hfric_v(nx_,ny_,nz_,diff_fe,diff_fn)
!=======================================================================
!       horizontal harmonic friction for v  
!       diff. fluxes are stored in diff_fe and diff_fn
!       account for no slip boundary condition if requested
!=======================================================================
      use pyOM_module   
      implicit none
      integer :: nx_,ny_,nz_
      integer :: i,j,k,js,je
      real*8 :: diff_fn(nx_,ny_,nz_), diff_fe(nx_,ny_,nz_)
      js=max(2,js_pe); je = min(je_pe,ny-1)
      do k=2,nz-1
       do j=js,je
        do i=1,nx-1
          diff_fe(i,j,k)=A_h*(v(i+1,j,k,taum1)-v(i,j,k,taum1))/dx *maskV(i+1,j,k)*maskV(i,j,k)
        enddo
       enddo
      enddo
      if (enable_noslip) then
       do j=js,je
       do i=1,nx-1
         diff_fe(i,j,:)=diff_fe(i,j,:)-2*A_h*v(i,j,:,taum1)/dx *(1-maskV(i+1,j,:))*maskV(i,j,:)
         diff_fe(i,j,:)=diff_fe(i,j,:)+2*A_h*v(i+1,j,:,taum1)/dx*(1-maskV(i,j,:))*maskV(i+1,j,:)
       enddo
       enddo
      endif
      call setcyclic3D(nx_,ny_,nz_,diff_fe)
      do k=2,nz-1
       do j=js,je
        do i=2,nx-1
          diff_fn(i,j,k)=A_h*(v(i,j+1,k,taum1)-v(i,j,k,taum1) )/dx
        enddo
       enddo
      enddo
      call border_exchg3D(nx_,ny_,nz_,diff_fn,1)
      call setcyclic3D(nx_,ny_,nz_,diff_fn)
  end subroutine harm_hfric_v




 subroutine harm_hfric_w(nx_,ny_,nz_,diff_fe,diff_fn)
!=======================================================================
!       horizontal harmonic friction for w  
!       diff. fluxes are stored in diff_fe and diff_fn
!=======================================================================
      use pyOM_module   
      implicit none
      integer :: nx_,ny_,nz_
      integer :: i,j,k,js,je
      real*8 :: diff_fn(nx_,ny_,nz_), diff_fe(nx_,ny_,nz_)
      js=max(2,js_pe); je = min(je_pe,ny-1)
      do k=2,nz-1
       do j=js,je
        do i=1,nx-1
          diff_fe(i,j,k)= A_h*(w(i+1,j,k,taum1)-w(i,j,k,taum1))/dx *maskW(i+1,j,k)*maskW(i,j,k)
        enddo
       enddo
      enddo
      call setcyclic3D(nx_,ny_,nz_,diff_fe)
      do k=2,nz-1
       do j=js,je
        do i=2,nx-1
          diff_fn(i,j,k)=A_h*(w(i,j+1,k,taum1)-w(i,j,k,taum1))/dx *maskW(i,j+1,k)*maskW(i,j,k)
        enddo
       enddo
      enddo
      call border_exchg3D(nx_,ny_,nz_,diff_fn,1)
      call setcyclic3D(nx_,ny_,nz_,diff_fn)
 end subroutine harm_hfric_w
