


 subroutine integrate_buoyancy(ierr)
!=======================================================================
!       solve prognostic equation for buoyancy
!=======================================================================
      use pyOM_module   
      implicit none
      integer, intent(out) :: ierr
      integer :: i,j,k,js,je
      real*8 :: adv_fe(nx,ny,nz), adv_ft(nx,ny,nz)
      real*8 :: adv_fn(nx,ny,nz), diff_fn(nx,ny,nz)
      real*8 :: diff_fe(nx,ny,nz),diff_ft(nx,ny,nz),fxa
      ierr=0
      js=max(2,js_pe); je = min(je_pe,ny-1)
!---------------------------------------------------------------------------------
!       db/dt = - div( u b) + nabla * K_h nabla b + (K_b b_z)_z
!---------------------------------------------------------------------------------
      adv_fe(:,js_pe:je_pe,:)=0
      adv_fn(:,js_pe:je_pe,:)=0
      adv_ft(:,js_pe:je_pe,:)=0
      call adv_flux(nx,ny,nz,adv_fe,adv_fn,adv_ft,b)
      call border_exchg3D(nx,ny,nz,adv_fn,1)
      call setcyclic3D(nx,ny,nz,adv_fe)
      call setcyclic3D(nx,ny,nz,adv_fn)

      diff_fe(:,js_pe:je_pe,:)=0
      diff_fn(:,js_pe:je_pe,:)=0
      diff_ft(:,js_pe:je_pe,:)=0
!---------------------------------------------------------------------------------
!      horizontal diffusion
!---------------------------------------------------------------------------------
      do k=2,nz-1
        do j=js,je
         do i=1,nx-1
          fxa=K_h*maskU(i,j,k)
          diff_fe(i,j,k)=fxa*(b(i+1,j,k,taum1)-b(i,j,k,taum1))/dx
         enddo
        enddo
      enddo
      call setcyclic3D(nx,ny,nz,diff_fe)
      do k=2,nz-1
        do j=js,je 
         do i=2,nx-1
          fxa=K_h*maskV(i,j,k)
          diff_fn(i,j,k)=fxa*(b(i,j+1,k,taum1)-b(i,j,k,taum1))/dx
         enddo
        enddo
      enddo
      call border_exchg3D(nx,ny,nz,diff_fn,1)
      call setcyclic3D(nx,ny,nz,diff_fn)
!---------------------------------------------------------------------------------
!      vertical diffusion
!---------------------------------------------------------------------------------
      do k=1,nz-2
       do j=js,je
        do i=2,nx-1
         fxa=K_v*maskW(i,j,k)
         diff_ft(i,j,k)=fxa*(b(i,j,k+1,taum1)-b(i,j,k,taum1))/dz
        enddo
       enddo
      enddo
!---------------------------------------------------------------------------------
!      add surface and bottom boundary conditions
!---------------------------------------------------------------------------------
      do j=js,je
       diff_ft(:,j,nz-1)=surface_flux(:,j)*maskT(:,j,nz-1)
       diff_ft(:,j,1)   =bottom_flux(:,j)*maskT(:,j,2)
      enddo
!---------------------------------------------------------------------------------
!       time tendency of b
!---------------------------------------------------------------------------------
      do k=2,nz-1
       do j=js,je
        do i=2,nx-1
         b(i,j,k,taup1)=b(i,j,k,taum1)+maskT(i,j,k)*c2dt*(  &
        -(adv_fe(i,j,k)-adv_fe(i-1,j,k))/dx &
        -(adv_fn(i,j,k)-adv_fn(i,j-1,k))/dx &
        -(adv_ft(i,j,k)-adv_ft(i,j,k-1))/dz &
        +(diff_ft(i,j,k)-diff_ft(i,j,k-1))/dz &
        +(diff_fe(i,j,k)-diff_fe(i-1,j,k))/dx &
        +(diff_fn(i,j,k)-diff_fn(i,j-1,k))/dx  )
        enddo
       enddo
      enddo
!---------------------------------------------------------------------------------
!       Biharmonic diffusion (horizontal and vertical)
!---------------------------------------------------------------------------------
      if (enable_biharmonic_diffusion) call biha_mix(nx,ny,nz,diff_fe,diff_fn,diff_ft,b)
  end subroutine integrate_buoyancy





