
!=======================================================================
!      Boundary conditions and PE exchange
!=======================================================================


 subroutine my_mpi_init(comm_,ierr)
!--------------------------------------------------------------
!     intitialize mpi system for model
!--------------------------------------------------------------
      use pyOM_module   
      implicit none
      integer, intent(out) :: ierr
      integer :: comm_
       my_comm=comm_
       my_pe=0
       n_pes=1
       ierr=0
 end subroutine my_mpi_init

subroutine mpi_init(ierr)
integer ierr
end subroutine mpi_init

subroutine mpi_finalize(ierr)
integer ierr
end subroutine mpi_finalize

 subroutine halt_stop(string)
!--------------------------------------------------------------
!     controlled stop, should not be called from python
!--------------------------------------------------------------
      implicit none
      character*(*) :: string
      print*,string
      call abort()
end subroutine halt_stop

subroutine fortran_barrier
!--------------------------------------------------------------
!     A barrier for the local sub domain
!     for use in fortran part only
!--------------------------------------------------------------
end subroutine fortran_barrier


  subroutine exchg_prog3Dfield_complete(nx_,ny_,nz_,a)
      implicit none
      integer :: nx_,ny_,nz_
      real*8  :: a(nx_,ny_,nz_,3)
      call setcyclic3D(nx_,ny_,nz_,a(1,1,1,1) )
      call setcyclic3D(nx_,ny_,nz_,a(1,1,1,2) )
      call setcyclic3D(nx_,ny_,nz_,a(1,1,1,3) )
  end subroutine exchg_prog3Dfield_complete

  subroutine exchg_prog2Dfield_complete(nx_,ny_,a)
      implicit none
      integer :: nx_,ny_
      real*8  :: a(nx_,ny_,3)
      call setcyclic2D(nx_,ny_,a(1,1,1) )
      call setcyclic2D(nx_,ny_,a(1,1,2) )
      call setcyclic2D(nx_,ny_,a(1,1,3) )
  end subroutine exchg_prog2Dfield_complete

  subroutine exchg_3Dfield_complete(nx_,ny_,nz_,a)
      implicit none
      integer :: nx_,ny_,nz_
      real*8  :: a(nx_,ny_,nz_)
      call setcyclic3D(nx_,ny_,nz_,a)
  end subroutine exchg_3Dfield_complete

  subroutine exchg_2Dfield_complete(nx_,ny_,a)
      implicit none
      integer :: nx_,ny_
      real*8  :: a(nx_,ny_)
      call setcyclic2D(nx_,ny_,a)
  end subroutine exchg_2Dfield_complete


 subroutine setcyclic3D(nx_,ny_,nz_,p1)
!--------------------------------------------------------------
!       set cyclic boundary conditions for 3D array
!--------------------------------------------------------------
      use pyOM_module   
      implicit none
      real*8 :: p1(nx_,ny_,nz_)
      integer :: j,nx_,ny_,nz_
      if (enable_cyclic_x) then
        do j=max(1,js_pe-1),min(ny,je_pe+1)
          p1(1  ,j,:)=p1(nx-1,j,:); 
          p1(nx,j,:)=p1(2    ,j,:)
         enddo
      endif
      if (enable_cyclic_y) then
        p1(:,1  ,:)=p1(:,ny-1,:); 
        p1(:,ny,:)=p1(:,2    ,:)
      endif
 end subroutine setcyclic3D




 subroutine setcyclic3D_j2(nx_,ny_,nz_,p1)
!--------------------------------------------------------------
!       set cyclic boundary conditions for 3D array
!       communicate 2 rows in meridional direction
!       needed for higher order advection schemes
!--------------------------------------------------------------
      use pyOM_module   
      implicit none
      real*8 :: p1(nx_,ny_,nz_)
      integer :: nx_,ny_,nz_
 end subroutine setcyclic3D_j2



 subroutine setcyclic2D(nx_,ny_,p1)
!--------------------------------------------------------------
!       set cyclic boundary conditions for 2D array
!--------------------------------------------------------------
      use pyOM_module   
      implicit none
      real*8 :: p1(nx_,ny_)
      integer :: j,nx_,ny_
      if (enable_cyclic_x) then
        do j=max(1,js_pe-1),min(ny,je_pe+1)
         p1(1  ,j)=p1(nx-1,j); 
         p1(nx,j)=p1(2    ,j)
        enddo
      endif
      if (enable_cyclic_y) then
        p1(:,1  )=p1(:,ny-1); 
        p1(:,ny)=p1(:,2    )
      endif
 end subroutine setcyclic2D


 subroutine border_exchg3D(nx_,ny_,nz_,a,jx)
!--------------------------------------------------------------
!     Exchange overlapping areas of 3D array a in all PEs of sub 
!     domain. Number of overlapping indicees are given by jx.
!--------------------------------------------------------------
      use pyOM_module   
      implicit none
      integer :: jx,nx_,ny_,nz_
      real*8  :: a(nx_,ny_,nz_)
 end subroutine border_exchg3D





 subroutine border_exchg2D(nx_,ny_,a,jx)
!--------------------------------------------------------------
!     Exchange overlapping areas of 2D array a in all PEs of sub 
!     domain. Number of overlapping indicees are given by jx.
!--------------------------------------------------------------
      use pyOM_module   
      implicit none
      integer :: jx,nx_,ny_
      real*8  :: a(nx_,ny_)
 end subroutine border_exchg2D




 subroutine border_exchg_merid(ny_,nz_,a,jx)
!--------------------------------------------------------------
!     Exchange overlapping areas of array a in all PEs of sub 
!     domain. Number of overlapping indicees are given by jx.
!--------------------------------------------------------------
      use pyOM_module   
      implicit none
      integer :: jx,ny_,nz_
      real*8  :: a(ny_,nz_)
 end subroutine border_exchg_merid


 subroutine pe0_recv_3D(nx_,ny_,nz_,a)
!--------------------------------------------------------------
!     all PEs send their data of a 3D array to PE0
!--------------------------------------------------------------
      use pyOM_module   
      implicit none
      integer :: nx_,ny_,nz_
      real*8  :: a(nx_,ny_,nz_)
 end subroutine pe0_recv_3D


 subroutine pe0_send_3D(nx_,ny_,nz_,a)
!--------------------------------------------------------------
!     all PEs gets data of a 3D array from PE0
!--------------------------------------------------------------
      use pyOM_module   
      implicit none
      integer :: nx_,ny_,nz_
      real*8  :: a(nx_,ny_,nz_)
 end subroutine pe0_send_3D


 subroutine pe0_recv_2D(nx_,ny_,a)
!--------------------------------------------------------------
!     all PEs send their data of a 2D array to PE0
!--------------------------------------------------------------
      use pyOM_module   
      implicit none
      integer :: nx_,ny_
      real*8  :: a(nx_,ny_)
 end subroutine pe0_recv_2D


 subroutine pe0_send_2D(nx_,ny_,a)
!--------------------------------------------------------------
!     all PEs gets data of a 2D array from PE0
!--------------------------------------------------------------
      use pyOM_module   
      implicit none
      integer :: nx_,ny_
      real*8  :: a(nx_,ny_)
 end subroutine pe0_send_2D


 subroutine pe0_recv_1D(nx_,a)
!--------------------------------------------------------------
!     all PEs send their data of a 1D array to PE0
!--------------------------------------------------------------
      use pyOM_module   
      implicit none
      integer :: nx_
      real*8  :: a(nx_)
 end subroutine pe0_recv_1D


 subroutine pe0_send_1D(nx_,a)
!--------------------------------------------------------------
!     all PEs gets data of a 1D array from PE0
!--------------------------------------------------------------
      use pyOM_module   
      implicit none
      integer :: nx_
      real*8  :: a(nx_)
 end subroutine pe0_send_1D


 subroutine pe0_recv_int(a)
!--------------------------------------------------------------
!     all PEs send integer to PE0
!--------------------------------------------------------------
      use pyOM_module   
      implicit none
      integer :: a
 end subroutine pe0_recv_int


 subroutine pe0_send_int(a)
!--------------------------------------------------------------
!     all PEs gets integer from PE0
!--------------------------------------------------------------
      use pyOM_module   
      implicit none
      integer :: a
 end subroutine pe0_send_int



 subroutine global_max(x)
!--------------------------------------------------------------
!     Get the max of real x over all PEs in sub domain
!--------------------------------------------------------------
      implicit none
      real*8    :: x
  end subroutine global_max

 subroutine global_max_int(x,len)
!--------------------------------------------------------------
!     Get the max of integer x over all PEs in sub domain
!--------------------------------------------------------------
      implicit none
      integer  :: x(len)
      integer :: ierr,len
 end subroutine global_max_int

 subroutine global_sum(x)
!--------------------------------------------------------------
!     Do a sum of real x over all PEs in sub domain
!--------------------------------------------------------------
      implicit none
      real*8    :: x
 end subroutine global_sum

 subroutine global_sum_vec(x,len)
!--------------------------------------------------------------
!     Do a sum of real vecter x(len) over all PEs in sub domain
!--------------------------------------------------------------
      implicit none
      integer :: len
      real*8  :: x(len)
end subroutine global_sum_vec


 subroutine bcast_integer(x,len,pe)
!--------------------------------------------------------------
!     Broadcast a integer vector to the local sub domain
!--------------------------------------------------------------
      implicit none
      integer len,pe
      integer x(len)
 end subroutine bcast_integer


 subroutine bcast_real(x,len,pe)
!--------------------------------------------------------------
!     Broadcast a real vector to all sub domains
!--------------------------------------------------------------
      implicit none
      integer len,pe
      real*8 x(len)
 end subroutine bcast_real


