
!=======================================================================
!  1. exp. in Wardle and Marshall 2000, "Representation of eddies in 
!  primitive equation models by a PV flux" JPO, 30
!=======================================================================

 subroutine set_parameter
      use pyOM_module   
      use fcontrol_module
      implicit none
! ----------------------------------
!       set here main parameter
! ----------------------------------
      nx=32;nz=92;ny=26
      dx=20.0e3
      dz=50.0
      dt=600.0
      K_h=000.0
      K_v=0.0e-4
      A_h=0000.0
      A_v=1.e-4
      eps2D_sor = 1e-12
      enable_noslip              = .true.
      enable_cyclic_x            = .true.
      enable_quicker_advection   = .true.
      enable_bottom_stress       = .true.
      enable_biharmonic_friction = .true.
      Ahbi = 1e11
      cdbot=8e-5
      runlen=365.0*86400.
      snapint = 1.0*86400.
end subroutine set_parameter


subroutine set_coriolis
      use pyOM_module   
      implicit none
! ----------------------------------
!      add here initial conditions
! ----------------------------------
   integer :: j
   real*8,parameter :: pi=3.1415   
   real*8,parameter :: radius  = 6370.0e3   ! earth radius
   real*8,parameter :: omega   = pi/43082.0 ! earth rotation freq. in 1/s
   real*8,parameter :: phi0 = 45.0 /180. *pi
   do j=1,ny
      coriolis_t(j) = 2*omega*sin(phi0) + 2*omega*cos(phi0)/radius*yt(j)
   enddo
end subroutine set_coriolis

subroutine initial_conditions
   use pyOM_module   
   implicit none
   integer :: i,j,k
   real :: x,y,B0,N_0, pi=3.1415   

   N_0     = 0.0022
   do k=1,nz
       do j=1,ny
        do i=1,nx
         x=float(i)/float(nx)
         y=float(j)/float(ny)
         B0=1e-6*sin(x*2.5*pi)*cos(y*4*pi)
         b(i,j,k,:) = (B0-N_0**2*zt(k))*maskT(i,j,k)
        enddo
       enddo
   enddo
end subroutine initial_conditions

subroutine boundary_conditions
   use pyOM_module   
   implicit none
   integer :: i,j
   real :: y, pi=3.1415   
      do j=1,ny
       do i=1,nx
        y = (yu(j)-yu(2))/ (yu(ny-1)-yu(2))
        surface_taux(i,j) = .2e-3*sin(pi*y)*maskU(i,j,nz-1)
       enddo
      enddo
end subroutine boundary_conditions

subroutine restoring_zones
end subroutine restoring_zones

subroutine momentum_restoring_zones
end subroutine momentum_restoring_zones

subroutine topography
end subroutine topography

subroutine tracer_sources
end subroutine tracer_sources

