
!=======================================================================
!  idealised Southern Ocean, same as in Viebahn and Eden (2010) Ocean modeling
!======================================================================= 


module config_module
 ! use this module only locally in this file
 implicit none
 real*8,parameter :: pi      = 3.14159265358979323846264338327950588
 real*8,parameter :: omega   = pi/43082.0 ! earth rotation freq. in 1/s
 real*8,parameter :: radius  = 6370.0e3

 real*8 :: lat0, N_0=0.002, tau0=1.0, K0gm = 2000.0
end module config_module


subroutine set_parameter
 ! ----------------------------------
 !       set here main parameter
 ! ----------------------------------
 use pyOM_module   
 use fcontrol_module
 use config_module
 implicit none
 include "netcdf.inc"
 integer :: iret,ncid,xdim,ydim,vid,n
 real *8, allocatable :: lat(:)
 namelist /real_acc/ N_0,tau0,K0gm

      open(10,file='namelist',form='formatted',status='old')
      read(10, nml = real_acc )
      close(10)
      if (my_pe==0) write(6, nml=real_acc)

      iret=nf_open('real_global_topo.cdf',NF_NOWRITE,ncid)
      iret=nf_inq_dimid(ncid,'Longitude_t',xdim)
      iret=nf_inq_dimid(ncid,'Latitude_t',ydim)
      iret=nf_inq_dimlen(ncid,xdim,nx)
      iret=nf_inq_dimlen(ncid,ydim,ny)
      iret=nf_inq_varid(ncid,'Latitude_t',vid)
      allocate(lat(ny))
      iret= nf_get_vara_double(ncid,vid,1,ny,lat)
      n = minloc( (lat+30)**2 ,1)
      dx = (lat(2)-lat(1))*radius/180.*pi
      lat0 = lat(n/2)/180.*pi

      deallocate(lat) 
      ny=n+1
      call ncclos (ncid, iret)

      dz    = 100.0 
      nz    = int(6000.0/dz)+2
      dt    = 3600.0

      A_h=4.0e4
      K_v=1.0e-4
      A_v=1.0e-4
      eps2D_sor = 1e-9

      enable_noslip               = .true.
      enable_bottom_noslip        = .true.
      enable_cyclic_x             = .true.
      enable_hydrostatic          = .true.
      enable_quicker_advection    = .true.  
      enable_bolus_velocity  = .true. 
      K_gm=K0gm

      runlen = 365*86400.*50   
      snapint =  365./12.*86400.     

      enable_back_state = .true.
      enable_diag_barbi = .true.
end subroutine set_parameter


subroutine set_coriolis
 ! ----------------------------------
 !      add here initial conditions
 ! ----------------------------------
 use pyOM_module   
 use config_module   
 implicit none
 integer :: j
 real*8 :: y0

 if (my_pe==0) print*,' reference latitude is ',lat0/pi*180.,' deg'
 do j=1,ny
  !y0 = lat0*radius
  y0 = yt(ny/2)
  coriolis_t(j) = 2*omega*sin(lat0) + 2*omega*cos(lat0)/radius*(yt(j)-y0)
 enddo
end subroutine set_coriolis


subroutine initial_conditions
 ! ----------------------------------
 !      add here initial conditions
 ! ----------------------------------
 use pyOM_module   
 use config_module   
 implicit none
 integer :: i,j,k
 back=0.
 do k=1,nz
    back(:,:,k,1)=(back(:,:,k,1)-N_0**2*zt(k))*maskT(:,:,k)
 enddo
 back(:,:,:,2)=back(:,:,:,1)
 back(:,:,:,3)=back(:,:,:,1)
end subroutine initial_conditions



subroutine boundary_conditions
 ! ----------------------------------
 !    add here boundary conditions
 ! ----------------------------------
 use pyOM_module   
 use config_module   
 implicit none
 include "netcdf.inc"
 integer :: i,j,k,iret,ncid,vid
 real *8 :: taux(nx,ny),tauy(nx,ny)

 iret=nf_open('real_global_wind.cdf',NF_NOWRITE,ncid)
 iret=nf_inq_varid(ncid,'taux',vid)
 iret= nf_get_vara_double(ncid,vid,(/1,1,1/),(/nx,ny,1/),taux)
 iret=nf_inq_varid(ncid,'tauy',vid)
 iret= nf_get_vara_double(ncid,vid,(/1,1,1/),(/nx,ny,1/),tauy)
 call ncclos (ncid, iret)
 ! dyn/cm^2  = 10^-5 N/cm^2 = 10^-1 N/m^2 = 1 kg m/s^2 /m^2 
 ! N/m^2 /rho = 1 kg m/s^2 /m^2  m^3/kg = 1m^2/s^2 
 where( taux <= -1e10 ) taux = 0.0
 where( tauy <= -1e10 ) tauy = 0.0
 do j=1,ny 
   do i=1,nx 
    surface_taux(i,j) = tau0*(taux(i,j)+taux(i,j-1))/2. /1e4  ! m^2/s^2 
    surface_tauy(i,j) = tau0*(tauy(i,j)+tauy(i-1,j))/2. /1e4  ! m^2/s^2 
   enddo
 enddo
end subroutine boundary_conditions

subroutine topography
 ! ----------------------------------
 !      Add here topography  
 ! ----------------------------------
 use pyOM_module   
 use config_module   
 implicit none
 include "netcdf.inc"
 integer :: i,j,k,iret,ncid,vid
 real *8 :: topo(nx,ny)

 iret=nf_open('real_global_topo.cdf',NF_NOWRITE,ncid)
 iret=nf_inq_varid(ncid,'rose',vid)
 iret= nf_get_vara_double(ncid,vid,(/1,1/),(/nx,ny/),topo)
 call ncclos (ncid, iret)
 do j=1,ny 
   do i=1,nx 
     k= minloc( (zt+topo(i,j))**2,1)
     k=min(nz,max(1,k))
     maskT(i,j,1:k) = 0.0
   enddo
 enddo
end subroutine topography

subroutine restoring_zones
end subroutine restoring_zones

subroutine momentum_restoring_zones
end subroutine momentum_restoring_zones

subroutine tracer_sources
end subroutine tracer_sources


