
!=======================================================================
!  A high resolution horizontal gyre circulation
!  with a shelf at western boundary
!=======================================================================


module config_module
 ! use this module only locally in this file
 implicit none
 real*8,parameter :: hRESOLVE = 2.0  ! 2 in original model 
 real*8,parameter :: vRESOLVE = 2.0  ! 2 in original model
 real*8,parameter :: rho_0 =1024.0, g=9.81
 real*8,parameter :: pi      = 3.14159265358979323846264338327950588
 real*8,parameter :: omega   = pi/43082.0 ! earth rotation freq. in 1/s
 real*8,parameter :: radius  = 6370.0e3,degtom = radius/180.0*pi
 real*8 :: N_0 = 5e-3, phi0 = 30. , tau0 = -0.1 
end module config_module


subroutine set_parameter
 use pyOM_module
 use fcontrol_module
 use config_module
 implicit none
 real*8 :: beta,uu,mlen,ilen,blen,rlen
 nx   = 80*hRESOLVE 
 ny   = 80*hRESOLVE
 nz   = 20*vRESOLVE
 dx   = 20.0e3/hRESOLVE
 dz   = 150.000/vRESOLVE
 dt   = 2400.0/hRESOLVE
 K_h=00.0
 A_h=000!  zero in original model
 K_v=1.e-4
 A_v=1.e-3
 Ahbi = 0.5e12 /hRESOLVE**4
 Khbi  = Ahbi

 eps2D_sor = 1e-9
 enable_hydrostatic          = .true.
 enable_noslip               = .true.
 enable_biharmonic_friction  = .true. ! was on in original model
 enable_quicker_advection    = .true.
 enable_back_state           = .true.
 !enable_pv_mixing            = .true. ! was off in original model

 runlen  = 365.0*86400. ! 1 year in original model
 snapint = 3.0*86400.

 beta =  2*omega*cos(phi0/180.*pi)/radius
 uu   =  abs(tau0)/(rho_0*dz*nx*dx*beta) 
 ! (A psi/L^4, Apsi/L^6) = beta psi/L  -> (L^3,L^5) =A/beta
 mlen  = max( (A_h/beta)**(1./3.), (Ahbi/beta)**(1./5.) )
 ilen  =  (uu/beta)**(1./2.)
 rlen = N_0*dz*(nz-2)/( 2*omega*sin(phi0/180.*pi) *pi)
 if (my_pe==0) then
  print*,' grid scale     = ', dx/1e3 , ' km'
  print*,' Rossby radius  = ', rlen /1e3,' km'
  print*,' Munk scale     = ', mlen/1e3 , ' km'
  print*,' Velocity scale = ', uu ,' m/s'
  print*,' Inertial scale = ', ilen/1e3,' km'
  ! U U/L = (A U/L^2, A U/L^4),  Re = (U L/A, U L^3/A  )
  print*,' Grid Reynolds number       = ', min( uu*dx/max(1.d0,A_h) ,  uu*dx**3/ahbi) 
  print*,' Reynolds number munk scale = ', min( uu*mlen/max(1.d0,A_h) ,  uu*mlen**3/ahbi) 
  print*,' Reynolds number Rossby rad.= ', min( uu*rlen/max(1.d0,A_h) ,  uu*rlen**3/ahbi) 
  print*,' Reynolds number basin scale = ', min( uu*dx*nx/max(1.d0,A_h) ,  uu*(nx*dx)**3/ahbi) 
 endif
end subroutine set_parameter


subroutine set_coriolis
 use pyOM_module   
 use config_module
 implicit none
 integer :: j
 do j=1,ny
  coriolis_t(j) = 2*omega*sin(phi0/180.*pi) + 2*omega*cos(phi0/180.*pi)/radius*yt(j)
 enddo
end subroutine set_coriolis


subroutine initial_conditions
 use pyOM_module
 use config_module
 implicit none
 integer :: i,j,k
 do k=1,nz
  do j=1,ny
    do i=1,nx
      back(i,j,k,:) = (-N_0**2*zt(k))*maskT(i,j,k)
    enddo
  enddo
 enddo
end subroutine initial_conditions


subroutine boundary_conditions
 use pyOM_module
 use config_module
   implicit none
   integer :: i,j
   real*8 :: y
! units are m^2/s^3  
! since  b_z = N^2   b[m/s^2]   b_t = F_z   [m/s^3]=[ m^2/s^3]_z
      do j=1,ny
       do i=1,nx
        y = (yu(j)-yu(1))/ (yu(ny)-yu(1))
        surface_taux(i,j) = tau0/rho_0 *cos(2*pi*y)*maskU(i,j,nz-1)
        surface_tauy(i,j) = 0.0*maskV(i,j,nz-1)
       enddo
      enddo
end subroutine boundary_conditions

subroutine topography
   use pyOM_module
   implicit none
   integer :: i,k
   real*8 :: z,h0
   h0 = zt(1)
   do k=2,nz-1
    do i=1,nx
     z=h0*min(1.d0,xt(i)/200e3)    ! 200e3 in original model
     if (zt(k).lt.z) maskT(i,:,k)=0.0
    enddo
   enddo
end subroutine topography

subroutine restoring_zones
end subroutine restoring_zones

subroutine momentum_restoring_zones
end subroutine momentum_restoring_zones

subroutine tracer_sources
end subroutine tracer_sources


