
!=======================================================================
!     Templates for setup
!     Exp. Ridge in Olbers and Eden, JPO, 2003
!     Impact of topography on gyre circulation
!=======================================================================

 subroutine set_parameter
      use pyOM_module
      use fcontrol_module
      implicit none

      nx=20;nz=12;ny=20
      dx=2.0*60*1852.0
      dz=500.0
      dt=3600.0*2
      K_h=00.0
      K_v=1.e-4
      A_h=2e5
      A_v=1.e-3
      eps2D_sor = 1e-9
      enable_noslip               = .true.
      enable_hydrostatic          = .true.
      enable_quicker_advection    = .true.
      enable_quicker_mom_advection= .false.
      enable_back_state           = .true.
      runlen=10*365.0*86400.
      snapint = 5.0*86400.
 end subroutine set_parameter

subroutine set_coriolis
      use pyOM_module   
      implicit none
! ----------------------------------
!      add here initial conditions
! ----------------------------------
   integer :: j
   real*8,parameter :: pi=3.1415   
   real*8,parameter :: radius  = 6370.0e3   ! earth radius
   real*8,parameter :: omega   = pi/43082.0 ! earth rotation freq. in 1/s
   real*8,parameter :: phi0 = 30.0 /180. *pi
   do j=1,ny
    coriolis_t(j) = 2*omega*sin(phi0) + 2*omega*cos(phi0)/radius*yt(j)
   enddo
end subroutine set_coriolis

subroutine initial_conditions
      use pyOM_module
      implicit none
      integer :: i,j,k
      real*8 :: N_0=2.6e-3
      do k=1,nz
       do j=1,ny
        do i=1,nx
         back(i,j,k,:) = (-N_0**2*zt(k))*maskT(i,j,k)
        enddo
       enddo
     enddo
end subroutine initial_conditions


subroutine boundary_conditions
   use pyOM_module
   implicit none
   integer :: i,j
   real*8 :: y, pi=3.1415   
! units are m^2/s^3  
! since  b_z = N^2   b[m/s^2]   b_t = F_z   [m/s^3]=[ m^2/s^3]_z
      do j=1,ny
       do i=1,nx
        y = (yu(j)-yu(1))/ (yu(ny)-yu(1))
        surface_taux(i,j) = -0.5e-4*cos(2*pi*y)*maskU(i,j,nz-1)
        surface_tauy(i,j) = 0.0*maskV(i,j,nz-1)
       enddo
      enddo
end subroutine boundary_conditions


subroutine topography
   use pyOM_module
   implicit none
   integer :: i,k
   real*8 :: z,h0
   h0 = -zt(1)
   do k=2,nz-1
     do i=1,nx
      z=H0*(1-0.3*exp(-(xt(i)-xt(nx/2))**2/800e3**2 ) )
     if (zt(k).lt.-z) maskT(i,:,k)=0.0
     enddo
    enddo
end subroutine topography

subroutine restoring_zones
end subroutine restoring_zones

subroutine momentum_restoring_zones
end subroutine momentum_restoring_zones

subroutine tracer_sources
end subroutine tracer_sources


